/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Map;

public class SyncUtil {
    private static int[] calculateImap(DataSet dataSet, DataSet dataSet2) {
        int[] nArray = new int[dataSet2.getXLength()];
        Units units = dataSet.getXUnits();
        Datum datum = (Datum)dataSet.getProperty("xTagWidth");
        if (datum == null) {
            datum = DataSetUtil.guessXTagWidth(dataSet);
        }
        for (int i = 0; i < nArray.length; ++i) {
            double d = dataSet2.getXTagDouble(i, units);
            nArray[i] = DataSetUtil.closestColumn(dataSet, d, units);
            Datum datum2 = dataSet.getXTagDatum(nArray[i]);
            if (!(Math.abs(datum2.subtract(d, units).doubleValue(units)) > datum.doubleValue(units) / 2.0)) continue;
            nArray[i] = -1;
        }
        return nArray;
    }

    private static int[] calculateImapForWidthTags(DataSet dataSet, DataSet dataSet2) {
        int[] nArray = new int[dataSet2.getXLength()];
        Units units = dataSet.getXUnits();
        Units units2 = units.getOffsetUnits();
        String string = "xTagWidth";
        VectorDataSet vectorDataSet = (VectorDataSet)dataSet.getPlanarView(string);
        int n = dataSet.getXLength();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
            double d = dataSet2.getXTagDouble(i, units);
            double d2 = -999.0;
            for (int j = 0; (d2 == -999.0 || d2 <= d) && j < n; ++j) {
                d2 = dataSet.getXTagDouble(j, units);
                double d3 = d2 + vectorDataSet.getDouble(j, units2);
                if (!(d2 <= d) || !(d < d3)) continue;
                nArray[i] = j;
            }
        }
        return nArray;
    }

    public static DataSet synchronizeNearestNeighbor(DataSet dataSet, DataSet dataSet2) {
        if (dataSet instanceof VectorDataSet) {
            return NearestNeighborVectorDataSet.create((VectorDataSet)dataSet, dataSet2);
        }
        throw new IllegalArgumentException("Unsupported DataSet Type: " + dataSet);
    }

    private static class NearestNeighborVectorDataSet
    implements VectorDataSet {
        VectorDataSet source;
        int[] imap;
        double[] xtags;

        NearestNeighborVectorDataSet(VectorDataSet vectorDataSet, int[] nArray, double[] dArray) {
            this.source = vectorDataSet;
            this.imap = nArray;
            this.xtags = dArray;
        }

        private static NearestNeighborVectorDataSet create(VectorDataSet vectorDataSet, DataSet dataSet) {
            if (vectorDataSet.getPlanarView("xTagWidth") != null) {
                return new NearestNeighborVectorDataSet(vectorDataSet, SyncUtil.calculateImapForWidthTags(vectorDataSet, dataSet), DataSetUtil.getXTagArrayDouble(dataSet, vectorDataSet.getXUnits()));
            }
            return new NearestNeighborVectorDataSet(vectorDataSet, SyncUtil.calculateImap(vectorDataSet, dataSet), DataSetUtil.getXTagArrayDouble(dataSet, vectorDataSet.getXUnits()));
        }

        public Datum getDatum(int n) {
            if (this.imap[n] != -1) {
                return this.source.getDatum(this.imap[n]);
            }
            return this.source.getYUnits().createDatum(this.source.getYUnits().getFillDouble());
        }

        public double getDouble(int n, Units units) {
            if (this.imap[n] != -1) {
                return this.source.getDouble(this.imap[n], units);
            }
            return units.getFillDouble();
        }

        public int getInt(int n, Units units) {
            if (this.imap[n] != -1) {
                return this.source.getInt(this.imap[n], units);
            }
            return units.getFillInt();
        }

        public DataSet getPlanarView(String string) {
            return new NearestNeighborVectorDataSet((VectorDataSet)this.source.getPlanarView(string), this.imap, this.xtags);
        }

        public String[] getPlaneIds() {
            return this.source.getPlaneIds();
        }

        public Object getProperty(String string) {
            return this.source.getProperty(string);
        }

        public Map getProperties() {
            return this.source.getProperties();
        }

        public int getXLength() {
            return this.imap.length;
        }

        public Datum getXTagDatum(int n) {
            return this.getXUnits().createDatum(this.xtags[n]);
        }

        public double getXTagDouble(int n, Units units) {
            return this.getXUnits().convertDoubleTo(units, this.imap[n]);
        }

        public int getXTagInt(int n, Units units) {
            throw new IllegalArgumentException("not implemented");
        }

        public Units getXUnits() {
            return this.source.getXUnits();
        }

        public Units getYUnits() {
            return this.source.getYUnits();
        }
    }
}

