/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;

public class RebinDescriptor {
    Units units;
    protected double start;
    protected double end;
    protected int nBin;
    protected boolean isLog = false;
    public static final int FIRSTORLAST = -2;
    public static final int MINUSONE = -3;
    public static final int EXTRAPOLATE = -4;
    private int outOfBoundsAction = -4;

    private RebinDescriptor() {
    }

    public RebinDescriptor(double d, double d2, Units units, int n, boolean bl) {
        this.units = units;
        if (bl) {
            this.start = Math.log(d);
            this.end = Math.log(d2);
        } else {
            this.start = d;
            this.end = d2;
        }
        this.nBin = n;
        this.isLog = bl;
    }

    public RebinDescriptor(Datum datum, Datum datum2, int n, boolean bl) {
        this(datum.doubleValue(datum.getUnits()), datum2.doubleValue(datum2.getUnits()), datum.getUnits(), n, bl);
        if (datum.getUnits() != datum2.getUnits()) {
            throw new IllegalArgumentException("start and end units differ");
        }
    }

    public int numberOfBins() {
        return this.nBin;
    }

    public int whichBin(double d, Units units) {
        if (units != this.units) {
            d = Units.getConverter(units, this.units).convert(d);
        }
        int n = 0;
        if (this.isLog) {
            d = Math.log(d);
        }
        if ((d < this.start || d >= this.end) && this.outOfBoundsAction != -4) {
            switch (this.outOfBoundsAction) {
                case -2: {
                    n = d < this.start ? 0 : this.nBin - 1;
                }
                case -3: {
                    n = -1;
                }
            }
        } else {
            n = (int)((d - this.start) * (double)this.nBin / (this.end - this.start));
        }
        return n;
    }

    public DatumVector binCentersDV() {
        double[] dArray = this.binCenters();
        return DatumVector.newDatumVector(dArray, this.units);
    }

    public double[] binCenters() {
        int n;
        double[] dArray = new double[this.nBin];
        for (n = 0; n < this.nBin; ++n) {
            dArray[n] = this.start + ((double)n + 0.5) / (double)this.nBin * (this.end - this.start);
        }
        if (this.isLog) {
            for (n = 0; n < this.nBin; ++n) {
                dArray[n] = Math.exp(dArray[n]);
            }
        }
        return dArray;
    }

    public double binCenter(int n, Units units) {
        UnitsConverter unitsConverter = this.units.getConverter(units);
        double d = this.start + ((double)n + 0.5) / (double)this.nBin * (this.end - this.start);
        if (this.isLog) {
            return unitsConverter.convert(Math.exp(d));
        }
        return unitsConverter.convert(d);
    }

    public Datum binCenter(int n) {
        return Datum.create(this.binCenter(n, this.units), this.units);
    }

    public Datum binStart(int n) {
        return Datum.create(this.binStart(n, this.units), this.units);
    }

    public double binStart(int n, Units units) {
        if (this.outOfBoundsAction != -4 && (n < 0 || n >= this.numberOfBins())) {
            throw new IllegalArgumentException("bin " + n + " is out of bounds");
        }
        double d = this.start + (double)n / (double)this.nBin * (this.end - this.start);
        UnitsConverter unitsConverter = this.units.getConverter(units);
        if (this.isLog) {
            return unitsConverter.convert(Math.exp(d));
        }
        return unitsConverter.convert(d);
    }

    public Datum binStop(int n) {
        return Datum.create(this.binStop(n, this.units), this.units);
    }

    public double binStop(int n, Units units) {
        if (this.outOfBoundsAction != -4 && (n < 0 || n >= this.numberOfBins())) {
            throw new IllegalArgumentException("bin " + n + " is out of bounds");
        }
        double d = this.start + (double)(n + 1) / (double)this.nBin * (this.end - this.start);
        UnitsConverter unitsConverter = this.units.getConverter(units);
        if (this.isLog) {
            return unitsConverter.convert(Math.exp(d));
        }
        return unitsConverter.convert(d);
    }

    public double[] binStarts() {
        int n;
        double[] dArray = new double[this.nBin];
        for (n = 0; n < this.nBin; ++n) {
            dArray[n] = this.start + (double)((float)n / (float)this.nBin) * (this.end - this.start);
        }
        if (this.isLog) {
            for (n = 0; n < this.nBin; ++n) {
                dArray[n] = Math.exp(dArray[n]);
            }
        }
        return dArray;
    }

    public double[] binStops() {
        int n;
        double[] dArray = new double[this.nBin];
        for (n = 0; n < this.nBin; ++n) {
            dArray[n] = this.start + (double)((float)(n + 1) / (float)this.nBin) * (this.end - this.start);
        }
        if (this.isLog) {
            for (n = 0; n < this.nBin; ++n) {
                dArray[n] = Math.exp(dArray[n]);
            }
        }
        return dArray;
    }

    public void setOutOfBoundsAction(int n) {
        this.outOfBoundsAction = n;
    }

    private Object clone(int n) {
        RebinDescriptor rebinDescriptor = new RebinDescriptor();
        rebinDescriptor.units = this.units;
        rebinDescriptor.start = this.start;
        rebinDescriptor.end = this.end;
        rebinDescriptor.nBin = this.nBin;
        rebinDescriptor.isLog = this.isLog;
        rebinDescriptor.outOfBoundsAction = n;
        return rebinDescriptor;
    }

    public static RebinDescriptor createSubsumingRebinDescriptor(RebinDescriptor rebinDescriptor, Datum datum, Datum datum2) {
        Units units;
        if (rebinDescriptor == null) {
            return null;
        }
        RebinDescriptor rebinDescriptor2 = (RebinDescriptor)rebinDescriptor.clone(-4);
        int n = rebinDescriptor2.whichBin(datum.doubleValue(units = rebinDescriptor.getUnits()), units);
        if (n > 0) {
            n = 0;
            datum = units.createDatum(rebinDescriptor.binStart(0, units));
        }
        if (n < -10000000) {
            throw new IllegalArgumentException("ymin would result in impossibly large rebin descriptor (ymin=" + datum + " falls in bin number " + n + ")");
        }
        int n2 = rebinDescriptor2.whichBin(datum2.doubleValue(units), units);
        if (n2 < rebinDescriptor2.numberOfBins()) {
            n2 = rebinDescriptor2.numberOfBins();
            datum2 = units.createDatum(rebinDescriptor2.binStop(rebinDescriptor2.numberOfBins() - 1, units));
        }
        if (n > 10000000) {
            throw new IllegalArgumentException("ymax would result in impossibly large rebin descriptor (ymax=" + datum2 + " falls in bin number " + n + ")");
        }
        int n3 = n2 - n + 1;
        return new RebinDescriptor(units.createDatum(rebinDescriptor2.binStart(n, units)), units.createDatum(rebinDescriptor2.binStop(n2, units)), n3, rebinDescriptor2.isLog());
    }

    public double binWidth() {
        return (this.end - this.start) / (double)this.nBin;
    }

    public Datum binWidthDatum() {
        return Datum.create(this.binWidth(), this.getUnits().getOffsetUnits());
    }

    public boolean isLog() {
        return this.isLog;
    }

    public Units getUnits() {
        return this.units;
    }

    public String toString() {
        return "[" + this.units.createDatum(this.start) + " - " + this.units.createDatum(this.end) + " in " + this.nBin + " bins " + (this.isLog ? "Log" : "") + "]";
    }
}

