/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Arrays;
import java.util.Collections;

public class PeakTableRebinner
implements DataSetRebinner {
    public DataSet rebin(DataSet dataSet, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) throws IllegalArgumentException {
        Object object;
        double[] dArray;
        if (!(dataSet instanceof TableDataSet)) {
            throw new IllegalArgumentException();
        }
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        long l = System.currentTimeMillis();
        int n = rebinDescriptor == null ? tableDataSet.getXLength() : rebinDescriptor.numberOfBins();
        int n2 = rebinDescriptor2 == null ? tableDataSet.getYLength(0) : rebinDescriptor2.numberOfBins();
        double[][] dArray2 = new double[n][n2];
        double[][] dArray3 = new double[n][n2];
        PeakTableRebinner.peaks(tableDataSet, dArray2, rebinDescriptor, rebinDescriptor2);
        if (rebinDescriptor != null) {
            dArray = rebinDescriptor.binCenters();
        } else {
            dArray = new double[tableDataSet.getXLength()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = tableDataSet.getXTagDouble(i, tableDataSet.getXUnits());
            }
        }
        if (rebinDescriptor2 != null) {
            object = new double[][]{rebinDescriptor2.binCenters()};
        } else {
            object = new double[0][tableDataSet.getYLength(0)];
            for (int i = 0; i < object[0].length; ++i) {
                object[0][i] = tableDataSet.getYTagDouble(0, i, tableDataSet.getYUnits());
            }
        }
        double[][][] dArrayArray = new double[][][]{dArray2};
        int[] nArray = new int[]{0};
        Units[] unitsArray = new Units[]{tableDataSet.getZUnits()};
        String[] stringArray = new String[]{""};
        return new DefaultTableDataSet(dArray, tableDataSet.getXUnits(), (double[][])object, tableDataSet.getYUnits(), (double[][][])dArrayArray, unitsArray, stringArray, nArray, Collections.EMPTY_MAP);
    }

    static void peaks(TableDataSet tableDataSet, double[][] dArray, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) {
        int n;
        int n2;
        double[] dArray2;
        if (rebinDescriptor2 != null) {
            dArray2 = rebinDescriptor2.binCenters();
        } else {
            dArray2 = new double[tableDataSet.getYLength(0)];
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                dArray2[n2] = tableDataSet.getDouble(0, n2, tableDataSet.getYUnits());
            }
        }
        n2 = rebinDescriptor == null ? tableDataSet.getXLength() : rebinDescriptor.numberOfBins();
        int n3 = rebinDescriptor2 == null ? tableDataSet.getYLength(0) : rebinDescriptor2.numberOfBins();
        for (int i = 0; i < dArray.length; ++i) {
            Arrays.fill(dArray[i], Double.NaN);
        }
        int[] nArray = new int[tableDataSet.getYLength(0)];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = rebinDescriptor2 != null ? rebinDescriptor2.whichBin(tableDataSet.getYTagDouble(0, n, tableDataSet.getYUnits()), tableDataSet.getYUnits()) : n;
        }
        for (n = 0; n < tableDataSet.getXLength(); ++n) {
            int n4 = rebinDescriptor != null ? rebinDescriptor.whichBin(tableDataSet.getXTagDouble(n, tableDataSet.getXUnits()), tableDataSet.getXUnits()) : n;
            if (n4 < 0 || n4 >= n2) continue;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0 || nArray[i] >= n3) continue;
                double d = tableDataSet.getDouble(n, i, tableDataSet.getZUnits());
                dArray[n4][nArray[i]] = Double.isNaN(dArray[n4][nArray[i]]) ? d : Math.max(d, dArray[n4][nArray[i]]);
            }
        }
    }
}

