/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.XSliceDataSet;
import edu.uiowa.physics.pw.das.dataset.YSliceDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsUtil;
import java.util.Map;

public class NearestNeighborTableDataSet
implements TableDataSet {
    TableDataSet source;
    int[] imap;
    int[][] jmap;
    int[] itableMap;
    RebinDescriptor ddX;
    RebinDescriptor ddY;

    NearestNeighborTableDataSet(TableDataSet tableDataSet, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) {
        this.imap = new int[rebinDescriptor.numberOfBins()];
        if (rebinDescriptor2 == null) {
            if (tableDataSet.tableCount() > 1) {
                throw new IllegalArgumentException();
            }
            this.jmap = new int[tableDataSet.tableCount()][tableDataSet.getYLength(0)];
        } else {
            this.jmap = new int[tableDataSet.tableCount()][rebinDescriptor2.numberOfBins()];
        }
        this.itableMap = new int[rebinDescriptor.numberOfBins()];
        this.ddX = rebinDescriptor;
        this.ddY = rebinDescriptor2;
        this.source = tableDataSet;
        if (tableDataSet.getXLength() == 0) {
            for (int i = 0; i < this.imap.length; ++i) {
                this.imap[i] = -1;
            }
        } else {
            Datum datum = (Datum)tableDataSet.getProperty("xTagWidth");
            Datum datum2 = (Datum)tableDataSet.getProperty("yTagWidth");
            if (datum == null) {
                datum = DataSetUtil.guessXTagWidth(tableDataSet);
            }
            if (datum2 == null) {
                datum2 = TableUtil.guessYTagWidth(tableDataSet);
            }
            DatumVector datumVector = rebinDescriptor.binCentersDV();
            double[] dArray = rebinDescriptor2 == null ? TableUtil.getYTagArrayDouble(tableDataSet, 0, tableDataSet.getYUnits()) : rebinDescriptor2.binCenters();
            int n = -1;
            int n2 = 0;
            for (int i = 0; i < this.imap.length; ++i) {
                int n3;
                int n4;
                this.imap[i] = DataSetUtil.closestColumn((DataSet)tableDataSet, datumVector.get(i), n2);
                n2 = this.imap[i];
                Datum datum3 = tableDataSet.getXTagDatum(this.imap[i]);
                Units units = datum.getUnits();
                if (Math.abs(datum3.subtract(datumVector.get(i)).doubleValue(units)) > datum.doubleValue(units) / 1.9) {
                    this.imap[i] = -1;
                    continue;
                }
                this.itableMap[i] = n4 = tableDataSet.tableOfIndex(this.imap[i]);
                if (n == n4) continue;
                if (rebinDescriptor2 == null) {
                    for (n3 = 0; n3 < this.jmap[n4].length; ++n3) {
                        this.jmap[n4][n3] = n3;
                    }
                } else {
                    for (n3 = 0; n3 < this.jmap[n4].length; ++n3) {
                        this.jmap[n4][n3] = TableUtil.closestRow(tableDataSet, n4, dArray[n3], rebinDescriptor2.getUnits());
                        Units units2 = datum2.getUnits();
                        if (UnitsUtil.isRatiometric(units2)) {
                            double d = tableDataSet.getYTagDouble(n4, this.jmap[n4][n3], rebinDescriptor2.getUnits());
                            if (!(Math.abs(Math.log(dArray[n3] / d)) > datum2.doubleValue(Units.logERatio))) continue;
                            this.jmap[n4][n3] = -1;
                            continue;
                        }
                        Datum datum4 = tableDataSet.getYTagDatum(n4, this.jmap[n4][n3]);
                        if (!(Math.abs(datum4.subtract(dArray[n3], rebinDescriptor2.getUnits()).doubleValue(units2)) > datum2.doubleValue(units2))) continue;
                        this.jmap[n4][n3] = -1;
                    }
                }
                n = n4;
            }
        }
    }

    public Datum getDatum(int n, int n2) {
        if (this.imap[n] != -1 && this.jmap[this.itableMap[n]][n2] != -1) {
            return this.source.getDatum(this.imap[n], this.jmap[this.itableMap[n]][n2]);
        }
        return this.source.getZUnits().createDatum(this.source.getZUnits().getFillDouble());
    }

    public double getDouble(int n, int n2, Units units) {
        try {
            if (this.imap[n] != -1 && this.jmap[this.itableMap[n]][n2] != -1) {
                return this.source.getDouble(this.imap[n], this.jmap[this.itableMap[n]][n2], units);
            }
            return this.source.getZUnits().getFillDouble();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("here: " + arrayIndexOutOfBoundsException);
            throw new RuntimeException(arrayIndexOutOfBoundsException);
        }
    }

    public int getInt(int n, int n2, Units units) {
        if (this.imap[n] != -1 && this.jmap[this.itableMap[n]][n2] != -1) {
            return this.source.getInt(this.imap[n], this.jmap[this.itableMap[n]][n2], units);
        }
        return this.source.getZUnits().getFillInt();
    }

    public DataSet getPlanarView(String string) {
        TableDataSet tableDataSet = (TableDataSet)this.source.getPlanarView(string);
        if (tableDataSet != null) {
            return new NearestNeighborTableDataSet(tableDataSet, this.ddX, this.ddY);
        }
        return null;
    }

    public String[] getPlaneIds() {
        return this.source.getPlaneIds();
    }

    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    public Map getProperties() {
        return this.source.getProperties();
    }

    public int getXLength() {
        return this.imap.length;
    }

    public VectorDataSet getXSlice(int n) {
        return new XSliceDataSet(this, n);
    }

    public VectorDataSet getYSlice(int n, int n2) {
        return new YSliceDataSet(this, n, n2);
    }

    public Datum getXTagDatum(int n) {
        return this.ddX.getUnits().createDatum(this.getXTagDouble(n, this.ddX.getUnits()));
    }

    public double getXTagDouble(int n, Units units) {
        return this.ddX.binCenter(n, units);
    }

    public int getXTagInt(int n, Units units) {
        return (int)this.getXTagDouble(n, units);
    }

    public Units getXUnits() {
        return this.ddX.getUnits();
    }

    public int getYLength(int n) {
        if (this.ddY == null) {
            return this.source.getYLength(n);
        }
        return this.ddY.numberOfBins();
    }

    public Datum getYTagDatum(int n, int n2) {
        if (this.ddY == null) {
            return this.source.getYTagDatum(n, n2);
        }
        return this.ddY.getUnits().createDatum(this.getYTagDouble(n, n2, this.ddY.getUnits()));
    }

    public double getYTagDouble(int n, int n2, Units units) {
        if (this.ddY == null) {
            return this.source.getYTagDouble(n, n2, units);
        }
        return this.ddY.binCenter(n2, units);
    }

    public int getYTagInt(int n, int n2, Units units) {
        return (int)this.getYTagDouble(n, n2, units);
    }

    public Units getYUnits() {
        if (this.ddY == null) {
            return this.source.getYUnits();
        }
        return this.ddY.getUnits();
    }

    public Units getZUnits() {
        return this.source.getZUnits();
    }

    public int tableCount() {
        return 1;
    }

    public int tableEnd(int n) {
        return this.ddX.numberOfBins();
    }

    public int tableOfIndex(int n) {
        return 0;
    }

    public int tableStart(int n) {
        return 0;
    }

    public String toString() {
        return "NearestNeighborTableDataSet " + TableUtil.toString(this);
    }

    public double[] getDoubleScan(int n, Units units) {
        int n2 = this.getYLength(this.tableOfIndex(n));
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.getDouble(n, i, units);
        }
        return dArray;
    }

    public DatumVector getScan(int n) {
        Units units = this.getZUnits();
        return DatumVector.newDatumVector(this.getDoubleScan(n, units), units);
    }

    public DatumVector getYTags(int n) {
        double[] dArray = new double[this.getYLength(n)];
        Units units = this.getYUnits();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getYTagDouble(n, i, units);
        }
        return DatumVector.newDatumVector(dArray, units);
    }
}

