/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.AbstractDataSetCache;
import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.ArrayList;
import java.util.List;

public class LimitSizeBytesDataSetCache
extends AbstractDataSetCache {
    List entries = new ArrayList();
    long totalSize = 0L;
    long totalSizeLimit;

    public LimitSizeBytesDataSetCache(long l) {
        this.totalSizeLimit = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractDataSetCache.Entry findStored(DataSetDescriptor dataSetDescriptor, CacheTag cacheTag) {
        AbstractDataSetCache.Entry entry = new AbstractDataSetCache.Entry(this, dataSetDescriptor, cacheTag, null);
        ArrayList arrayList = new ArrayList();
        AbstractDataSetCache.Entry entry2 = null;
        List list = this.entries;
        synchronized (list) {
            for (AbstractDataSetCache.Entry entry3 : this.entries) {
                if (!entry3.satifies(entry)) continue;
                entry2 = entry3;
            }
        }
        return entry2;
    }

    boolean haveStoredImpl(DataSetDescriptor dataSetDescriptor, CacheTag cacheTag) {
        AbstractDataSetCache.Entry entry = this.findStored(dataSetDescriptor, cacheTag);
        return entry != null;
    }

    public void reset() {
        this.entries.removeAll(this.entries);
        this.totalSize = 0L;
    }

    DataSet retrieveImpl(DataSetDescriptor dataSetDescriptor, CacheTag cacheTag) {
        AbstractDataSetCache.Entry entry = this.findStored(dataSetDescriptor, cacheTag);
        if (entry != null) {
            ++entry.nhits;
            return entry.getData();
        }
        throw new IllegalArgumentException("not found in cache");
    }

    private AbstractDataSetCache.Entry leastValuableEntry() {
        AbstractDataSetCache.Entry entry = (AbstractDataSetCache.Entry)this.entries.get(0);
        long l = this.cacheValue(entry);
        for (AbstractDataSetCache.Entry entry2 : this.entries) {
            long l2 = this.cacheValue(entry2);
            if (l2 >= l) continue;
            entry = entry2;
            l = l2;
        }
        return entry;
    }

    public void store(DataSetDescriptor dataSetDescriptor, CacheTag cacheTag, DataSet dataSet) {
        long l = DataSetUtil.guessSizeBytes(dataSet);
        if (l > this.totalSizeLimit) {
            return;
        }
        while (l + this.totalSize > this.totalSizeLimit) {
            AbstractDataSetCache.Entry entry = this.leastValuableEntry();
            long l2 = DataSetUtil.guessSizeBytes(entry.data);
            this.entries.remove(entry);
            this.totalSize -= l2;
        }
        this.entries.add(new AbstractDataSetCache.Entry(this, dataSetDescriptor, cacheTag, dataSet));
        this.totalSize += l;
    }

    public AbstractDataSetCache.Entry[] getEntries() {
        return this.entries.toArray(new AbstractDataSetCache.Entry[this.entries.size()]);
    }

    public AbstractDataSetCache.Entry getEntries(int n) {
        return (AbstractDataSetCache.Entry)this.entries.get(n);
    }

    public Datum getTotalSize() {
        return Units.kiloBytes.createDatum((double)this.totalSize / 1000.0, 0.1);
    }

    public Datum getTotalSizeLimit() {
        return Units.kiloBytes.createDatum((double)this.totalSizeLimit / 1000.0, 0.1);
    }

    public void setTotalSizeLimit(Datum datum) {
        this.totalSizeLimit = (long)(datum.doubleValue(Units.kiloBytes) * 1000.0);
    }

    public Datum getHitRate() {
        return Units.percent.createDatum((double)this.hits * 100.0 / (double)(this.hits + this.misses), 0.1);
    }

    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer("<html>LimitSizeBytesDataSetCache with " + this.entries.size() + " datasets<br><br>");
        for (int i = 0; i < this.entries.size(); ++i) {
            stringBuffer.append("" + this.entries.get(i) + "<br>");
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }
}

