/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.AbstractDataSet;
import edu.uiowa.physics.pw.das.dataset.AbstractVectorDataSet;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class DefaultVectorDataSet
extends AbstractVectorDataSet
implements DataSet,
VectorDataSet {
    private double[][] yValues;
    private String[] planeIDs;
    private Units[] yUnits;

    public DefaultVectorDataSet(double[] dArray, Units units, double[] dArray2, Units units2, Map map) {
        this(dArray, units, dArray2, units2, null, null, map);
    }

    public DefaultVectorDataSet(double[] dArray, Units units, double[] dArray2, Units units2, Map map, Map map2, Map map3) {
        super(dArray, units, units2, map3);
        if (map == null ^ map2 == null) {
            throw new IllegalArgumentException("yValuesMap == null ^ yUnitsMap == null");
        }
        if (map != null) {
            if (!((Object)map.keySet()).equals(map2.keySet())) {
                throw new IllegalArgumentException("mismatched keySets for yValuesMap and yUnitsMap");
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof String) continue;
                throw new IllegalArgumentException("Non-String key found in yValuesMap");
            }
        }
        int n = 1 + (map == null ? 0 : map.size());
        this.yValues = new double[n][];
        this.yValues[0] = (double[])dArray2.clone();
        this.planeIDs = new String[n];
        this.planeIDs[0] = "";
        this.yUnits = new Units[n];
        this.yUnits[0] = units2;
        if (map != null) {
            int n2 = 1;
            for (Map.Entry entry : new TreeMap(map).entrySet()) {
                String string = (String)entry.getKey();
                double[] dArray3 = (double[])entry.getValue();
                this.planeIDs[n2] = string;
                this.yValues[n2] = (double[])dArray3.clone();
                this.yUnits[n2] = (Units)map2.get(string);
            }
        }
    }

    DefaultVectorDataSet(double[] dArray, Units units, double[][] dArray2, Units[] unitsArray, String[] stringArray, Map map) {
        super(dArray, units, unitsArray[0], map);
        this.yValues = dArray2;
        this.yUnits = unitsArray;
        this.planeIDs = stringArray;
    }

    public Datum getDatum(int n) {
        return Datum.create(this.yValues[0][n], this.getYUnits());
    }

    public double getDouble(int n, Units units) {
        if (this.yUnits[0].isFill(this.yValues[0][n])) {
            return units.getFillDouble();
        }
        return this.getYUnits().getConverter(units).convert(this.yValues[0][n]);
    }

    public int getInt(int n, Units units) {
        return (int)Math.round(this.getDouble(n, units));
    }

    public DataSet getPlanarView(String string) {
        int n = -1;
        for (int i = 0; i < this.planeIDs.length; ++i) {
            if (!this.planeIDs[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return null;
        }
        return new PlanarViewDataSet(n);
    }

    public String[] getPlaneIds() {
        String[] stringArray = new String[this.planeIDs.length];
        System.arraycopy(this.planeIDs, 0, stringArray, 0, this.planeIDs.length);
        return stringArray;
    }

    private class PlanarViewDataSet
    extends AbstractDataSet.ViewDataSet
    implements VectorDataSet {
        private final int index;

        private PlanarViewDataSet(int n) {
            super(DefaultVectorDataSet.this);
            this.index = n;
        }

        public Datum getDatum(int n) {
            return Datum.create(DefaultVectorDataSet.this.yValues[this.index][n], DefaultVectorDataSet.this.yUnits[this.index]);
        }

        public double getDouble(int n, Units units) {
            return DefaultVectorDataSet.this.yUnits[this.index].getConverter(units).convert(DefaultVectorDataSet.this.yValues[this.index][n]);
        }

        public int getInt(int n, Units units) {
            return (int)Math.round(this.getDouble(n, units));
        }

        public Units getYUnits() {
            return DefaultVectorDataSet.this.yUnits[this.index];
        }

        public DataSet getPlanarView(String string) {
            return string.equals("") ? this : null;
        }

        public String[] getPlaneIds() {
            return new String[0];
        }

        public Object getProperty(String string) {
            Object object = DefaultVectorDataSet.this.getProperty(DefaultVectorDataSet.this.planeIDs[this.index] + "." + string);
            if (object == null) {
                object = DefaultVectorDataSet.this.getProperty(string);
            }
            return object;
        }

        public String toString() {
            return VectorUtil.toString(this);
        }
    }
}

