/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.dataset.AbstractDataSet;
import edu.uiowa.physics.pw.das.dataset.AbstractTableDataSet;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public final class DefaultTableDataSet
extends AbstractTableDataSet {
    private double[][][] tableData;
    private Units[] zUnits;
    private double[][] yTags;
    final int tableCount;
    private int[] tableOffsets;
    private String[] planeIDs;

    public DefaultTableDataSet(double[] dArray, Units units, double[][] dArray2, Units units2, double[][][] dArray3, Units units3, Map map, Map map2, Map map3) {
        super(dArray, units, units2, units3, map3);
        if (map == null ^ map2 == null) {
            throw new IllegalArgumentException("zValuesMap == null ^ zUnitsMap == null");
        }
        if (map != null && !((Object)map.keySet()).equals(map2.keySet())) {
            throw new IllegalArgumentException("mismatched keySets for zValuesMap and zUnitsMap");
        }
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof String) continue;
                throw new IllegalArgumentException("Non-String key found in zValuesMap");
            }
        }
        int n = 1 + (map == null ? 0 : map.size());
        this.tableData = new double[n][][];
        this.tableData[0] = this.flatten(dArray3);
        this.yTags = DefaultTableDataSet.copy(dArray2);
        this.tableCount = dArray2.length;
        this.zUnits = new Units[n];
        this.zUnits[0] = units3;
        this.planeIDs = new String[n];
        this.planeIDs[0] = "";
        this.tableOffsets = DefaultTableDataSet.computeTableOffsets(dArray3, dArray2);
        if (map != null) {
            int n2 = 1;
            for (Map.Entry entry : new TreeMap(map).entrySet()) {
                String string = (String)entry.getKey();
                double[][][] dArray4 = (double[][][])entry.getValue();
                double[][] dArray5 = this.flatten(dArray4);
                this.planeIDs[n2] = string;
                this.tableData[n2] = dArray5;
                this.zUnits[n2] = (Units)map2.get(string);
            }
        }
    }

    private double[][] flatten(double[][][] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            n += dArray[i].length;
        }
        double[][] dArrayArray = new double[n][];
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArrayArray[n2] = (double[])dArray[i][j].clone();
                ++n2;
            }
        }
        return dArrayArray;
    }

    public static DefaultTableDataSet createSimple(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = dArray3.length;
        int n2 = dArray3[0].length;
        if (dArray.length != n) {
            throw new IllegalArgumentException("xTags (" + dArray.length + ") don't match zValues' first dimension (" + n + "," + n2 + ").");
        }
        if (dArray2.length != n2) {
            throw new IllegalArgumentException("yTags (" + dArray2.length + ") don't match zValues' first dimension (" + n + "," + n2 + ").");
        }
        return new DefaultTableDataSet(dArray, Units.dimensionless, dArray2, Units.dimensionless, dArray3, Units.dimensionless, new HashMap());
    }

    public DefaultTableDataSet(double[] dArray, Units units, double[] dArray2, Units units2, double[][] dArray3, Units units3, Map map) {
        this(dArray, units, (double[][])new double[][]{dArray2}, units2, (double[][][])new double[][][]{dArray3}, units3, null, null, map);
    }

    DefaultTableDataSet(double[] dArray, Units units, double[][] dArray2, Units units2, double[][][] dArray3, Units[] unitsArray, String[] stringArray, int[] nArray, Map map) {
        super(dArray, units, units2, unitsArray[0], map);
        this.yTags = dArray2;
        this.tableCount = dArray2.length;
        this.tableData = dArray3;
        this.zUnits = unitsArray;
        this.planeIDs = stringArray;
        this.tableOffsets = nArray;
    }

    private static double[][][] copy(double[][][] dArray) {
        double[][][] dArrayArray = new double[dArray.length][][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = DefaultTableDataSet.copy(dArray[i]);
        }
        return dArrayArray;
    }

    private static double[][] copy(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = (double[])dArray[i].clone();
        }
        return dArrayArray;
    }

    private static int[] computeTableOffsets(double[][][] dArray, double[][] dArray2) {
        int[] nArray = new int[dArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
            n += dArray[i].length;
        }
        return nArray;
    }

    public Datum getDatum(int n, int n2) {
        int n3 = this.tableOfIndex(n);
        int n4 = this.yTags[n3].length;
        if (n < 0 || n >= this.tableData[0].length) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("x index is out of bounds: " + n + " xLength: " + this.getXLength());
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.throwing(DefaultTableDataSet.class.getName(), "getDatum(int,int)", indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (n2 < 0 || n2 >= this.yTags[n3].length) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("y index is out of bounds: " + n + " yLength(" + n3 + "): " + this.getYLength(n3));
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.throwing(DefaultTableDataSet.class.getName(), "getDatum(int,int)", indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        double d = this.tableData[0][n][n2];
        return Datum.create(d, this.zUnits[0]);
    }

    public DatumVector getScan(int n) {
        int n2 = this.tableOfIndex(n);
        if (n < 0 || n >= this.tableData[0].length) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("x index is out of bounds: " + n + " xLength: " + this.getXLength());
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.throwing(DefaultTableDataSet.class.getName(), "getDatum(int,int)", indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        double[] dArray = this.tableData[0][n];
        return DatumVector.newDatumVector(dArray, 0, this.getYLength(n2), this.zUnits[0]);
    }

    public double getDouble(int n, int n2, Units units) {
        if (n < 0 || n >= this.getXLength()) {
            throw new IndexOutOfBoundsException("i: " + n + ", xLength: " + this.getXLength());
        }
        int n3 = this.tableOfIndex(n);
        int n4 = this.yTags[n3].length;
        if (n2 < 0 || n2 >= n4) {
            throw new IndexOutOfBoundsException("j: " + n2 + ", yLength: " + n4);
        }
        double d = this.tableData[0][n][n2];
        if (units == this.getZUnits()) {
            return d;
        }
        return this.zUnits[0].getConverter(units).convert(d);
    }

    public double[] getDoubleScan(int n, Units units) {
        int n2 = this.tableOfIndex(n);
        int n3 = this.yTags[n2].length;
        double[] dArray = this.tableData[0][n];
        double[] dArray2 = new double[n3];
        if (units == this.getZUnits()) {
            System.arraycopy(dArray, 0, dArray2, 0, n3);
        } else {
            UnitsConverter unitsConverter = this.zUnits[0].getConverter(units);
            for (int i = 0; i < n3; ++i) {
                dArray2[i] = unitsConverter.convert(dArray[i]);
            }
        }
        return dArray2;
    }

    public int getInt(int n, int n2, Units units) {
        return (int)Math.round(this.getDouble(n, n2, units));
    }

    public DataSet getPlanarView(String string) {
        int n = -1;
        for (int i = 0; i < this.planeIDs.length; ++i) {
            if (!this.planeIDs[i].equals(string)) continue;
            n = i;
        }
        if (n == -1) {
            return null;
        }
        return new PlanarViewDataSet(n);
    }

    public String[] getPlaneIds() {
        String[] stringArray = new String[this.planeIDs.length];
        System.arraycopy(this.planeIDs, 0, stringArray, 0, this.planeIDs.length);
        return stringArray;
    }

    public int getYLength(int n) {
        return this.yTags[n].length;
    }

    public Datum getYTagDatum(int n, int n2) {
        double d = this.yTags[n][n2];
        return Datum.create(d, this.getYUnits());
    }

    public double getYTagDouble(int n, int n2, Units units) {
        double d = this.yTags[n][n2];
        if (units == this.getYUnits()) {
            return d;
        }
        return this.getYUnits().getConverter(units).convert(d);
    }

    public int getYTagInt(int n, int n2, Units units) {
        return (int)Math.round(this.getYTagDouble(n, n2, units));
    }

    public DatumVector getYTags(int n) {
        return DatumVector.newDatumVector(this.yTags[n], 0, this.getYLength(n), this.getYUnits());
    }

    public int tableCount() {
        return this.tableCount;
    }

    public int tableEnd(int n) {
        if (n == this.tableOffsets.length - 1) {
            return this.getXLength();
        }
        return this.tableOffsets[n + 1];
    }

    public int tableOfIndex(int n) {
        int n2;
        if (this.yTags.length > 5) {
            int n3 = Arrays.binarySearch(this.tableOffsets, n);
            if (n >= this.getXLength()) {
                throw new IndexOutOfBoundsException(n + " > " + this.getXLength());
            }
            if (n3 < 0) {
                n3 = ~n3 - 1;
            }
            return n3;
        }
        for (n2 = this.tableCount - 1; n2 >= 0 && this.tableOffsets[n2] > n; --n2) {
        }
        return n2;
    }

    public int tableStart(int n) {
        return this.tableOffsets[n];
    }

    public void dump(PrintStream printStream) {
        String string;
        int n;
        MessageFormat messageFormat = new MessageFormat("        {0,number,00}. Y Length: {1,number,000}, Start: {2,number,000}, End: {3,number,000}");
        MessageFormat messageFormat2 = new MessageFormat("        ID: {0}, Z Units: ''{1}''");
        printStream.println("============================================================");
        printStream.println(this.getClass().getName());
        printStream.println("    X Length:    " + this.getXLength());
        printStream.println("    X Units:     '" + this.getXUnits() + "'");
        printStream.print("    X Tags:");
        for (int i = 0; i < this.getXLength(); ++i) {
            printStream.print(" ");
            printStream.print(this.getXTagDouble(i, this.getXUnits()));
        }
        printStream.println();
        printStream.println("    Y Units:     '" + this.getYUnits() + "'");
        printStream.println("    Z Units:     '" + this.getZUnits() + "'");
        printStream.println("    Table Count: " + this.tableCount());
        Object[] objectArray = new Object[4];
        for (n = 0; n < this.tableCount(); ++n) {
            int n2;
            objectArray[0] = new Integer(n);
            objectArray[1] = new Integer(this.yTags[n].length);
            objectArray[2] = new Integer(this.tableStart(n));
            objectArray[3] = new Integer(this.tableEnd(n));
            string = messageFormat.format(objectArray);
            printStream.println(string);
            printStream.print("        Y Tags:");
            for (n2 = 0; n2 < this.getYLength(n); ++n2) {
                printStream.print(" ");
                printStream.print(this.getYTagDouble(n, n2, this.getXUnits()));
            }
            printStream.println();
            printStream.println("        Z Values:");
            for (n2 = 0; n2 < this.getYLength(n); ++n2) {
                printStream.print("        ");
                for (int i = this.tableStart(n); i < this.tableEnd(n); ++i) {
                    printStream.print(this.getDouble(i, n2, this.getZUnits()));
                    printStream.print("\t");
                }
                printStream.println();
            }
        }
        printStream.println("    Plane Count: " + this.planeIDs.length);
        for (n = 1; n < this.planeIDs.length; ++n) {
            objectArray[0] = this.planeIDs[n];
            objectArray[1] = this.zUnits[n];
            string = messageFormat2.format(objectArray);
            printStream.println(string);
        }
        printStream.println("============================================================");
    }

    public String toString() {
        return "DefaultTableDataSet " + TableUtil.toString(this);
    }

    public void printDebugInfo(PrintStream printStream) {
        printStream.println("xLength: " + this.getXLength());
        printStream.println("tableCount: " + this.tableCount());
        for (int i = 0; i < this.tableCount(); ++i) {
            printStream.println("tableStart(" + i + "): " + this.tableStart(i));
            printStream.println("yLength: " + this.getYLength(i));
            for (int j = this.tableStart(i); j < this.tableEnd(i); ++j) {
                printStream.println(j + ": " + this.tableData[0][j].length);
            }
            printStream.println("tableEnd(" + i + "): " + this.tableEnd(i));
        }
    }

    private final class PlanarViewDataSet
    extends AbstractDataSet.ViewDataSet
    implements TableDataSet {
        private final int index;

        private PlanarViewDataSet(int n) {
            this.index = n;
        }

        public DataSet getPlanarView(String string) {
            return string.equals("") ? this : null;
        }

        public String[] getPlaneIds() {
            return new String[0];
        }

        public Datum getDatum(int n, int n2) {
            int n3 = this.tableOfIndex(n);
            int n4 = DefaultTableDataSet.this.yTags[n3].length;
            double d = DefaultTableDataSet.this.tableData[this.index][n][n2];
            return Datum.create(d, DefaultTableDataSet.this.zUnits[this.index]);
        }

        public double getDouble(int n, int n2, Units units) {
            int n3 = this.tableOfIndex(n);
            int n4 = DefaultTableDataSet.this.yTags[n3].length;
            double d = DefaultTableDataSet.this.tableData[this.index][n][n2];
            return DefaultTableDataSet.this.zUnits[this.index].getConverter(units).convert(d);
        }

        public double[] getDoubleScan(int n, Units units) {
            int n2 = this.tableOfIndex(n);
            int n3 = DefaultTableDataSet.this.yTags[n2].length;
            double[] dArray = DefaultTableDataSet.this.tableData[this.index][n];
            double[] dArray2 = new double[n3];
            if (units == this.getZUnits()) {
                System.arraycopy(dArray, 0, dArray2, 0, n3);
            } else {
                UnitsConverter unitsConverter = DefaultTableDataSet.this.zUnits[this.index].getConverter(units);
                for (int i = 0; i < n3; ++i) {
                    dArray2[i] = unitsConverter.convert(dArray[i]);
                }
            }
            return dArray2;
        }

        public DatumVector getScan(int n) {
            int n2 = this.tableOfIndex(n);
            if (n < 0 || n >= DefaultTableDataSet.this.tableData[0].length) {
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("x index is out of bounds: " + n + " xLength: " + this.getXLength());
                Logger logger = DasApplication.getDefaultApplication().getLogger();
                logger.throwing(DefaultTableDataSet.class.getName(), "getDatum(int,int)", indexOutOfBoundsException);
                throw indexOutOfBoundsException;
            }
            double[] dArray = DefaultTableDataSet.this.tableData[this.index][n];
            return DatumVector.newDatumVector(dArray, 0, this.getYLength(n2), DefaultTableDataSet.this.zUnits[this.index]);
        }

        public int getInt(int n, int n2, Units units) {
            return (int)Math.round(this.getDouble(n, n2, units));
        }

        public VectorDataSet getXSlice(int n) {
            return new AbstractTableDataSet.XSliceDataSet(this, n);
        }

        public int getYLength(int n) {
            return DefaultTableDataSet.this.getYLength(n);
        }

        public VectorDataSet getYSlice(int n, int n2) {
            return new AbstractTableDataSet.YSliceDataSet(this, n, n2);
        }

        public Datum getYTagDatum(int n, int n2) {
            return DefaultTableDataSet.this.getYTagDatum(n, n2);
        }

        public double getYTagDouble(int n, int n2, Units units) {
            return DefaultTableDataSet.this.getYTagDouble(n, n2, units);
        }

        public int getYTagInt(int n, int n2, Units units) {
            return DefaultTableDataSet.this.getYTagInt(n, n2, units);
        }

        public Units getZUnits() {
            return DefaultTableDataSet.this.zUnits[this.index];
        }

        public int tableCount() {
            return DefaultTableDataSet.this.tableCount();
        }

        public int tableEnd(int n) {
            return DefaultTableDataSet.this.tableEnd(n);
        }

        public int tableOfIndex(int n) {
            return DefaultTableDataSet.this.tableOfIndex(n);
        }

        public int tableStart(int n) {
            return DefaultTableDataSet.this.tableStart(n);
        }

        public Object getProperty(String string) {
            Object object = DefaultTableDataSet.this.getProperty(DefaultTableDataSet.this.planeIDs[this.index] + "." + string);
            if (object == null) {
                object = DefaultTableDataSet.this.getProperty(string);
            }
            return object;
        }

        public DatumVector getYTags(int n) {
            return DefaultTableDataSet.this.getYTags(n);
        }

        public String toString() {
            return TableUtil.toString(this);
        }
    }
}

