/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.GraphUtil;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.util.Arrays;

public class DataSetUtil {
    public static CacheTag guessCacheTag(DataSet dataSet) {
        if (dataSet.getProperty("cacheTag") != null) {
            return (CacheTag)dataSet.getProperty("cacheTag");
        }
        Datum datum = dataSet.getXTagDatum(0);
        Datum datum2 = dataSet.getXTagDatum(dataSet.getXLength() - 1);
        Datum datum3 = dataSet.getXTagDatum(1).subtract(datum);
        return new CacheTag(datum, datum2, datum3);
    }

    public static DatumRange xRange(DataSet dataSet) {
        int n = dataSet.getXLength();
        return new DatumRange(dataSet.getXTagDatum(0), dataSet.getXTagDatum(n - 1));
    }

    private static DatumRange yRangeTDS(TableDataSet tableDataSet) {
        DatumRange datumRange = null;
        if (tableDataSet.tableCount() == 0) {
            return new DatumRange(0.0, 10.0, tableDataSet.getYUnits());
        }
        for (int i = 0; i < tableDataSet.tableCount(); ++i) {
            int n = tableDataSet.getYLength(i);
            DatumRange datumRange2 = new DatumRange(tableDataSet.getYTagDatum(i, 0), tableDataSet.getYTagDatum(i, n - 1));
            datumRange = datumRange == null ? datumRange2 : datumRange.include(datumRange2.min()).include(datumRange2.max());
        }
        return datumRange;
    }

    public static DatumRange yRange(DataSet dataSet) {
        if (dataSet.getProperty("yRange") != null) {
            return (DatumRange)dataSet.getProperty("yRange");
        }
        if (dataSet instanceof VectorDataSet) {
            VectorDataSet vectorDataSet = (VectorDataSet)dataSet;
            Datum datum = null;
            Datum datum2 = null;
            for (int i = 0; i < dataSet.getXLength(); ++i) {
                Datum datum3 = vectorDataSet.getDatum(i);
                if (datum3.isFill()) continue;
                if (datum == null) {
                    datum2 = datum = datum3;
                    continue;
                }
                if (datum3.lt(datum)) {
                    datum = datum3;
                }
                if (!datum3.gt(datum)) continue;
                datum2 = datum3;
            }
            DatumRange datumRange = datum == null ? new DatumRange(0.0, 10.0, dataSet.getYUnits()) : new DatumRange(datum, datum2);
            return datumRange;
        }
        if (dataSet instanceof TableDataSet) {
            return DataSetUtil.yRangeTDS((TableDataSet)dataSet);
        }
        throw new IllegalArgumentException("unsupported: " + dataSet);
    }

    public static DasPlot visualize(DataSet dataSet) {
        return GraphUtil.visualize(dataSet);
    }

    public static DasPlot visualize(DataSet dataSet, boolean bl) {
        return GraphUtil.visualize(dataSet, bl);
    }

    public static Datum guessXTagWidth(DataSet dataSet) {
        if (dataSet.getProperty("xTagWidth") != null) {
            return (Datum)dataSet.getProperty("xTagWidth");
        }
        if (dataSet.getXLength() > 2) {
            Datum datum = dataSet.getXTagDatum(1).subtract(dataSet.getXTagDatum(0));
            for (int i = 2; i < dataSet.getXLength(); ++i) {
                Datum datum2 = dataSet.getXTagDatum(i).subtract(dataSet.getXTagDatum(i - 1));
                if (!datum2.lt(datum)) continue;
                datum = datum2;
            }
            return datum;
        }
        return dataSet.getXUnits().getOffsetUnits().createDatum(0);
    }

    protected static int closest(double[] dArray, double d) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException("array has no elements");
        }
        long l = System.currentTimeMillis();
        int n = Arrays.binarySearch(dArray, d);
        if (n == -1) {
            n = 0;
        } else if (n < 0) {
            n = (n ^= 0xFFFFFFFF) >= dArray.length - 1 ? dArray.length - 1 : ((d - dArray[n - 1]) / (dArray[n] - dArray[n - 1]) < 0.5 ? n - 1 : n);
        }
        return n;
    }

    public static int xTagBinarySearch(DataSet dataSet, Datum datum, int n, int n2) {
        Units units = datum.getUnits();
        double d = datum.doubleValue(units);
        while (n <= n2) {
            int n3;
            int n4 = n + n2 >> 1;
            double d2 = dataSet.getXTagDouble(n4, units);
            if (d2 < d) {
                n3 = -1;
            } else if (d2 > d) {
                n3 = 1;
            } else {
                long l;
                long l2 = Double.doubleToLongBits(d2);
                int n5 = l2 == (l = Double.doubleToLongBits(d)) ? 0 : (n3 = l2 < l ? -1 : 1);
            }
            if (n3 < 0) {
                n = n4 + 1;
                continue;
            }
            if (n3 > 0) {
                n2 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n + 1);
    }

    public static int closestColumn(DataSet dataSet, Datum datum) {
        int n = DataSetUtil.xTagBinarySearch(dataSet, datum, 0, dataSet.getXLength() - 1);
        if (n == -1) {
            n = 0;
        } else if (n < 0) {
            double d;
            double d2;
            double d3;
            n = (n ^= 0xFFFFFFFF) >= dataSet.getXLength() - 1 ? dataSet.getXLength() - 1 : (((d3 = datum.doubleValue(datum.getUnits())) - (d2 = dataSet.getXTagDouble(n - 1, datum.getUnits()))) / ((d = dataSet.getXTagDouble(n, datum.getUnits())) - d2) < 0.5 ? n - 1 : n);
        }
        return n;
    }

    public static int closestColumn(DataSet dataSet, double d, Units units) {
        return DataSetUtil.closestColumn(dataSet, units.createDatum(d));
    }

    public static int closestColumn(DataSet dataSet, Datum datum, int n) {
        int n2 = n;
        int n3 = dataSet.getXLength();
        if (n2 >= n3) {
            n2 = n3 - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        Units units = datum.getUnits();
        double d = datum.doubleValue(units);
        while (n2 < n3 - 1 && dataSet.getXTagDouble(n2, units) < d) {
            ++n2;
        }
        while (n2 > 0 && dataSet.getXTagDouble(n2, units) > d) {
            --n2;
        }
        if (n2 < n3 - 2) {
            double d2 = (d - dataSet.getXTagDouble(n2, units)) / (dataSet.getXTagDouble(n2 + 1, units) - dataSet.getXTagDouble(n2, units));
            n2 = d2 < 0.5 ? n2 : n2 + 1;
        }
        return n2;
    }

    public static int getPreviousColumn(DataSet dataSet, Datum datum) {
        int n = DataSetUtil.closestColumn(dataSet, datum);
        if (n > 0 && dataSet.getXTagDatum(n).ge(datum)) {
            return n - 1;
        }
        return n;
    }

    public static int getNextColumn(DataSet dataSet, Datum datum) {
        int n = DataSetUtil.closestColumn(dataSet, datum);
        if (n < dataSet.getXLength() - 1 && dataSet.getXTagDatum(n).le(datum)) {
            return n + 1;
        }
        return n;
    }

    public static double[] getXTagArrayDouble(DataSet dataSet, Units units) {
        int n = dataSet.getXLength();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = dataSet.getXTagDouble(i, units);
        }
        return dArray;
    }

    public static DatumVector getXTags(DataSet dataSet) {
        double[] dArray = VectorUtil.getXTagArrayDouble(dataSet, dataSet.getXUnits());
        return DatumVector.newDatumVector(dArray, dataSet.getXUnits());
    }

    public static DatumRange zRange(DataSet dataSet) {
        if (!(dataSet instanceof TableDataSet)) {
            throw new UnsupportedOperationException("only TableDataSets supported");
        }
        if (dataSet.getProperty("zRange") != null) {
            return (DatumRange)dataSet.getProperty("zRange");
        }
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = tableDataSet.getZUnits().getFillDouble();
        Units units = tableDataSet.getZUnits();
        for (int i = 0; i < tableDataSet.tableCount(); ++i) {
            int n = tableDataSet.getYLength(i);
            for (int j = tableDataSet.tableStart(i); j < tableDataSet.tableEnd(i); ++j) {
                for (int k = 0; k < n; ++k) {
                    double d4 = tableDataSet.getDouble(j, k, units);
                    if (d4 == d3) continue;
                    d = Math.max(d4, d);
                    d2 = Math.min(d4, d2);
                }
            }
        }
        if (d == Double.NEGATIVE_INFINITY) {
            d = d3;
            d2 = d3;
        }
        return DatumRange.newDatumRange(d2, d, units);
    }

    public static long guessSizeBytes(DataSet dataSet) {
        Long l = (Long)dataSet.getProperty("sizeBytes");
        if (l != null) {
            return l;
        }
        long l2 = dataSet.getPlaneIds().length;
        int n = 8;
        long l3 = dataSet.getXLength() * n;
        if (dataSet instanceof TableDataSet) {
            TableDataSet tableDataSet = (TableDataSet)dataSet;
            long l4 = 0L;
            for (int i = 0; i < tableDataSet.tableCount(); ++i) {
                l4 += (long)((tableDataSet.tableEnd(i) - tableDataSet.tableStart(i)) * tableDataSet.getYLength(i)) * l2 * (long)n;
            }
            return l4 + l3;
        }
        return (long)dataSet.getXLength() * l2 * (long)n + l3;
    }

    public static DataSet append(DataSet dataSet, DataSet dataSet2, CacheTag cacheTag) {
        CacheTag cacheTag2 = null;
        if (cacheTag != null) {
            cacheTag2 = cacheTag;
        } else if (dataSet2 != null) {
            cacheTag2 = DataSetUtil.guessCacheTag(dataSet2);
        }
        if (dataSet != null) {
            cacheTag2 = cacheTag2 == null ? DataSetUtil.guessCacheTag(dataSet) : CacheTag.append(DataSetUtil.guessCacheTag(dataSet), cacheTag2);
        }
        if (dataSet2 == null) {
            return dataSet;
        }
        if (dataSet2 instanceof TableDataSet) {
            TableDataSetBuilder tableDataSetBuilder = new TableDataSetBuilder(dataSet2.getXUnits(), dataSet2.getYUnits(), ((TableDataSet)dataSet2).getZUnits());
            if (dataSet != null) {
                tableDataSetBuilder.append((TableDataSet)dataSet);
            }
            tableDataSetBuilder.append((TableDataSet)dataSet2);
            tableDataSetBuilder.setProperty("cacheTag", cacheTag2);
            return tableDataSetBuilder.toTableDataSet();
        }
        VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(dataSet2.getXUnits(), dataSet2.getYUnits());
        if (dataSet != null) {
            vectorDataSetBuilder.append((VectorDataSet)dataSet);
        }
        vectorDataSetBuilder.append((VectorDataSet)dataSet2);
        vectorDataSetBuilder.setProperty("cacheTag", cacheTag2);
        return vectorDataSetBuilder.toVectorDataSet();
    }

    public static DataSet append(DataSet dataSet, DataSet dataSet2) {
        return DataSetUtil.append(dataSet, dataSet2, null);
    }

    public static VectorDataSet log10(VectorDataSet vectorDataSet) {
        VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(vectorDataSet.getXUnits(), Units.dimensionless);
        Units units = vectorDataSet.getYUnits();
        Units units2 = vectorDataSet.getXUnits();
        for (int i = 0; i < vectorDataSet.getXLength(); ++i) {
            vectorDataSetBuilder.insertY(vectorDataSet.getXTagDouble(i, units2), DasMath.log10(vectorDataSet.getDouble(i, units)));
        }
        return vectorDataSetBuilder.toVectorDataSet();
    }

    public static String[] getAllPlaneIds(DataSet dataSet) {
        String[] stringArray = dataSet.getPlaneIds();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("")) continue;
            bl = true;
        }
        if (bl) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "";
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        return stringArray2;
    }
}

