/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.DasServer;
import edu.uiowa.physics.pw.das.client.DataSetDescriptorNotAvailableException;
import edu.uiowa.physics.pw.das.client.NoSuchDataSetException;
import edu.uiowa.physics.pw.das.client.StreamDataSetDescriptor;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetCache;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.system.RequestProcessor;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.URLBuddy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;

public abstract class DataSetDescriptor
implements Displayable {
    protected Map properties = new HashMap();
    private boolean defaultCaching = true;
    private DataSetCache dataSetCache = DasApplication.getDefaultApplication().getDataSetCache();
    private String dataSetID;
    private EventListenerList listenerList;
    private static final Pattern CLASS_ID = Pattern.compile("class:([a-zA-Z0-9_\\.]+)(?:\\?(.*))?");
    private static final Pattern NAME_VALUE = Pattern.compile("([_0-9a-zA-Z%+.-]+)=([_0-9a-zA-Z%+.-]+)");

    protected DataSetDescriptor(String string) {
        this.dataSetID = string;
    }

    protected DataSetDescriptor() {
        this("");
    }

    protected abstract DataSet getDataSetImpl(Datum var1, Datum var2, Datum var3, DasProgressMonitor var4) throws DasException;

    public abstract Units getXUnits();

    public void requestDataSet(final Datum datum, final Datum datum2, final Datum datum3, final DasProgressMonitor dasProgressMonitor, Object object) {
        Runnable runnable = new Runnable(){

            public void run() {
                DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("requestDataSet: " + datum + " " + datum2 + " " + datum3);
                try {
                    DataSet dataSet = DataSetDescriptor.this.getDataSet(datum, datum2, datum3, dasProgressMonitor);
                    if (dataSet == null) {
                        throw new NoDataInIntervalException(new DatumRange(datum, datum2).toString());
                    }
                    DataSetUpdateEvent dataSetUpdateEvent = new DataSetUpdateEvent(DataSetDescriptor.this, dataSet);
                    dataSetUpdateEvent.setMonitor(dasProgressMonitor);
                    DataSetDescriptor.this.fireDataSetUpdateEvent(dataSetUpdateEvent);
                }
                catch (DasException dasException) {
                    DataSetUpdateEvent dataSetUpdateEvent = new DataSetUpdateEvent(DataSetDescriptor.this, (Exception)dasException);
                    dataSetUpdateEvent.setMonitor(dasProgressMonitor);
                    DataSetDescriptor.this.fireDataSetUpdateEvent(dataSetUpdateEvent);
                }
            }

            public String toString() {
                return "loadDataSet " + new DatumRange(datum, datum2);
            }
        };
        DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("submit data request");
        CacheTag cacheTag = new CacheTag(datum, datum2, datum3);
        if (this.dataSetCache.haveStored(this, cacheTag)) {
            runnable.run();
        } else {
            RequestProcessor.invokeLater(runnable, object);
        }
    }

    public void requestDataSet(final Datum datum, final Datum datum2, final Datum datum3, final DasProgressMonitor dasProgressMonitor, Object object, final DataSetUpdateListener dataSetUpdateListener) {
        if (object == null) {
            object = dataSetUpdateListener;
        }
        if (this instanceof ConstantDataSetDescriptor) {
            try {
                DataSet dataSet = this.getDataSet(null, null, null, null);
                DataSetUpdateEvent dataSetUpdateEvent = new DataSetUpdateEvent(this, dataSet);
                dataSetUpdateEvent.setMonitor(dasProgressMonitor);
            }
            catch (DasException dasException) {
                DataSetUpdateEvent dataSetUpdateEvent = new DataSetUpdateEvent(this, (Exception)dasException);
                dataSetUpdateEvent.setMonitor(dasProgressMonitor);
                dataSetUpdateListener.dataSetUpdated(dataSetUpdateEvent);
            }
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).info("request data from dsd: " + datum + " " + datum2 + " " + datum3);
                    try {
                        DataSet dataSet = DataSetDescriptor.this.getDataSet(datum, datum2, datum3, dasProgressMonitor);
                        DataSetUpdateEvent dataSetUpdateEvent = new DataSetUpdateEvent(DataSetDescriptor.this, dataSet);
                        dataSetUpdateEvent.setMonitor(dasProgressMonitor);
                        dataSetUpdateListener.dataSetUpdated(dataSetUpdateEvent);
                    }
                    catch (DasException dasException) {
                        DataSetUpdateEvent dataSetUpdateEvent = new DataSetUpdateEvent(DataSetDescriptor.this, (Exception)dasException);
                        dataSetUpdateEvent.setMonitor(dasProgressMonitor);
                        dataSetUpdateListener.dataSetUpdated(dataSetUpdateEvent);
                    }
                }

                public String toString() {
                    return "loadDataSet " + new DatumRange(datum, datum2);
                }
            };
            RequestProcessor.invokeLater(runnable, object);
        }
    }

    public DataSet getDataSet(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
        if (dasProgressMonitor == null) {
            dasProgressMonitor = DasProgressMonitor.NULL;
        }
        dasProgressMonitor.started();
        CacheTag cacheTag = null;
        if (this.defaultCaching) {
            cacheTag = new CacheTag(datum, datum2, datum3);
            DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).info("getDataSet " + this + " " + cacheTag);
        }
        if (this.defaultCaching && this.dataSetCache.haveStored(this, cacheTag)) {
            dasProgressMonitor.finished();
            return this.dataSetCache.retrieve(this, cacheTag);
        }
        try {
            DataSet dataSet = this.getDataSetImpl(datum, datum2, datum3, dasProgressMonitor);
            if (dataSet != null) {
                if (dataSet.getProperty("cacheTag") != null) {
                    cacheTag = (CacheTag)dataSet.getProperty("cacheTag");
                }
                if (this.defaultCaching) {
                    this.dataSetCache.store(this, cacheTag, dataSet);
                }
            }
            dasProgressMonitor.finished();
            DataSet dataSet2 = dataSet;
            return dataSet2;
        }
        catch (DasException dasException) {
            throw dasException;
        }
        finally {
            dasProgressMonitor.finished();
        }
    }

    public void reset() {
        this.dataSetCache.reset();
    }

    public void setDefaultCaching(boolean bl) {
        if (!bl) {
            this.defaultCaching = bl;
        }
    }

    public void addDataSetUpdateListener(DataSetUpdateListener dataSetUpdateListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataSetUpdateListener.class, dataSetUpdateListener);
    }

    public void removeDataSetUpdateListener(DataSetUpdateListener dataSetUpdateListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.remove(DataSetUpdateListener.class, dataSetUpdateListener);
    }

    protected void fireDataSetUpdateEvent(DataSetUpdateEvent dataSetUpdateEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)objectArray[i + 1]).dataSetUpdated(dataSetUpdateEvent);
        }
    }

    public String getDataSetID() {
        return this.dataSetID;
    }

    public static DataSetDescriptor create(String string) throws DasException {
        DataSetDescriptor dataSetDescriptor;
        Matcher matcher = CLASS_ID.matcher(string);
        if (matcher.matches()) {
            dataSetDescriptor = DataSetDescriptor.createFromClassName(string, matcher);
        } else {
            try {
                dataSetDescriptor = DataSetDescriptor.createFromServerAddress(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                throw new DasIOException(malformedURLException.getMessage());
            }
        }
        dataSetDescriptor.dataSetID = string;
        return dataSetDescriptor;
    }

    private static DataSetDescriptor createFromServerAddress(URL uRL) throws DasException {
        DasServer dasServer = DasServer.create(uRL);
        StreamDescriptor streamDescriptor = dasServer.getStreamDescriptor(uRL);
        return new StreamDataSetDescriptor(streamDescriptor, dasServer.getStandardDataStreamSource(uRL));
    }

    private static DataSetDescriptor createFromClassName(String string, Matcher matcher) throws DasException {
        try {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            Map map = string3 == null ? Collections.EMPTY_MAP : URLBuddy.parseQueryString(string3);
            Class<?> clazz = Class.forName(string2);
            Method method = clazz.getMethod("newDataSetDescriptor", Map.class);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new NoSuchDataSetException("newDataSetDescriptor must be static");
            }
            return (DataSetDescriptor)method.invoke(null, map);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(classNotFoundException.getMessage());
            dataSetDescriptorNotAvailableException.initCause(classNotFoundException);
            throw dataSetDescriptorNotAvailableException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(noSuchMethodException.getMessage());
            dataSetDescriptorNotAvailableException.initCause(noSuchMethodException);
            throw dataSetDescriptorNotAvailableException;
        }
        catch (InvocationTargetException invocationTargetException) {
            DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(invocationTargetException.getTargetException().getMessage());
            dataSetDescriptorNotAvailableException.initCause(invocationTargetException.getTargetException());
            throw dataSetDescriptorNotAvailableException;
        }
        catch (IllegalAccessException illegalAccessException) {
            DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(illegalAccessException.getMessage());
            dataSetDescriptorNotAvailableException.initCause(illegalAccessException);
            throw dataSetDescriptorNotAvailableException;
        }
    }

    protected void setProperties(Map map) {
        this.properties.putAll(map);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Icon getListIcon() {
        return null;
    }

    public String getListLabel() {
        return this.dataSetID;
    }

    public DataSetCache getDataSetCache() {
        return this.dataSetCache;
    }
}

