/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataRequestor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DataRequestThread
extends Thread {
    private static int threadCount = 0;
    private Object lock = new String("DATA_REQUEST_LOCK");
    private DataRequest currentRequest;
    private List queue = Collections.synchronizedList(new LinkedList());

    public DataRequestThread() {
        this.setName("DataRequest_" + threadCount++);
        this.setDaemon(true);
        this.start();
    }

    public void request(DataSetDescriptor dataSetDescriptor, Datum datum, Datum datum2, Datum datum3, DataRequestor dataRequestor, DasProgressMonitor dasProgressMonitor) throws InterruptedException {
        this.requestInternal(new DataRequest(dataSetDescriptor, datum, datum2, datum3, dataRequestor, dasProgressMonitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAndWait(DataSetDescriptor dataSetDescriptor, Object object, Datum datum, Datum datum2, Datum datum3, DataRequestor dataRequestor, DasProgressMonitor dasProgressMonitor) throws InterruptedException {
        DataRequest dataRequest;
        DataRequest dataRequest2 = dataRequest = new DataRequest(dataSetDescriptor, datum, datum2, datum3, dataRequestor, dasProgressMonitor);
        synchronized (dataRequest2) {
            this.requestInternal(dataRequest);
            dataRequest.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestInternal(DataRequest dataRequest) {
        this.queue.add(dataRequest);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCurrentRequest() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isAlive()) {
                this.interrupt();
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Thread.currentThread() != this) {
            throw new IllegalStateException("This method should not be invoked directly");
        }
        while (true) {
            Object object;
            if (!this.queue.isEmpty()) {
                this.currentRequest = (DataRequest)this.queue.remove(0);
                try {
                    object = this.currentRequest.dsd.getDataSet(this.currentRequest.start, this.currentRequest.end, this.currentRequest.resolution, this.currentRequest.monitor);
                    this.currentRequest.requestor.finished((DataSet)object);
                }
                catch (DasException dasException) {
                    this.currentRequest.requestor.exception(dasException);
                }
                finally {
                    object = this.currentRequest;
                    synchronized (object) {
                        this.currentRequest.notifyAll();
                    }
                }
            }
            object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    private static class DataRequest {
        DataSetDescriptor dsd;
        Datum start;
        Datum end;
        Object params;
        Datum resolution;
        DataRequestor requestor;
        DasProgressMonitor monitor;

        DataRequest(DataSetDescriptor dataSetDescriptor, Datum datum, Datum datum2, Datum datum3, DataRequestor dataRequestor, DasProgressMonitor dasProgressMonitor) {
            this.dsd = dataSetDescriptor;
            this.start = datum;
            this.end = datum2;
            this.resolution = datum3;
            this.requestor = dataRequestor;
            this.monitor = dasProgressMonitor;
        }
    }
}

