/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Map;

public class ClippedVectorDataSet
implements VectorDataSet {
    int xoffset;
    int xlength;
    VectorDataSet source;

    public ClippedVectorDataSet(VectorDataSet vectorDataSet, DatumRange datumRange) {
        this.xoffset = DataSetUtil.getPreviousColumn(vectorDataSet, datumRange.min());
        this.xlength = DataSetUtil.getNextColumn(vectorDataSet, datumRange.max()) - this.xoffset;
        this.source = vectorDataSet;
    }

    public ClippedVectorDataSet(VectorDataSet vectorDataSet, int n, int n2) {
        this.xoffset = n;
        this.xlength = n2;
        this.source = vectorDataSet;
    }

    public Datum getDatum(int n) {
        return this.source.getDatum(n + this.xoffset);
    }

    public double getDouble(int n, Units units) {
        return this.source.getDouble(n + this.xoffset, units);
    }

    public int getInt(int n, Units units) {
        return this.source.getInt(n + this.xoffset, units);
    }

    public DataSet getPlanarView(String string) {
        return new ClippedVectorDataSet((VectorDataSet)this.source.getPlanarView(string), this.xoffset, this.xlength);
    }

    public String[] getPlaneIds() {
        return this.source.getPlaneIds();
    }

    public Map getProperties() {
        return this.source.getProperties();
    }

    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    public int getXLength() {
        return this.xlength;
    }

    public Datum getXTagDatum(int n) {
        return this.source.getXTagDatum(n + this.xoffset);
    }

    public double getXTagDouble(int n, Units units) {
        return this.source.getXTagDouble(n + this.xoffset, units);
    }

    public int getXTagInt(int n, Units units) {
        return this.source.getXTagInt(n + this.xoffset, units);
    }

    public Units getXUnits() {
        return this.source.getXUnits();
    }

    public Units getYUnits() {
        return this.source.getYUnits();
    }
}

