/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.ClippedVectorDataSet;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Map;

public class ClippedTableDataSet
implements TableDataSet {
    TableDataSet source;
    int xoffset;
    int xlength;
    int[] yoffsets;
    int[] ylengths;
    int tableOffset;
    int tableCount;

    void calculateXOffset(Datum datum, Datum datum2) {
        this.xoffset = DataSetUtil.getPreviousColumn(this.source, datum);
        int n = DataSetUtil.getNextColumn(this.source, datum2);
        this.xlength = n - this.xoffset;
    }

    void calculateTableOffset() {
        this.tableOffset = -99;
        for (int i = 0; i < this.source.tableCount(); ++i) {
            if (this.tableOffset == -99 && this.source.tableEnd(i) > this.xoffset) {
                this.tableOffset = i;
            }
            if (this.tableOffset == -99 || this.source.tableEnd(i) < this.xoffset + this.xlength) continue;
            this.tableCount = i - this.tableOffset + 1;
        }
    }

    void calculateYOffsets(Datum datum, Datum datum2) {
        this.yoffsets = new int[this.tableCount];
        this.ylengths = new int[this.tableCount];
        for (int i = this.tableOffset; i < this.tableOffset + this.tableCount; ++i) {
            this.yoffsets[i - this.tableOffset] = TableUtil.getPreviousRow(this.source, i, datum);
            int n = TableUtil.getNextRow(this.source, i, datum2);
            this.ylengths[i - this.tableOffset] = n - this.yoffsets[i];
        }
    }

    public ClippedTableDataSet(TableDataSet tableDataSet, Datum datum, Datum datum2, Datum datum3, Datum datum4) {
        this(tableDataSet, new DatumRange(datum, datum2), new DatumRange(datum3, datum4));
    }

    public ClippedTableDataSet(TableDataSet tableDataSet, DatumRange datumRange, DatumRange datumRange2) {
        this.source = tableDataSet;
        this.calculateXOffset(datumRange.min(), datumRange.max());
        this.calculateTableOffset();
        this.calculateYOffsets(datumRange2.min(), datumRange2.max());
    }

    public ClippedTableDataSet(TableDataSet tableDataSet, int n, int n2, int n3, int n4) {
        if (tableDataSet.tableCount() > 1) {
            throw new IllegalArgumentException("this ClippedTableDataSet constructor requires that there be only one table");
        }
        if (tableDataSet.getXLength() < n + n2) {
            throw new IllegalArgumentException("xoffset + xlength greater than the number of XTags in source");
        }
        if (tableDataSet.getYLength(0) < n3 + n4) {
            throw new IllegalArgumentException("yoffset + ylength greater than the number of YTags in source");
        }
        if (n3 < 0 || n < 0) {
            throw new IllegalArgumentException("yoffset(" + n3 + ") or xoffset(" + n + ") is negative");
        }
        this.source = tableDataSet;
        this.xoffset = n;
        this.xlength = n2;
        this.tableOffset = 0;
        this.tableCount = 1;
        this.yoffsets = new int[]{n3};
        this.ylengths = new int[]{n4};
    }

    private ClippedTableDataSet(TableDataSet tableDataSet, int n, int n2, int[] nArray, int[] nArray2, int n3, int n4) {
        if (tableDataSet == null) {
            throw new IllegalArgumentException("source is null");
        }
        this.source = tableDataSet;
        this.xoffset = n;
        this.xlength = n2;
        this.yoffsets = nArray;
        this.ylengths = nArray2;
        this.tableOffset = n3;
        this.tableCount = n4;
    }

    public Datum getDatum(int n, int n2) {
        return this.source.getDatum(n + this.xoffset, n2 + this.yoffsets[this.tableOfIndex(n)]);
    }

    public double getDouble(int n, int n2, Units units) {
        return this.source.getDouble(n + this.xoffset, n2 + this.yoffsets[this.tableOfIndex(n)], units);
    }

    public double[] getDoubleScan(int n, Units units) {
        int n2 = this.tableOfIndex(n);
        int n3 = this.getYLength(n2);
        double[] dArray = new double[n3];
        double[] dArray2 = this.source.getDoubleScan(n + this.xoffset, units);
        System.arraycopy(dArray2, this.yoffsets[n2], dArray, 0, n3);
        return dArray;
    }

    public DatumVector getScan(int n) {
        int n2 = this.tableOfIndex(n);
        int n3 = this.getYLength(n2);
        return this.source.getScan(n + this.xoffset).getSubVector(this.yoffsets[n2], this.yoffsets[n2] + n3);
    }

    public int getInt(int n, int n2, Units units) {
        return this.source.getInt(n + this.xoffset, n2 + this.yoffsets[this.tableOfIndex(n)], units);
    }

    public DataSet getPlanarView(String string) {
        TableDataSet tableDataSet = (TableDataSet)this.source.getPlanarView(string);
        if (tableDataSet == null) {
            return null;
        }
        return new ClippedTableDataSet(tableDataSet, this.xoffset, this.xlength, this.yoffsets, this.ylengths, this.tableOffset, this.tableCount);
    }

    public String[] getPlaneIds() {
        return this.source.getPlaneIds();
    }

    public Map getProperties() {
        return this.source.getProperties();
    }

    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    public int getXLength() {
        return this.xlength;
    }

    public VectorDataSet getXSlice(int n) {
        int n2 = this.source.tableOfIndex(n + this.xoffset);
        DatumRange datumRange = new DatumRange(this.source.getYTagDatum(n2, this.yoffsets[n2]), this.source.getYTagDatum(n2, this.yoffsets[n2] + this.ylengths[n2]));
        return new ClippedVectorDataSet(this.source.getXSlice(n + this.xoffset), datumRange);
    }

    public Datum getXTagDatum(int n) {
        return this.source.getXTagDatum(n + this.xoffset);
    }

    public double getXTagDouble(int n, Units units) {
        return this.source.getXTagDouble(n + this.xoffset, units);
    }

    public int getXTagInt(int n, Units units) {
        return this.source.getXTagInt(n + this.xoffset, units);
    }

    public Units getXUnits() {
        return this.source.getXUnits();
    }

    public int getYLength(int n) {
        return this.ylengths[n];
    }

    public VectorDataSet getYSlice(int n, int n2) {
        return this.source.getYSlice(n + this.yoffsets[n2], n2 + this.tableOffset);
    }

    public Datum getYTagDatum(int n, int n2) {
        return this.source.getYTagDatum(n + this.tableOffset, n2 + this.yoffsets[n]);
    }

    public double getYTagDouble(int n, int n2, Units units) {
        return this.source.getYTagDouble(n + this.tableOffset, n2 + this.yoffsets[n], units);
    }

    public int getYTagInt(int n, int n2, Units units) {
        return this.source.getYTagInt(n + this.tableOffset, n2 + this.yoffsets[n], units);
    }

    public Units getYUnits() {
        return this.source.getYUnits();
    }

    public Units getZUnits() {
        return this.source.getZUnits();
    }

    public int tableCount() {
        return this.tableCount;
    }

    public int tableEnd(int n) {
        int n2 = this.source.tableEnd(n + this.tableOffset) - this.xoffset;
        if (n2 > this.getXLength()) {
            return this.getXLength();
        }
        return n2;
    }

    public int tableOfIndex(int n) {
        return this.source.tableOfIndex(n + this.xoffset) - this.tableOffset;
    }

    public int tableStart(int n) {
        int n2 = this.source.tableStart(n + this.tableOffset) - this.xoffset;
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    public String toString() {
        return "ClippedTableDataSet " + TableUtil.toString(this);
    }

    public DatumVector getYTags(int n) {
        double[] dArray = new double[this.getYLength(n)];
        Units units = this.getYUnits();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getYTagDouble(n, i, units);
        }
        return DatumVector.newDatumVector(dArray, units);
    }
}

