/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.WeightsTableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsUtil;
import edu.uiowa.physics.pw.das.system.DasLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class AverageTableRebinner
implements DataSetRebinner {
    private static Logger logger = DasLogger.getLogger(DasLogger.DATA_OPERATIONS_LOG);
    private boolean interpolate = true;
    private boolean enlargePixels = true;

    public DataSet rebin(DataSet dataSet, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) throws IllegalArgumentException, DasException {
        String[] stringArray;
        Object object;
        Units units;
        Object object2;
        double[] dArray;
        logger.finest("enter AverageTableRebinner.rebin");
        if (dataSet == null) {
            throw new NullPointerException("null data set");
        }
        if (!(dataSet instanceof TableDataSet)) {
            throw new IllegalArgumentException("Data set must be an instanceof TableDataSet: " + dataSet.getClass().getName());
        }
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        TableDataSet tableDataSet2 = (TableDataSet)dataSet.getPlanarView("weights");
        if (rebinDescriptor != null && tableDataSet.getXLength() > 0) {
            double d = tableDataSet.getXTagDouble(0, rebinDescriptor.getUnits());
            double d2 = tableDataSet.getXTagDouble(tableDataSet.getXLength() - 1, rebinDescriptor.getUnits());
            if (d > rebinDescriptor.end) {
                throw new NoDataInIntervalException("data starts after range");
            }
            if (d2 < rebinDescriptor.start) {
                throw new NoDataInIntervalException("data ends before range");
            }
        }
        long l = System.currentTimeMillis();
        Units units2 = rebinDescriptor.getUnits();
        int n = rebinDescriptor == null ? tableDataSet.getXLength() : rebinDescriptor.numberOfBins();
        int n2 = rebinDescriptor2 == null ? tableDataSet.getYLength(0) : rebinDescriptor2.numberOfBins();
        logger.finest("Allocating rebinData and rebinWeights: " + n + " x " + n2);
        double[][] dArray2 = new double[n][n2];
        double[][] dArray3 = new double[n][n2];
        AverageTableRebinner.average(tableDataSet, tableDataSet2, dArray2, dArray3, rebinDescriptor, rebinDescriptor2);
        if (this.interpolate) {
            AverageTableRebinner.doBoundaries2RL(tableDataSet, tableDataSet2, dArray2, dArray3, rebinDescriptor, rebinDescriptor2);
            AverageTableRebinner.doBoundaries2TB(tableDataSet, tableDataSet2, dArray2, dArray3, rebinDescriptor, rebinDescriptor2);
            AverageTableRebinner.doCorners(tableDataSet, tableDataSet2, dArray2, dArray3, rebinDescriptor, rebinDescriptor2);
        }
        if (rebinDescriptor != null) {
            dArray = rebinDescriptor.binCenters();
        } else {
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = tableDataSet.getXTagDouble(i, tableDataSet.getXUnits());
            }
        }
        if (rebinDescriptor2 != null) {
            object2 = new double[][]{rebinDescriptor2.binCenters()};
        } else {
            object2 = new double[1][n2];
            for (int i = 0; i < n2; ++i) {
                object2[0][i] = tableDataSet.getYTagDouble(0, i, tableDataSet.getYUnits());
            }
        }
        Units units3 = rebinDescriptor == null ? tableDataSet.getXUnits() : rebinDescriptor.getUnits();
        Units units4 = units = rebinDescriptor2 == null ? tableDataSet.getYUnits() : rebinDescriptor2.getUnits();
        if (this.interpolate) {
            object = (Datum)dataSet.getProperty("xTagWidth");
            if (object == null) {
                object = DataSetUtil.guessXTagWidth(tableDataSet);
            }
            double d = ((Datum)object).doubleValue(rebinDescriptor.getUnits().getOffsetUnits());
            stringArray = (String[])dataSet.getProperty("yTagWidth");
            if (rebinDescriptor != null) {
                AverageTableRebinner.fillInterpolateX(dArray2, dArray3, dArray, d);
            }
            if (rebinDescriptor2 != null) {
                AverageTableRebinner.fillInterpolateY(dArray2, dArray3, rebinDescriptor2, (Datum)stringArray);
            }
        } else if (this.enlargePixels) {
            this.enlargePixels(dArray2, dArray3);
        }
        object = new double[][][]{dArray2, dArray3};
        int[] nArray = new int[]{0};
        Units[] unitsArray = new Units[]{tableDataSet.getZUnits(), Units.dimensionless};
        stringArray = new String[]{"", "weights"};
        HashMap<String, Datum> hashMap = new HashMap<String, Datum>(dataSet.getProperties());
        if (rebinDescriptor != null) {
            hashMap.put("xTagWidth", rebinDescriptor.binWidthDatum());
        }
        if (rebinDescriptor2 != null) {
            hashMap.put("yTagWidth", rebinDescriptor2.binWidthDatum());
        }
        DefaultTableDataSet defaultTableDataSet = new DefaultTableDataSet(dArray, units3, (double[][])object2, units, (double[][][])object, unitsArray, stringArray, nArray, (Map)hashMap);
        logger.finest("done, AverageTableRebinner.rebin");
        return defaultTableDataSet;
    }

    static void doBoundaries2RL(TableDataSet tableDataSet, TableDataSet tableDataSet2, double[][] dArray, double[][] dArray2, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) {
        Units units = tableDataSet.getYUnits();
        Units units2 = tableDataSet.getZUnits();
        Units units3 = Units.dimensionless;
        TableDataSet tableDataSet3 = WeightsTableDataSet.create(tableDataSet);
        for (int i = 0; i < 2; ++i) {
            DatumRange datumRange;
            int n = i == 0 ? 0 : rebinDescriptor.numberOfBins() - 1;
            Datum datum = i == 0 ? rebinDescriptor.binCenter(0) : rebinDescriptor.binCenter(n);
            int n2 = DataSetUtil.getPreviousColumn(tableDataSet, datum);
            int n3 = DataSetUtil.getNextColumn(tableDataSet, datum);
            int n4 = tableDataSet.tableOfIndex(n2);
            if (n4 != tableDataSet.tableOfIndex(n3) || n3 == n2 || !(datumRange = new DatumRange(tableDataSet.getXTagDatum(n2), tableDataSet.getXTagDatum(n3))).width().gt(DataSetUtil.guessXTagWidth(tableDataSet).multiply(0.9))) continue;
            double d = datumRange.normalize(datum);
            int n5 = rebinDescriptor2 == null ? tableDataSet.getYLength(n4) : rebinDescriptor2.numberOfBins();
            for (int j = 0; j < tableDataSet.getYLength(n4); ++j) {
                int n6;
                int n7 = n6 = rebinDescriptor2 == null ? j : rebinDescriptor2.whichBin(tableDataSet.getYTagDouble(n4, j, units), units);
                if (n6 < 0 || n6 >= n5 || dArray2[n][n6] > 0.0 || tableDataSet3.getDouble(n2, j, units3) * tableDataSet3.getDouble(n3, j, units3) == 0.0) continue;
                dArray[n][n6] = (1.0 - d) * tableDataSet.getDouble(n2, j, units2) + d * tableDataSet.getDouble(n3, j, units2);
                dArray2[n][n6] = 1.0;
            }
        }
    }

    static void doBoundaries2TB(TableDataSet tableDataSet, TableDataSet tableDataSet2, double[][] dArray, double[][] dArray2, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) {
        if (rebinDescriptor2 == null) {
            return;
        }
        Units units = tableDataSet.getYUnits();
        Units units2 = tableDataSet.getZUnits();
        Units units3 = tableDataSet.getXUnits();
        Units units4 = Units.dimensionless;
        TableDataSet tableDataSet3 = WeightsTableDataSet.create(tableDataSet);
        for (int i = 0; i < tableDataSet.tableCount(); ++i) {
            for (int j = 0; j < 2; ++j) {
                double d;
                Object object;
                int n = j == 0 ? 0 : rebinDescriptor2.numberOfBins() - 1;
                Datum datum = j == 0 ? rebinDescriptor2.binCenter(0) : rebinDescriptor2.binCenter(n);
                int n2 = TableUtil.getPreviousRow(tableDataSet, i, datum);
                int n3 = TableUtil.getNextRow(tableDataSet, i, datum);
                if (n3 == n2) continue;
                DatumRange datumRange = new DatumRange(tableDataSet.getYTagDatum(i, n2), tableDataSet.getYTagDatum(i, n3));
                Datum datum2 = TableUtil.guessYTagWidth(tableDataSet, i);
                if (rebinDescriptor2.isLog()) {
                    object = datumRange.getUnits();
                    d = datumRange.min().doubleValue((Units)object);
                    double d2 = Math.log(datumRange.min().doubleValue((Units)object) / d);
                    double d3 = Math.log(datumRange.max().doubleValue((Units)object) / d);
                    datumRange = new DatumRange(d2, d3, Units.logERatio);
                    datum = Units.logERatio.createDatum(Math.log(tableDataSet.getYTagDouble(i, n2, (Units)object) / d2));
                }
                object = new DatumRange(rebinDescriptor.binCenter(0), rebinDescriptor.binCenter(rebinDescriptor.numberOfBins() - 1));
                d = datumRange.normalize(datum);
                int n4 = rebinDescriptor.numberOfBins();
                for (int k = tableDataSet.tableStart(i); k < tableDataSet.tableEnd(i); ++k) {
                    int n5 = rebinDescriptor.whichBin(tableDataSet.getXTagDouble(k, units3), units3);
                    if (n5 < 0 || n5 >= n4 || dArray2[n5][n] > 0.0 || tableDataSet3.getDouble(k, n2, units4) * tableDataSet3.getDouble(k, n3, units4) == 0.0) continue;
                    dArray[n5][n] = (1.0 - d) * tableDataSet.getDouble(k, n2, units2) + d * tableDataSet.getDouble(k, n3, units2);
                    dArray2[n5][n] = 1.0;
                }
            }
        }
    }

    static void doCorners(TableDataSet tableDataSet, TableDataSet tableDataSet2, double[][] dArray, double[][] dArray2, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) {
        if (rebinDescriptor2 == null) {
            return;
        }
        Units units = tableDataSet.getYUnits();
        Units units2 = tableDataSet.getZUnits();
        Units units3 = tableDataSet.getXUnits();
        Units units4 = Units.dimensionless;
        TableDataSet tableDataSet3 = WeightsTableDataSet.create(tableDataSet);
        for (int i = 0; i < 2; ++i) {
            int n = i == 0 ? 0 : rebinDescriptor.numberOfBins() - 1;
            Datum datum = rebinDescriptor.binCenter(n);
            int n2 = DataSetUtil.getPreviousColumn(tableDataSet, datum);
            int n3 = DataSetUtil.getNextColumn(tableDataSet, datum);
            int n4 = tableDataSet.tableOfIndex(n2);
            if (n4 != tableDataSet.tableOfIndex(n3) || n2 == n3) continue;
            for (int j = 0; j < 2; ++j) {
                int n5;
                int n6 = j == 0 ? 0 : rebinDescriptor2.numberOfBins() - 1;
                Datum datum2 = rebinDescriptor2.binCenter(n6);
                int n7 = TableUtil.getPreviousRow(tableDataSet, n4, datum2);
                if (n7 == (n5 = TableUtil.getNextRow(tableDataSet, n4, datum2))) continue;
                DatumRange datumRange = new DatumRange(tableDataSet.getXTagDatum(n2), tableDataSet.getXTagDatum(n3));
                DatumRange datumRange2 = new DatumRange(tableDataSet.getYTagDatum(n4, n7), tableDataSet.getYTagDatum(n4, n5));
                if (!datumRange.width().lt(DataSetUtil.guessXTagWidth(tableDataSet).multiply(1.1))) continue;
                DatumRange datumRange3 = new DatumRange(rebinDescriptor.binCenter(0), rebinDescriptor.binCenter(rebinDescriptor.numberOfBins() - 1));
                double d = datumRange2.normalize(datum2);
                double d2 = datumRange.normalize(datum);
                if (dArray2[n][n6] > 0.0 || tableDataSet3.getDouble(n3, n5, units4) * tableDataSet3.getDouble(n2, n7, units4) * tableDataSet3.getDouble(n3, n7, units4) * tableDataSet3.getDouble(n2, n5, units4) == 0.0) continue;
                dArray[n][n6] = tableDataSet.getDouble(n3, n5, units2) * d2 * d + tableDataSet.getDouble(n2, n7, units2) * (1.0 - d2) * (1.0 - d) + tableDataSet.getDouble(n3, n7, units2) * d2 * (1.0 - d) + tableDataSet.getDouble(n2, n5, units2) * (1.0 - d2) * d;
                dArray2[n][n6] = 1.0;
            }
        }
    }

    static void average(TableDataSet tableDataSet, TableDataSet tableDataSet2, double[][] dArray, double[][] dArray2, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) {
        int n;
        double[] dArray3;
        int n2;
        Units units = tableDataSet.getXUnits();
        Units units2 = tableDataSet.getZUnits();
        int n3 = rebinDescriptor == null ? tableDataSet.getXLength() : rebinDescriptor.numberOfBins();
        int n4 = n2 = rebinDescriptor2 == null ? tableDataSet.getYLength(0) : rebinDescriptor2.numberOfBins();
        if (rebinDescriptor2 != null) {
            dArray3 = rebinDescriptor2.binCenters();
        } else {
            dArray3 = new double[tableDataSet.getYLength(0)];
            for (n = 0; n < dArray3.length; ++n) {
                dArray3[n] = tableDataSet.getDouble(0, n, units2);
            }
        }
        int n5 = tableDataSet.tableCount();
        for (n = 0; n < n5; ++n) {
            int n6;
            int[] nArray = new int[tableDataSet.getYLength(n)];
            for (n6 = 0; n6 < nArray.length; ++n6) {
                nArray[n6] = rebinDescriptor2 != null ? rebinDescriptor2.whichBin(tableDataSet.getYTagDouble(n, n6, tableDataSet.getYUnits()), tableDataSet.getYUnits()) : n6;
            }
            for (n6 = tableDataSet.tableStart(n); n6 < tableDataSet.tableEnd(n); ++n6) {
                int n7 = rebinDescriptor != null ? rebinDescriptor.whichBin(tableDataSet.getXTagDouble(n6, units), units) : n6;
                if (n7 < 0 || n7 >= n3) continue;
                for (int i = 0; i < tableDataSet.getYLength(n); ++i) {
                    double d;
                    double d2 = tableDataSet.getDouble(n6, i, units2);
                    double d3 = tableDataSet2 == null ? (units2.isFill(d2) ? 0.0 : 1.0) : (d = tableDataSet2.getDouble(n6, i, Units.dimensionless));
                    if (nArray[i] < 0 || nArray[i] >= n2) continue;
                    double[] dArray4 = dArray[n7];
                    int n8 = nArray[i];
                    dArray4[n8] = dArray4[n8] + d2 * d;
                    double[] dArray5 = dArray2[n7];
                    int n9 = nArray[i];
                    dArray5[n9] = dArray5[n9] + d;
                }
            }
        }
        AverageTableRebinner.multiplyWeights(dArray, dArray2, units2.getFillDouble());
    }

    private static final double linearlyInterpolate(int n, double d, int n2, double d2, int n3) {
        double d3 = (double)(n3 - n) / (double)(n2 - n);
        return d + d3 * (d2 - d);
    }

    private static final void multiplyWeights(double[][] dArray, double[][] dArray2, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray[i][j] = dArray2[i][j] > 0.0 ? dArray[i][j] / dArray2[i][j] : d;
            }
        }
    }

    static void fillInterpolateX(double[][] dArray, double[][] dArray2, double[] dArray3, double d) {
        int n = dArray3.length;
        int n2 = dArray[0].length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = -1;
            int n5 = -1;
            for (n3 = 0; n3 < n; ++n3) {
                if (dArray2[n3][i] > 0.0 && n4 == n3 - 1) {
                    nArray[n3] = -1;
                    nArray2[n3] = -1;
                    n4 = n3;
                    continue;
                }
                if (dArray2[n3][i] > 0.0 && n4 == -1) {
                    nArray[n3] = -1;
                    nArray2[n3] = -1;
                    n4 = n3;
                    continue;
                }
                if (dArray2[n3][i] > 0.0 && n4 < n3 - 1) {
                    if (n4 <= -1) continue;
                    nArray[n3] = -1;
                    nArray2[n3] = -1;
                    for (int j = n3 - 1; j >= n4; --j) {
                        n5 = n3;
                        nArray[j] = n4;
                        nArray2[j] = n5;
                    }
                    n4 = n3;
                    continue;
                }
                nArray[n3] = -1;
                nArray2[n3] = -1;
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (nArray[n3] == -1 || !(dArray3[nArray2[n3]] - dArray3[nArray[n3]] < d * 1.5)) continue;
                double d2 = (float)((dArray3[n3] - dArray3[nArray[n3]]) / (dArray3[nArray2[n3]] - dArray3[nArray[n3]]));
                double d3 = 1.0 - d2;
                dArray[n3][i] = dArray[nArray[n3]][i] * d3 + dArray[nArray2[n3]][i] * d2;
                dArray2[n3][i] = dArray2[nArray[n3]][i] * d3 + dArray2[nArray2[n3]][i] * d2;
            }
        }
    }

    static void fillInterpolateY(double[][] dArray, double[][] dArray2, RebinDescriptor rebinDescriptor, Datum datum) {
        double d;
        double d2;
        int n;
        int n2 = dArray.length;
        int n3 = rebinDescriptor.numberOfBins();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double[] dArray3 = new double[rebinDescriptor.numberOfBins()];
        double[] dArray4 = rebinDescriptor.binCenters();
        Units units = rebinDescriptor.getUnits();
        boolean bl = rebinDescriptor.isLog();
        if (bl) {
            for (n = 0; n < n3; ++n) {
                dArray3[n] = Math.log(dArray4[n]);
            }
        } else {
            for (n = 0; n < n3; ++n) {
                dArray3[n] = dArray4[n];
            }
        }
        double d3 = 2.0;
        if (datum == null) {
            d = d2 = 4.4942328371557893E307;
        } else if (UnitsUtil.isRatiometric(datum.getUnits())) {
            d2 = datum.doubleValue(Units.logERatio);
            d = d2 * d3;
        } else {
            d2 = datum.doubleValue(units.getOffsetUnits());
            d = d2 * d3;
        }
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5 = -1;
            int n6 = -1;
            for (n4 = 0; n4 < n3; ++n4) {
                if (dArray2[i][n4] > 0.0 && n5 == n4 - 1) {
                    nArray[n4] = -1;
                    nArray2[n4] = -1;
                    n5 = n4;
                    continue;
                }
                if (dArray2[i][n4] > 0.0 && n5 == -1) {
                    nArray[n4] = -1;
                    nArray2[n4] = -1;
                    n5 = n4;
                    continue;
                }
                if (dArray2[i][n4] > 0.0 && n5 < n4 - 1) {
                    if (n5 <= -1) continue;
                    nArray[n4] = -1;
                    nArray2[n4] = -1;
                    for (int j = n4 - 1; j >= n5; --j) {
                        n6 = n4;
                        nArray[j] = n5;
                        nArray2[j] = n6;
                    }
                    n5 = n4;
                    continue;
                }
                nArray[n4] = -1;
                nArray2[n4] = -1;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (nArray[n4] == -1 || !(dArray3[nArray2[n4]] - dArray3[nArray[n4]] < d)) continue;
                float f = (float)((dArray3[n4] - dArray3[nArray[n4]]) / (dArray3[nArray2[n4]] - dArray3[nArray[n4]]));
                float f2 = 1.0f - f;
                dArray[i][n4] = dArray[i][nArray[n4]] * (double)f2 + dArray[i][nArray2[n4]] * (double)f;
                dArray2[i][n4] = dArray2[i][nArray[n4]] * (double)f2 + dArray2[i][nArray2[n4]] * (double)f;
            }
        }
    }

    private void enlargePixels(double[][] dArray, double[][] dArray2) {
        int n = 5;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            for (n3 = 0; n3 < dArray.length - 1; ++n3) {
                for (n2 = 0; n2 < dArray[0].length; ++n2) {
                    if (dArray2[n3][n2] != 0.0) continue;
                    dArray[n3][n2] = dArray[n3 + 1][n2];
                    dArray2[n3][n2] = dArray2[n3 + 1][n2];
                }
            }
            for (n3 = dArray.length - 1; n3 > 0; --n3) {
                for (n2 = 0; n2 < dArray[0].length; ++n2) {
                    if (dArray2[n3][n2] != 0.0) continue;
                    dArray[n3][n2] = dArray[n3 - 1][n2];
                    dArray2[n3][n2] = dArray2[n3 - 1][n2];
                }
            }
            for (n3 = 0; n3 < dArray[0].length - 1; ++n3) {
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    if (dArray2[n2][n3] != 0.0) continue;
                    dArray[n2][n3] = dArray[n2][n3 + 1];
                    dArray2[n2][n3] = dArray2[n2][n3 + 1];
                }
            }
            for (n3 = dArray[0].length - 1; n3 > 0; --n3) {
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    if (dArray2[n2][n3] != 0.0) continue;
                    dArray[n2][n3] = dArray[n2][n3 - 1];
                    dArray2[n2][n3] = dArray2[n2][n3 - 1];
                }
            }
        }
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean bl) {
        this.interpolate = bl;
    }

    public void setEnlargePixels(boolean bl) {
        this.enlargePixels = bl;
    }

    public boolean isEnlargePixels() {
        return this.enlargePixels;
    }
}

