/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.AverageTableRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.PeakTableRebinner;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.HashMap;
import java.util.Map;

public class AveragePeakTableRebinner
implements DataSetRebinner {
    private boolean debug = false;

    public DataSet rebin(DataSet dataSet, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) throws IllegalArgumentException {
        Object object;
        Object object2;
        double[] dArray;
        if (!(dataSet instanceof TableDataSet)) {
            throw new IllegalArgumentException();
        }
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        if (rebinDescriptor2 == null && tableDataSet.tableCount() == 0) {
            throw new IllegalArgumentException("empty table and null RebinDescriptor for Y, so result YTags are undefined.");
        }
        TableDataSet tableDataSet2 = (TableDataSet)dataSet.getPlanarView("weights");
        TableDataSet tableDataSet3 = (TableDataSet)dataSet.getPlanarView("peaks");
        long l = System.currentTimeMillis();
        int n = rebinDescriptor == null ? tableDataSet.getXLength() : rebinDescriptor.numberOfBins();
        int n2 = rebinDescriptor2 == null ? tableDataSet.getYLength(0) : rebinDescriptor2.numberOfBins();
        double[][] dArray2 = new double[n][n2];
        double[][] dArray3 = new double[n][n2];
        double[][] dArray4 = new double[n][n2];
        AverageTableRebinner.average(tableDataSet, tableDataSet2, dArray2, dArray3, rebinDescriptor, rebinDescriptor2);
        if (rebinDescriptor != null) {
            dArray = rebinDescriptor.binCenters();
        } else {
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = tableDataSet.getXTagDouble(i, tableDataSet.getXUnits());
            }
        }
        if (rebinDescriptor2 != null) {
            object2 = new double[][]{rebinDescriptor2.binCenters()};
        } else {
            object2 = new double[1][n2];
            for (int i = 0; i < n2; ++i) {
                object2[0][i] = tableDataSet.getYTagDouble(0, i, tableDataSet.getYUnits());
            }
        }
        Datum datum = DataSetUtil.guessXTagWidth(dataSet);
        double d = datum.doubleValue(rebinDescriptor.getUnits().getOffsetUnits());
        AverageTableRebinner.fillInterpolateX(dArray2, dArray3, dArray, d);
        if (rebinDescriptor2 != null) {
            object = (Datum)dataSet.getProperty("yTagWidth");
            AverageTableRebinner.fillInterpolateY(dArray2, dArray3, rebinDescriptor2, (Datum)object);
        }
        if (tableDataSet3 == null) {
            PeakTableRebinner.peaks(tableDataSet, dArray4, rebinDescriptor, rebinDescriptor2);
        } else {
            PeakTableRebinner.peaks(tableDataSet3, dArray4, rebinDescriptor, rebinDescriptor2);
        }
        object = new HashMap(dataSet.getProperties());
        if (rebinDescriptor != null) {
            object.put("xTagWidth", rebinDescriptor.binWidthDatum());
        }
        if (rebinDescriptor2 != null) {
            object.put("yTagWidth", rebinDescriptor2.binWidthDatum());
        }
        int[] nArray = new int[]{0};
        String[] stringArray = new String[]{"", "peaks", "weights"};
        double[][][] dArrayArray = new double[][][]{dArray2, dArray4, dArray3};
        Units[] unitsArray = new Units[]{tableDataSet.getZUnits(), tableDataSet.getZUnits(), Units.dimensionless};
        return new DefaultTableDataSet(dArray, tableDataSet.getXUnits(), (double[][])object2, tableDataSet.getYUnits(), (double[][][])dArrayArray, unitsArray, stringArray, nArray, (Map)object);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

