/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetCache;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;

public abstract class AbstractDataSetCache
implements DataSetCache {
    public int hits = 0;
    public int misses = 0;

    public abstract void store(DataSetDescriptor var1, CacheTag var2, DataSet var3);

    abstract boolean haveStoredImpl(DataSetDescriptor var1, CacheTag var2);

    public boolean haveStored(DataSetDescriptor dataSetDescriptor, CacheTag cacheTag) {
        boolean bl = this.haveStoredImpl(dataSetDescriptor, cacheTag);
        if (bl) {
            DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).fine("cache hit " + dataSetDescriptor + " " + cacheTag);
            ++this.hits;
        } else {
            DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).fine("cache miss " + dataSetDescriptor + " " + cacheTag);
            ++this.misses;
        }
        return bl;
    }

    protected long cacheValue(Entry entry) {
        return entry.lastAccess;
    }

    abstract DataSet retrieveImpl(DataSetDescriptor var1, CacheTag var2);

    public DataSet retrieve(DataSetDescriptor dataSetDescriptor, CacheTag cacheTag) {
        return this.retrieveImpl(dataSetDescriptor, cacheTag);
    }

    public abstract void reset();

    public DataSet coalese(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Entry)object).cacheTag.range.compareTo(((Entry)object2).cacheTag.range);
            }
        });
        Entry entry = (Entry)list.get(0);
        CacheTag cacheTag = entry.cacheTag;
        Datum datum = cacheTag.range.max();
        Datum datum2 = cacheTag.resolution;
        DataSet dataSet = entry.data;
        for (int i = 1; i < list.size(); ++i) {
            Entry entry2 = (Entry)list.get(i);
            CacheTag cacheTag2 = entry2.cacheTag;
            if (!cacheTag2.range.min().equals(datum) || (cacheTag.resolution != null || cacheTag2.resolution != null) && !cacheTag.resolution.equals(cacheTag2.resolution)) continue;
            dataSet = DataSetUtil.append(dataSet, entry2.data);
            datum = cacheTag2.range.max();
        }
        return dataSet;
    }

    public boolean isResetCache() {
        return false;
    }

    public void setResetCache(boolean bl) {
        if (bl) {
            this.reset();
        }
    }

    protected class Entry
    implements Displayable {
        protected DataSetDescriptor dsd;
        protected CacheTag cacheTag;
        protected DataSet data;
        protected int nhits;
        protected long birthTime;
        protected long lastAccess;

        Entry() {
            this(null, null, null);
        }

        Entry(DataSetDescriptor dataSetDescriptor, CacheTag cacheTag, DataSet dataSet) {
            this.dsd = dataSetDescriptor;
            this.cacheTag = cacheTag;
            this.data = dataSet;
            this.nhits = 0;
            this.lastAccess = this.birthTime = System.currentTimeMillis();
        }

        protected DataSet getData() {
            this.lastAccess = System.currentTimeMillis();
            return this.data;
        }

        protected boolean satifies(Entry entry) {
            boolean bl = this.dsd != null && entry.dsd != null;
            bl = bl && this.dsd.equals(entry.dsd);
            bl = bl && this.cacheTag.contains(entry.cacheTag);
            return bl;
        }

        public String toString() {
            long l = DataSetUtil.guessSizeBytes(this.data);
            String string = " (" + NumberFormat.getIntegerInstance().format(l) + " bytes)";
            return this.dsd.toString() + " " + this.cacheTag + " [" + this.nhits + " hits]" + string;
        }

        public Icon getListIcon() {
            return null;
        }

        public String getListLabel() {
            return this.toString();
        }

        public CacheTag getCacheTag() {
            return this.cacheTag;
        }
    }
}

