/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractDataSet
implements DataSet {
    private Map properties;
    private double[] xTags;
    private Units xUnits;
    private Units yUnits;

    protected AbstractDataSet(double[] dArray, Units units, Units units2, Map map) throws IllegalArgumentException {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof String) continue;
            throw new IllegalArgumentException("Non-String key found in property map");
        }
        this.properties = new HashMap(map);
        this.xTags = (double[])dArray.clone();
        this.xUnits = units;
        this.yUnits = units2;
    }

    private AbstractDataSet() {
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Map getProperties() {
        return new HashMap(this.properties);
    }

    public int getXLength() {
        return this.xTags.length;
    }

    public Datum getXTagDatum(int n) {
        return Datum.create(this.xTags[n], this.getXUnits());
    }

    public double getXTagDouble(int n, Units units) {
        double d = this.xTags[n];
        d = this.getXUnits().getConverter(units).convert(d);
        return d;
    }

    public int getXTagInt(int n, Units units) {
        return (int)Math.round(this.getXTagDouble(n, units));
    }

    public Units getXUnits() {
        return this.xUnits;
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    protected abstract class ViewDataSet
    extends AbstractDataSet
    implements DataSet {
        protected ViewDataSet() {
        }

        public Object getProperty(String string) {
            return AbstractDataSet.this.properties.get(string);
        }

        public Map getProperties() {
            return new HashMap(AbstractDataSet.this.properties);
        }

        public int getXLength() {
            return AbstractDataSet.this.xTags.length;
        }

        public Datum getXTagDatum(int n) {
            return Datum.create(AbstractDataSet.this.xTags[n], this.getXUnits());
        }

        public double getXTagDouble(int n, Units units) {
            double d = AbstractDataSet.this.xTags[n];
            d = this.getXUnits().getConverter(units).convert(d);
            return d;
        }

        public int getXTagInt(int n, Units units) {
            return (int)Math.round(this.getXTagDouble(n, units));
        }

        public Units getXUnits() {
            return AbstractDataSet.this.xUnits;
        }

        public Units getYUnits() {
            return AbstractDataSet.this.yUnits;
        }
    }
}

