/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.beans.AccessLevelBeanInfo;
import edu.uiowa.physics.pw.das.beans.BeansUtil;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SerializeUtil {
    static Set toStringSet = new HashSet();

    public static Element getDOMElement(Document document, Object object) {
        return SerializeUtil.getDOMElement(document, object, DasProgressMonitor.NULL);
    }

    public static Element getDOMElement(Document document, Object object, DasProgressMonitor dasProgressMonitor) {
        Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
        try {
            String string = object.getClass().getName();
            string = string.replaceAll("\\$", "\\_dollar_");
            Element element = null;
            try {
                element = document.createElement(string);
            }
            catch (Exception exception) {
                System.err.println(exception);
                throw new RuntimeException(exception);
            }
            BeanInfo beanInfo = BeansUtil.getBeanInfo(object.getClass());
            AccessLevelBeanInfo accessLevelBeanInfo = BeansUtil.asAccessLevelBeanInfo(beanInfo, object.getClass());
            PropertyDescriptor[] propertyDescriptorArray = accessLevelBeanInfo.getPropertyDescriptors(AccessLevelBeanInfo.PersistenceLevel.PERSISTENT);
            String[] stringArray = BeansUtil.getPropertyNames(propertyDescriptorArray);
            HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                hashMap.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
            }
            HashMap hashMap2 = new HashMap();
            if (stringArray.length > 0) {
                dasProgressMonitor.setTaskSize(stringArray.length);
            }
            dasProgressMonitor.started();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2;
                Element element2;
                Object object3;
                dasProgressMonitor.setTaskProgress(i);
                String string2 = stringArray[i];
                logger.fine("serializing property " + string2 + " of " + string);
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)hashMap.get(string2);
                if (propertyDescriptor == null) {
                    logger.warning("unable to locate property: " + string2 + ", ignoring");
                    continue;
                }
                Method method = propertyDescriptor.getReadMethod();
                if (method == null) {
                    logger.info("skipping property " + string2 + " of " + string + ", failed to find read method.");
                    continue;
                }
                Method method2 = propertyDescriptor.getWriteMethod();
                Object object4 = method.invoke(object, new Object[0]);
                if (object4 == null) {
                    logger.info("skipping property " + string2 + " of " + string + ", value is null.");
                    continue;
                }
                PropertyEditor propertyEditor = BeansUtil.getEditor(propertyDescriptor);
                String string3 = null;
                if (propertyEditor != null) {
                    propertyEditor.setValue(object4);
                    string3 = propertyEditor.getAsText();
                }
                if (string3 != null) {
                    if (method2 == null) continue;
                    element.setAttribute(string2, string3);
                    continue;
                }
                if (object4 instanceof DasCanvasComponent) {
                    object3 = (DasCanvasComponent)object4;
                    if (hashMap2.containsKey(((DasCanvasComponent)object3).getDasName())) {
                        element.setAttribute(string2, ((DasCanvasComponent)object3).getDasName());
                        continue;
                    }
                    element2 = document.createElement(string2);
                    object2 = SerializeUtil.getDOMElement(document, object4, DasProgressMonitor.NULL);
                    element2.appendChild((Node)object2);
                    element.appendChild(element2);
                    hashMap2.put(((DasCanvasComponent)object3).getDasName(), null);
                    continue;
                }
                if (object4.getClass().isArray()) {
                    object3 = document.createElement(string2);
                    for (int j = 0; j < Array.getLength(object4); ++j) {
                        object2 = Array.get(object4, j);
                        Element element3 = SerializeUtil.getDOMElement(document, object2, DasProgressMonitor.NULL);
                        object3.appendChild(element3);
                    }
                    element.appendChild((Node)object3);
                    continue;
                }
                object3 = document.createElement(string2);
                element2 = SerializeUtil.getDOMElement(document, object4, DasProgressMonitor.NULL);
                object3.appendChild(element2);
                element.appendChild((Node)object3);
            }
            dasProgressMonitor.finished();
            return element;
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException(introspectionException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    private static void processNode(Node node, Object object, String string, Map map) throws IllegalAccessException, ParseException, InvocationTargetException {
        Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
        String string2 = node.getNodeName();
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)map.get(string2);
        if (propertyDescriptor == null) {
            logger.warning("unable to locate property: " + string2 + " of " + string + ", ignoring");
            return;
        }
        Method method = propertyDescriptor.getReadMethod();
        Object object2 = method.invoke(object, new Object[0]);
        PropertyEditor propertyEditor = BeansUtil.getEditor(propertyDescriptor);
        String string3 = null;
        if (propertyEditor != null) {
            propertyEditor.setValue(object2);
            string3 = propertyEditor.getAsText();
        }
        if (string3 != null) {
            Attr attr = (Attr)node;
            String string4 = attr.getValue();
            propertyEditor.setAsText(string4);
            Method method2 = propertyDescriptor.getWriteMethod();
            if (method2 == null) {
                logger.warning("read-only property \"" + string2 + "\" of " + string + " ignored");
                return;
            }
            Object object3 = propertyEditor.getValue();
            if (string2.equals("dataSetID")) {
                logger.info("kludge to avoid setting dataSetID to null, ignoring");
            }
            if (string2.equals("dataSetID") && (object2 == null || object2.equals(""))) {
                logger.info("kludge to avoid setting dataSetID to null, ignoring");
                return;
            }
            method2.invoke(object, object3);
        } else if (object2 instanceof DasCanvasComponent) {
            Node node2;
            DasCanvasComponent dasCanvasComponent = (DasCanvasComponent)object2;
            for (node2 = node.getFirstChild(); node2 != null && node2.getNodeType() != 1 && node2.getNodeType() != 3; node2 = node2.getNextSibling()) {
            }
            if (node2 == null) {
                throw new IllegalStateException("expected element node under " + string2);
            }
            if (node2.getNodeType() == 3) {
                return;
            }
            Element element = (Element)node2;
            SerializeUtil.processElement(element, object2);
        } else if (object2.getClass().isArray()) {
            int n = 0;
            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                while (node3 != null && node3.getNodeType() != 1) {
                    node3 = node3.getNextSibling();
                }
                if (node3 != null) {
                    Element element = (Element)node3;
                    Object object4 = Array.get(object2, n);
                    SerializeUtil.processElement(element, object4);
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            Node node4;
            for (node4 = node.getFirstChild(); node4 != null && node4.getNodeType() != 1 && node4.getNodeType() != 3; node4 = node4.getNextSibling()) {
            }
            if (node4 == null) {
                throw new IllegalStateException("expected element node under " + string2);
            }
            if (node4.getNodeType() == 3) {
                return;
            }
            Element element = (Element)node4;
            SerializeUtil.processElement(element, object2);
        }
    }

    public static void processElement(Element element, Object object) {
        Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
        try {
            String string = element.getTagName();
            string = string.replaceAll("\\_dollar_", "\\$");
            logger.fine("handling " + string);
            if (!object.getClass().getName().equals(string)) {
                throw new IllegalArgumentException("class name doesn't match: expected " + object.getClass().getName() + ", got " + string);
            }
            AccessLevelBeanInfo accessLevelBeanInfo = BeansUtil.asAccessLevelBeanInfo(BeansUtil.getBeanInfo(object.getClass()), object.getClass());
            PropertyDescriptor[] propertyDescriptorArray = accessLevelBeanInfo.getPropertyDescriptors(AccessLevelBeanInfo.PersistenceLevel.PERSISTENT);
            String[] stringArray = BeansUtil.getPropertyNames(object.getClass());
            HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                hashMap.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
            }
            HashMap hashMap2 = new HashMap();
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                logger.finer("attr: " + node.getNodeType() + "  " + node.getNodeName());
                SerializeUtil.processNode(node, object, string, hashMap);
            }
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                SerializeUtil.processNode(node, object, string, hashMap);
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException(introspectionException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    static {
        toStringSet.add(Boolean.class);
        toStringSet.add(Short.class);
        toStringSet.add(Integer.class);
        toStringSet.add(Long.class);
        toStringSet.add(Float.class);
        toStringSet.add(Double.class);
        toStringSet.add(String.class);
    }
}

