/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.FormContainer;
import edu.uiowa.physics.pw.das.dasml.FormPanel;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.dasml.TransferableFormComponent;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvas;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormWindow
extends FormContainer
implements Editable,
FormComponent {
    FormBase form;
    JDialog dialog;
    JInternalFrame internalFrame;
    String title = "";
    int windowWidth = -1;
    int windowHeight = -1;
    boolean shouldBeVisible = false;
    private String dasName;

    public FormWindow(String string, String string2) {
        this(string, string2, -1, -1);
    }

    public FormWindow(String string, String string2, int n, int n2) {
        this.flavorList = Arrays.asList(TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR);
        this.setLayout(new BorderLayout());
        this.title = string2;
        this.windowWidth = n;
        this.windowHeight = n2;
        if (string == null) {
            string = "window_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        this.dndSupport = new FormContainer.ContainerDnDSupport(null);
    }

    FormWindow(Element element, FormBase formBase) throws DasException, ParsedExpressionException, SAXException {
        this.flavorList = Arrays.asList(TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR);
        this.setLayout(new BorderLayout());
        this.form = formBase;
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("title");
        String string3 = element.getAttribute("alignment");
        int n = Integer.parseInt(element.getAttribute("width"));
        int n2 = Integer.parseInt(element.getAttribute("height"));
        Point point = FormWindow.parsePoint(element.getAttribute("location"));
        boolean bl = element.getAttribute("visible").equals("true");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            JComponent jComponent;
            Node node = nodeList.item(i);
            if (node instanceof Element && node.getNodeName().equals("panel")) {
                try {
                    jComponent = new FormPanel((Element)node, formBase);
                    this.add(jComponent);
                }
                catch (ParseException parseException) {
                    DasExceptionHandler.handle(parseException);
                }
                continue;
            }
            if (!(node instanceof Element) || !node.getNodeName().equals("canvas")) continue;
            try {
                jComponent = DasCanvas.processCanvasElement((Element)node, formBase);
                this.add(jComponent);
                continue;
            }
            catch (ParseException parseException) {
                DasExceptionHandler.handle(parseException);
            }
        }
        this.setTitle(string2);
        this.windowWidth = n;
        this.windowHeight = n2;
        this.setWindowVisible(bl);
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        this.dndSupport = new FormContainer.ContainerDnDSupport(null);
    }

    private static Point parsePoint(String string) {
        int n = string.indexOf(44);
        return new Point(Integer.parseInt(string.substring(1, n)), Integer.parseInt(string.substring(n + 1, string.length() - 1)));
    }

    public FormBase getForm() {
        return this.form;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("window");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("width", String.valueOf(this.getWidth()));
        element.setAttribute("height", String.valueOf(this.getHeight()));
        element.setAttribute("title", this.title);
        element.setAttribute("visible", String.valueOf(this.isVisible()));
        if (this.getComponentCount() > 0) {
            Component component = this.getComponent(0);
            if (component instanceof FormComponent) {
                FormComponent formComponent = (FormComponent)((Object)component);
                element.appendChild(formComponent.getDOMElement(document));
            } else if (component instanceof DasCanvas) {
                DasCanvas dasCanvas = (DasCanvas)component;
                element.appendChild(dasCanvas.getDOMElement(document));
            }
        }
        return element;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public boolean isWindowVisible() {
        if (this.getEditingMode()) {
            return this.shouldBeVisible;
        }
        return this.dialog == null ? false : this.dialog.isVisible();
    }

    public void setWindowVisible(boolean bl) {
        boolean bl2 = this.isWindowVisible();
        if (bl2 == bl) {
            return;
        }
        this.shouldBeVisible = bl;
        if (!this.getEditingMode() && bl) {
            if (this.dialog == null) {
                this.initDialog();
            }
            this.dialog.setVisible(bl);
        }
        this.firePropertyChange("visible", bl2, bl);
    }

    public void setEditingMode(boolean bl) {
        if (this.getEditingMode() == bl) {
            return;
        }
        if (bl) {
            if (this.dialog != null) {
                this.shouldBeVisible = this.dialog.isVisible();
                this.dialog.setVisible(false);
            } else {
                this.shouldBeVisible = false;
            }
            this.maybeInitializeInternalFrame();
            this.internalFrame.setContentPane(this);
        } else if (this.dialog != null) {
            this.dialog.setContentPane(this);
            this.dialog.pack();
            this.dialog.setVisible(this.shouldBeVisible);
        } else if (this.shouldBeVisible) {
            this.initDialog();
            this.dialog.pack();
            this.dialog.setVisible(this.shouldBeVisible);
        }
        super.setEditingMode(bl);
    }

    public Dimension getPreferredSize() {
        if (this.windowWidth == -1 || this.windowHeight == -1) {
            return super.getPreferredSize();
        }
        return new Dimension(this.windowWidth, this.windowHeight);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        if (this.title == string || this.title != null && this.title.equals(string)) {
            return;
        }
        String string2 = this.title;
        this.title = string;
        if (this.getEditingMode() && this.internalFrame != null) {
            this.internalFrame.setTitle(string);
        }
        this.firePropertyChange("title", string2, string);
    }

    public void pack() {
        if (this.getEditingMode()) {
            this.maybeInitializeInternalFrame();
            this.internalFrame.pack();
        } else {
            if (this.dialog == null) {
                this.initDialog();
            }
            this.dialog.pack();
        }
    }

    public Dimension getWindowSize() {
        return new Dimension(this.windowWidth, this.windowHeight);
    }

    public void setWindowSize(int n, int n2) {
        int n3 = this.windowWidth;
        int n4 = this.windowHeight;
        if (n != this.windowWidth) {
            this.windowWidth = n;
            this.firePropertyChange("width", n3, n);
        }
        if (n2 != this.windowHeight) {
            this.windowHeight = n2;
            this.firePropertyChange("height", n4, n2);
        }
        if (n2 != this.windowHeight || n != this.windowWidth) {
            this.pack();
        }
    }

    public void setWindowWidth(int n) {
        this.setWindowSize(n, this.windowHeight);
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowHeight(int n) {
        this.setWindowSize(this.windowWidth, n);
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    private void initDialog() {
        Window window = SwingUtilities.getWindowAncestor(this.form);
        this.dialog = window instanceof Frame ? new JDialog((Frame)window) : (window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog());
        this.dialog.setContentPane(this);
        this.dialog.setTitle(this.title);
    }

    private void maybeInitializeInternalFrame() {
        if (this.internalFrame == null) {
            this.internalFrame = new InternalFrame();
            this.internalFrame.setTitle(this.title);
            this.internalFrame.setVisible(true);
            this.internalFrame.setDefaultCloseOperation(0);
            if (this.getEditingMode()) {
                this.internalFrame.setContentPane(this);
            }
            this.internalFrame.pack();
        }
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new FormContainer.ContainerDnDSupport(null);
        }
        return this.dndSupport;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.getComponentCount() >= 1) {
            throw new IllegalArgumentException("Only one component allowed");
        }
        super.addImpl(component, object, n);
        if (component instanceof JComponent) {
            ((JComponent)component).setAlignmentY(0.0f);
        }
    }

    JInternalFrame getInternalFrame() {
        if (this.getEditingMode()) {
            this.maybeInitializeInternalFrame();
            return this.internalFrame;
        }
        return null;
    }

    public void deregisterComponent() {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            try {
                if (nameContext.get(this.getDasName()) == this) {
                    nameContext.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dasPropertyException) {
                IllegalStateException illegalStateException = new IllegalStateException(dasPropertyException.toString());
                illegalStateException.initCause(dasPropertyException);
                throw illegalStateException;
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                illegalStateException.initCause(invocationTargetException);
                throw illegalStateException;
            }
        }
        super.deregisterComponent();
    }

    public DasApplication getDasApplication() {
        if (this.form != null) {
            return this.form.getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            nameContext.put(this.getDasName(), this);
        }
        super.registerComponent();
    }

    public class InternalFrame
    extends JInternalFrame {
        InternalFrame() {
            super(null, true, false, false, false);
        }

        public FormWindow getWindow() {
            return FormWindow.this;
        }
    }
}

