/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.DefaultComponentDnDSupport;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FormTextField
extends JTextField
implements Editable,
FormComponent {
    private String dasName;
    protected DnDSupport dndSupport;
    private boolean editingMode;

    public FormTextField(String string) {
        super(10);
        if (string == null) {
            string = "textfield_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    public FormTextField(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParsedExpressionException {
        String string = element.getAttribute("name");
        int n = Integer.parseInt(element.getAttribute("length"));
        this.setColumns(n);
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            if (!(nodeList.item(i) instanceof Text)) continue;
            Text text = (Text)nodeList.item(i);
            this.setText(text.getData());
            break;
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("textfield");
        Text text = document.createTextNode(this.getText());
        element.appendChild(text);
        element.setAttribute("name", this.getDasName());
        element.setAttribute("enabled", this.isEnabled() ? "true" : "false");
        element.setAttribute("length", Integer.toString(this.getColumns()));
        return element;
    }

    public FormBase getForm() {
        FormComponent formComponent = (FormComponent)((Object)this.getParent());
        if (formComponent == null) {
            return null;
        }
        return formComponent.getForm();
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        return false;
    }

    public void setEditingMode(boolean bl) {
        this.editingMode = bl;
    }

    public boolean getEditingMode() {
        return this.editingMode;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public void deregisterComponent() {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            try {
                if (nameContext.get(this.getDasName()) == this) {
                    nameContext.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dasPropertyException) {
                IllegalStateException illegalStateException = new IllegalStateException(dasPropertyException.toString());
                illegalStateException.initCause(dasPropertyException);
                throw illegalStateException;
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                illegalStateException.initCause(invocationTargetException);
                throw illegalStateException;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            nameContext.put(this.getDasName(), this);
        }
    }
}

