/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.FormContainer;
import edu.uiowa.physics.pw.das.dasml.FormRadioButton;
import edu.uiowa.physics.pw.das.dasml.Orientation;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.dasml.TransferableFormComponent;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormRadioButtonGroup
extends FormContainer
implements Editable,
FormComponent {
    private ButtonGroup group;

    public FormRadioButtonGroup() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{TransferableFormComponent.RADIOBUTTON_FLAVOR};
        this.flavorList = Arrays.asList(dataFlavorArray);
        this.setDirection(Orientation.HORIZONTAL);
        this.setHasBorder(false);
        this.group = new ButtonGroup();
    }

    FormRadioButtonGroup(Element element, FormBase formBase) throws DasPropertyException, ParsedExpressionException, DasNameException, SAXException {
        Object object = new DataFlavor[]{TransferableFormComponent.RADIOBUTTON_FLAVOR};
        this.flavorList = Arrays.asList(object);
        this.group = new ButtonGroup();
        object = element.getAttribute("alignment");
        this.horizontalComponentAlignment = ((String)object).equals("left") ? 0.0f : (((String)object).equals("right") ? 1.0f : 0.5f);
        String string = element.getAttribute("direction");
        if (string.equals("horizontal")) {
            this.setDirection(Orientation.HORIZONTAL);
        } else {
            this.setDirection(Orientation.VERTICAL);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(string2 = node.getNodeName()).equals("radiobutton")) continue;
            FormRadioButton formRadioButton = new FormRadioButton((Element)node, formBase);
            formRadioButton.setAlignmentX(this.horizontalComponentAlignment);
            this.add(formRadioButton);
        }
        this.setHasBorder(element.getAttribute("border").equals("true"));
        this.setBorderTitle(element.getAttribute("border-title"));
    }

    protected void addImpl(Component component, Object object, int n) {
        if (!(component instanceof FormRadioButton)) {
            throw new IllegalArgumentException("Only FormRadioButton instances allowed");
        }
        FormRadioButton formRadioButton = (FormRadioButton)component;
        super.addImpl(formRadioButton, object, n);
        this.group.add(formRadioButton);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("group");
        for (int i = 0; i < this.getComponentCount(); ++i) {
            FormComponent formComponent = (FormComponent)((Object)this.getComponent(i));
            Element element2 = formComponent.getDOMElement(document);
            element.appendChild(element2);
        }
        return element;
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new FormContainer.ContainerDnDSupport(null);
        }
        return this.dndSupport;
    }
}

