/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.DefaultComponentDnDSupport;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JRadioButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FormRadioButton
extends JRadioButton
implements Editable,
FormComponent {
    private String dasName;
    private String value;
    protected DnDSupport dndSupport;
    private boolean editable;

    public FormRadioButton(String string, String string2) {
        super(string2);
        if (string == null) {
            string = "radiobutton_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
    }

    FormRadioButton(Element element, FormBase formBase) throws DasPropertyException, ParsedExpressionException, DasNameException {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("label");
        boolean bl = element.getAttribute("selected").equals("true");
        boolean bl2 = element.getAttribute("enabled").equals("true");
        this.setText(string2);
        this.setSelected(bl);
        this.setEnabled(bl2);
        if (!string.equals("")) {
            try {
                this.setDasName(string);
            }
            catch (DasNameException dasNameException) {
                DasExceptionHandler.handle(dasNameException);
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("radiobutton");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("selected", String.valueOf(this.isSelected()));
        element.setAttribute("enabled", String.valueOf(this.isEnabled()));
        element.setAttribute("label", this.getText());
        return element;
    }

    public FormBase getForm() {
        FormComponent formComponent = (FormComponent)((Object)this.getParent());
        if (formComponent == null) {
            return null;
        }
        return formComponent.getForm();
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean bl) {
        this.editable = bl;
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        return false;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public void deregisterComponent() {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            try {
                if (nameContext.get(this.getDasName()) == this) {
                    nameContext.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dasPropertyException) {
                IllegalStateException illegalStateException = new IllegalStateException(dasPropertyException.toString());
                illegalStateException.initCause(dasPropertyException);
                throw illegalStateException;
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                illegalStateException.initCause(invocationTargetException);
                throw illegalStateException;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            nameContext.put(this.getDasName(), this);
        }
    }
}

