/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormButton;
import edu.uiowa.physics.pw.das.dasml.FormCheckBox;
import edu.uiowa.physics.pw.das.dasml.FormChoice;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.FormList;
import edu.uiowa.physics.pw.das.dasml.FormPanel;
import edu.uiowa.physics.pw.das.dasml.FormRadioButton;
import edu.uiowa.physics.pw.das.dasml.FormRadioButtonGroup;
import edu.uiowa.physics.pw.das.dasml.FormTab;
import edu.uiowa.physics.pw.das.dasml.FormText;
import edu.uiowa.physics.pw.das.dasml.FormTextField;
import edu.uiowa.physics.pw.das.dasml.FormWindow;
import edu.uiowa.physics.pw.das.dasml.Orientation;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.dasml.TransferableFormComponent;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvas;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class FormContainer
extends JPanel
implements Editable,
FormComponent {
    float horizontalComponentAlignment = 0.0f;
    final float verticalComponentAlignment = 0.0f;
    boolean onHover = false;
    DnDSupport dndSupport;
    List flavorList;
    int dropPosition;
    boolean editable;
    private int axis = 0;
    private String borderTitle = "";
    private boolean hasBorder = false;

    protected FormContainer() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new NoBorder());
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public void setHasBorder(boolean bl) {
        if (this.hasBorder != bl) {
            this.hasBorder = bl;
            if (this.hasBorder) {
                EtchedBorder etchedBorder = new EtchedBorder();
                TitledBorder titledBorder = new TitledBorder(etchedBorder, this.borderTitle, 1, 2);
                this.setBorder(titledBorder);
            } else {
                this.setBorder(new NoBorder());
            }
        }
    }

    public String getBorderTitle() {
        return this.borderTitle;
    }

    public void setBorderTitle(String string) {
        if (!string.equals(this.borderTitle)) {
            this.borderTitle = string;
            if (this.hasBorder) {
                EtchedBorder etchedBorder = new EtchedBorder();
                TitledBorder titledBorder = new TitledBorder(etchedBorder, this.borderTitle, 1, 2);
                this.setBorder(titledBorder);
            }
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof JComponent) {
            ((JComponent)component).setAlignmentX(this.horizontalComponentAlignment);
            ((JComponent)component).setAlignmentY(0.0f);
        }
        super.addImpl(component, object, n);
        if (component instanceof FormComponent) {
            FormComponent formComponent = (FormComponent)((Object)component);
            DnDSupport dnDSupport = formComponent.getDnDSupport();
            if (dnDSupport != null) {
                dnDSupport.setParent(this.dndSupport);
            }
            formComponent.setEditingMode(this.getEditingMode());
        }
        this.packFormWindowAnscestor();
    }

    private void packFormWindowAnscestor() {
        if (this.isDisplayable()) {
            if (this instanceof FormWindow) {
                ((FormWindow)this).pack();
            } else {
                FormWindow formWindow = (FormWindow)SwingUtilities.getAncestorOfClass(FormWindow.class, this);
                if (formWindow != null) {
                    formWindow.pack();
                }
            }
        }
    }

    public void removeAll() {
        int n = this.getComponentCount();
        for (int i = n - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void remove(int n) {
        super.remove(n);
        this.packFormWindowAnscestor();
    }

    public void remove(Component component) {
        super.remove(component);
        this.packFormWindowAnscestor();
    }

    public void setDirection(Orientation orientation) {
        if (orientation == Orientation.HORIZONTAL) {
            if (this.axis != 0) {
                this.axis = 0;
                this.setLayout(new BoxLayout(this, this.axis));
                this.getForm().validate();
            }
        } else if (this.axis != 1) {
            this.axis = 1;
            this.setLayout(new BoxLayout(this, this.axis));
            this.revalidate();
        }
    }

    public Orientation getDirection() {
        if (this.axis == 0) {
            return Orientation.HORIZONTAL;
        }
        if (this.axis == 1) {
            return Orientation.VERTICAL;
        }
        throw new AssertionError((Object)"Invalid value for axis");
    }

    public FormBase getForm() {
        FormComponent formComponent = (FormComponent)((Object)this.getParent());
        if (formComponent == null) {
            return null;
        }
        return formComponent.getForm();
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.onHover) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            BasicStroke basicStroke = new BasicStroke(3.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setPaint(Color.GRAY);
            graphics2D.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            graphics2D.setPaint(Color.ORANGE);
            if (this.getDirection() == Orientation.HORIZONTAL) {
                graphics2D.drawLine(this.dropPosition, 4, this.dropPosition, this.getHeight() - 4);
            } else {
                graphics2D.drawLine(4, this.dropPosition, this.getHeight() - 4, this.dropPosition);
            }
            graphics2D.dispose();
        }
    }

    public void setEditingMode(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!(this.getComponent(i) instanceof FormComponent)) continue;
            ((FormComponent)((Object)this.getComponent(i))).setEditingMode(bl);
        }
    }

    private int[] getInsertionPositions() {
        int n = this.getComponentCount();
        int[] nArray = new int[n + 1];
        if (this.getDirection() == Orientation.HORIZONTAL) {
            nArray[0] = 2;
            for (int i = 1; i <= n; ++i) {
                Component component = this.getComponent(i - 1);
                nArray[i] = component.getX() + component.getWidth() + 1;
            }
        } else {
            nArray[0] = 2;
            for (int i = 1; i <= n; ++i) {
                Component component = this.getComponent(i - 1);
                nArray[i] = component.getY() + component.getHeight() + 1;
            }
        }
        return nArray;
    }

    private int getInsertionPosition(int n) {
        int[] nArray = this.getInsertionPositions();
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = Math.abs(n - nArray[i]);
            if (n4 >= n3) continue;
            n3 = n4;
            n2 = nArray[i];
        }
        return n2;
    }

    private int getInsertionIndex(int n) {
        int[] nArray = this.getInsertionPositions();
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = Math.abs(n - nArray[i]);
            if (n4 >= n3) continue;
            n3 = n4;
            n2 = i;
        }
        return n2;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).getBounds().contains(n, n2)) continue;
            this.dndSupport.startDrag(n, n2, n3, mouseEvent);
            return true;
        }
        return false;
    }

    public Dimension getPreferredSize() {
        if (this.getComponentCount() == 0) {
            return new Dimension(100, 100);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.getComponentCount() == 0) {
            return new Dimension(100, 100);
        }
        return super.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = super.getMaximumSize();
        dimension2.width = Math.max(dimension2.width, 100);
        dimension2.height = dimension.height;
        return dimension2;
    }

    public String getDasName() {
        return null;
    }

    public void setDasName(String string) throws DasNameException {
        throw new DasNameException();
    }

    public void deregisterComponent() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof FormComponent)) continue;
            ((FormComponent)((Object)component)).deregisterComponent();
        }
    }

    public DasApplication getDasApplication() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        try {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof FormComponent)) continue;
                ((FormComponent)((Object)component)).registerComponent();
            }
        }
        catch (DasNameException dasNameException) {
            this.deregisterComponent();
            throw dasNameException;
        }
    }

    protected class ContainerDnDSupport
    extends DnDSupport {
        ContainerDnDSupport(DnDSupport dnDSupport) {
            super(FormContainer.this, 3, dnDSupport);
        }

        protected int canAccept(DataFlavor[] dataFlavorArray, int n, int n2, int n3) {
            if (FormContainer.this.flavorList != null && FormContainer.this.getEditingMode()) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!FormContainer.this.flavorList.contains(dataFlavorArray[i])) continue;
                    FormContainer.this.onHover = true;
                    FormContainer.this.dropPosition = FormContainer.this.getDirection() == Orientation.HORIZONTAL ? FormContainer.this.getInsertionPosition(n) : FormContainer.this.getInsertionPosition(n2);
                    FormContainer.this.repaint();
                    return n3;
                }
            }
            return -1;
        }

        protected void done() {
            FormContainer.this.onHover = false;
            FormContainer.this.repaint();
        }

        protected boolean importData(Transferable transferable, int n, int n2, int n3) {
            boolean bl = false;
            try {
                int n4 = FormContainer.this.getDirection() == Orientation.HORIZONTAL ? FormContainer.this.getInsertionIndex(n) : FormContainer.this.getInsertionIndex(n2);
                Component component = null;
                if (transferable.isDataFlavorSupported(TransferableFormComponent.COMPONENT_FLAVOR)) {
                    component = (Component)transferable.getTransferData(TransferableFormComponent.COMPONENT_FLAVOR);
                } else if (transferable.isDataFlavorSupported(TransferableCanvas.CANVAS_FLAVOR)) {
                    component = (Component)transferable.getTransferData(TransferableCanvas.CANVAS_FLAVOR);
                } else if (transferable.isDataFlavorSupported(TransferableFormComponent.DASML_FRAGMENT_FLAVOR)) {
                    component = this.getComponentFromDasMLFragment((String)transferable.getTransferData(TransferableFormComponent.DASML_FRAGMENT_FLAVOR));
                }
                if (!(component == null || component instanceof FormTab || component instanceof FormWindow || component == FormContainer.this || SwingUtilities.isDescendingFrom(FormContainer.this, component))) {
                    if (component.getParent() == FormContainer.this) {
                        int n5 = -1;
                        int n6 = FormContainer.this.getComponentCount();
                        for (int i = 0; i < n6; ++i) {
                            if (FormContainer.this.getComponent(i) != component) continue;
                            n5 = i;
                            break;
                        }
                        if (n4 > n5) {
                            --n4;
                        }
                        FormContainer.this.remove(n5);
                        FormContainer.this.add(component, n4);
                        bl = true;
                    } else {
                        FormContainer.this.add(component, n4);
                        bl = true;
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                FormContainer.this.revalidate();
            }
            return bl;
        }

        private Component getComponentFromDasMLFragment(String string) {
            try {
                Document document = FormBase.parseDasML(new StringReader(string), null);
                Element element = document.getDocumentElement();
                String string2 = element.getTagName();
                if (string2.equals("panel")) {
                    return new FormPanel(element, FormContainer.this.getForm());
                }
                if (string2.equals("radiobutton")) {
                    return new FormRadioButton(element, FormContainer.this.getForm());
                }
                if (string2.equals("textfield")) {
                    return new FormTextField(element, FormContainer.this.getForm());
                }
                if (string2.equals("text")) {
                    return new FormText(element);
                }
                if (string2.equals("button")) {
                    return new FormButton(element, FormContainer.this.getForm());
                }
                if (string2.equals("checkbox")) {
                    return new FormCheckBox(element, FormContainer.this.getForm());
                }
                if (string2.equals("buttongroup")) {
                    return new FormRadioButtonGroup(element, FormContainer.this.getForm());
                }
                if (string2.equals("canvas")) {
                    return DasCanvas.processCanvasElement(element, FormContainer.this.getForm());
                }
                if (string2.equals("choice")) {
                    return new FormChoice(element, FormContainer.this.getForm());
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException);
            }
            catch (DasException dasException) {
                DasExceptionHandler.handle(dasException);
            }
            catch (ParsedExpressionException parsedExpressionException) {
                DasExceptionHandler.handle(parsedExpressionException);
            }
            catch (IOException iOException) {
                DasExceptionHandler.handle(iOException);
            }
            catch (ParseException parseException) {
                DasExceptionHandler.handle(parseException);
            }
            return null;
        }

        protected Transferable getTransferable(int n, int n2, int n3) {
            for (int i = 0; i < FormContainer.this.getComponentCount(); ++i) {
                Component component = FormContainer.this.getComponent(i);
                if (!component.getBounds().contains(n, n2)) continue;
                if (component instanceof DasCanvas) {
                    return new TransferableCanvas((DasCanvas)component);
                }
                if (component instanceof FormPanel) {
                    return new TransferableFormComponent((FormPanel)component);
                }
                if (component instanceof FormText) {
                    return new TransferableFormComponent((FormText)component);
                }
                if (component instanceof FormTextField) {
                    return new TransferableFormComponent((FormTextField)component);
                }
                if (component instanceof FormButton) {
                    return new TransferableFormComponent((FormButton)component);
                }
                if (component instanceof FormCheckBox) {
                    return new TransferableFormComponent((FormCheckBox)component);
                }
                if (component instanceof FormRadioButtonGroup) {
                    return new TransferableFormComponent((FormRadioButtonGroup)component);
                }
                if (component instanceof FormRadioButton) {
                    return new TransferableFormComponent((FormRadioButton)component);
                }
                if (component instanceof FormTab) {
                    return new TransferableFormComponent((FormTab)component);
                }
                if (component instanceof FormChoice) {
                    return new TransferableFormComponent((FormChoice)component);
                }
                if (!(component instanceof FormList)) continue;
                return new TransferableFormComponent((FormList)component);
            }
            return null;
        }

        protected void exportDone(Transferable transferable, int n) {
        }
    }

    class NoBorder
    extends EmptyBorder {
        Color color;

        NoBorder() {
            super(5, 5, 5, 5);
            this.color = Color.GRAY;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (FormContainer.this.editable) {
                graphics.setColor(this.color);
                graphics.drawRect(n + 2, n2 + 2, n3 - 4, n4 - 4);
            }
        }
    }
}

