/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.CommandAction;
import edu.uiowa.physics.pw.das.dasml.CommandBlock;
import edu.uiowa.physics.pw.das.dasml.DefaultComponentDnDSupport;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.ListOption;
import edu.uiowa.physics.pw.das.dasml.OptionList;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormChoice
extends JComboBox
implements Editable,
FormComponent,
OptionList {
    protected DnDSupport dndSupport;
    private boolean editable;
    private String dasName;

    public FormChoice(String string) {
        if (string == null) {
            string = "choice_" + Integer.toString(System.identityHashCode(this));
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
    }

    FormChoice(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParsedExpressionException {
        String string = element.getAttribute("name");
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element && node.getNodeName().equals("option")) {
                this.processOptionElement((Element)node);
                continue;
            }
            if (!(node instanceof Element) || !node.getNodeName().equals("action")) continue;
            CommandBlock commandBlock = new CommandBlock((Element)node, formBase);
            CommandAction commandAction = new CommandAction(commandBlock);
            this.addActionListener(commandAction);
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void processOptionElement(Element element) {
        boolean bl = element.getAttribute("selected").equals("true");
        ListOption listOption = new ListOption(element);
        this.addItem(listOption);
        if (bl) {
            this.setSelectedItem(listOption);
        }
    }

    public String getSelectedValue() {
        ListOption listOption = (ListOption)this.getSelectedItem();
        if (listOption == null) {
            return null;
        }
        return listOption.getValue();
    }

    public void addOption(ListOption listOption) {
        this.addItem(listOption);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("choice");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("enabled", String.valueOf(this.isEnabled()));
        for (int i = 0; i < this.getItemCount(); ++i) {
            ListOption listOption = (ListOption)this.getItemAt(i);
            element.appendChild(listOption.getDOMElement(document));
        }
        return element;
    }

    public ListOption[] getOptions() {
        ComboBoxModel comboBoxModel = this.getModel();
        ListOption[] listOptionArray = new ListOption[comboBoxModel.getSize()];
        for (int i = 0; i < listOptionArray.length; ++i) {
            listOptionArray[i] = (ListOption)comboBoxModel.getElementAt(i);
        }
        return listOptionArray;
    }

    public void setOptions(ListOption[] listOptionArray) {
        this.setModel(new DefaultComboBoxModel<ListOption>(listOptionArray));
        if (listOptionArray.length == 0) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(listOptionArray[0]);
            for (int i = 0; i < listOptionArray.length; ++i) {
                if (!listOptionArray[i].isSelected()) continue;
                this.setSelectedItem(listOptionArray[i]);
            }
        }
    }

    public Object getPrototypeDisplayValue() {
        if (this.getItemCount() == 0) {
            return "XXXXXXXXXXXX";
        }
        return null;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public FormBase getForm() {
        FormComponent formComponent = (FormComponent)((Object)this.getParent());
        if (formComponent == null) {
            return null;
        }
        return formComponent.getForm();
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        return false;
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean bl) {
        this.editable = bl;
    }

    public void deregisterComponent() {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            try {
                if (nameContext.get(this.getDasName()) == this) {
                    nameContext.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dasPropertyException) {
                IllegalStateException illegalStateException = new IllegalStateException(dasPropertyException.toString());
                illegalStateException.initCause(dasPropertyException);
                throw illegalStateException;
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                illegalStateException.initCause(invocationTargetException);
                throw illegalStateException;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            nameContext.put(this.getDasName(), this);
        }
    }
}

