/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.beans.BeansUtil;
import edu.uiowa.physics.pw.das.dasml.CommandBlock;
import edu.uiowa.physics.pw.das.dasml.DataFormatException;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.FormContainer;
import edu.uiowa.physics.pw.das.dasml.FormTab;
import edu.uiowa.physics.pw.das.dasml.FormWindow;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.dasml.TransferableFormComponent;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormBase
extends JTabbedPane
implements FormComponent {
    private static DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    private DasApplication application = DasApplication.getDefaultApplication();
    private CommandBlock initBlock;
    List windowList = new ArrayList();
    private JDesktopPane desktop;
    boolean editable;
    private boolean onHover = false;

    public FormBase(URL uRL, ErrorHandler errorHandler, boolean bl) throws IOException, SAXException {
        this(uRL.openStream(), errorHandler, bl);
    }

    public FormBase(InputStream inputStream, ErrorHandler errorHandler, boolean bl) throws IOException, SAXException {
        this(new InputStreamReader(inputStream), errorHandler, bl);
    }

    public FormBase(Reader reader, ErrorHandler errorHandler, boolean bl) throws IOException, SAXException {
        Object object = new DnDSupport();
        DropTarget dropTarget = new DropTarget(this, (DropTargetListener)object);
        this.setDropTarget(dropTarget);
        this.editable = bl;
        try {
            object = FormBase.parseDasML(reader, errorHandler);
            this.createFormFromTree((Document)object);
            this.registerComponent();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("DOM parser not configured properly: " + parserConfigurationException.getMessage());
        }
        catch (DasException dasException) {
            throw new SAXException(dasException);
        }
    }

    public FormBase(boolean bl) {
        DnDSupport dnDSupport = new DnDSupport();
        DropTarget dropTarget = new DropTarget(this, dnDSupport);
        this.setDropTarget(dropTarget);
        this.editable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Document parseDasML(Reader reader, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder;
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(reader);
        DocumentBuilderFactory documentBuilderFactory = domFactory;
        synchronized (documentBuilderFactory) {
            documentBuilder = domFactory.newDocumentBuilder();
        }
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder.parse(inputSource);
    }

    private void createFormFromTree(Document document) throws SAXException {
        try {
            Element element = document.getDocumentElement();
            if (!element.getTagName().equals("das2")) {
                // empty if block
            }
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                FormContainer formContainer;
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                if (node.getNodeName().equals("form")) {
                    formContainer = new FormTab((Element)node, this);
                    this.addForm((FormTab)formContainer);
                    continue;
                }
                if (node.getNodeName().equals("window")) {
                    formContainer = new FormWindow((Element)node, this);
                    this.addWindow((FormWindow)formContainer);
                    continue;
                }
                if (!node.getNodeName().equals("init")) continue;
                this.initBlock = this.processInitElement((Element)node);
            }
        }
        catch (DasException dasException) {
            throw new SAXException(dasException);
        }
        catch (ParsedExpressionException parsedExpressionException) {
            throw new SAXException(parsedExpressionException);
        }
    }

    private int getTabInsertionIndex() {
        int n;
        int n2 = this.getComponentCount();
        for (n = 0; n < n2 && this.getComponent(n) instanceof FormTab; ++n) {
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addForm(FormTab formTab) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getEditingMode()) {
                int n = this.getTabInsertionIndex();
                this.insertTab(formTab.getLabel(), null, formTab, null, n);
            } else {
                this.addTab(formTab.getLabel(), formTab);
            }
        }
        formTab.setEditingMode(this.getEditingMode());
    }

    public void addWindow(FormWindow formWindow) {
        if (formWindow.form != null) {
            formWindow.form.removeWindow(formWindow);
        }
        formWindow.form = this;
        this.windowList.add(formWindow);
        boolean bl = this.getEditingMode();
        formWindow.setEditingMode(bl);
        if (bl) {
            if (this.desktop == null) {
                this.desktop = new JDesktopPane();
                this.add((Component)this.desktop, "Windows");
            }
            formWindow.pack();
            this.desktop.add(formWindow.getInternalFrame());
        }
        this.firePropertyChange("window", null, formWindow);
    }

    public void removeWindow(FormWindow formWindow) {
        if (this.windowList.contains(formWindow)) {
            this.windowList.remove(formWindow);
            if (this.getEditingMode()) {
                this.desktop.remove(SwingUtilities.getAncestorOfClass(JInternalFrame.class, formWindow));
            }
            this.firePropertyChange("window", formWindow, null);
        }
    }

    private CommandBlock processActionElement(Element element) {
        return new CommandBlock(element, this);
    }

    Component processGlueElement(Element element) {
        String string = element.getAttribute("direction");
        if (string.equals("horizontal")) {
            return Box.createHorizontalGlue();
        }
        return Box.createVerticalGlue();
    }

    private CommandBlock processInitElement(Element element) throws SAXException {
        return new CommandBlock(element, this);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        try {
            DocumentBuilder documentBuilder = domFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.appendChild(this.getDOMElement(document));
            String string = "xml";
            OutputFormat outputFormat = new OutputFormat(string, "UTF-8", true);
            outputFormat.setLineWidth(0);
            XMLSerializer xMLSerializer = new XMLSerializer(outputStream, outputFormat);
            xMLSerializer.serialize(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
    }

    private boolean isValidType(Class clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Datum.class || Datum.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz);
    }

    public Object checkValue(String string, Class clazz, String string2) throws DasPropertyException, DasNameException {
        try {
            Object object = this.application.getNameContext().get(string);
            if (object == null) {
                throw new DasNameException(string + " must be defined before it is used");
            }
            if (!clazz.isInstance(object)) {
                throw new DasPropertyException(DasPropertyException.TYPE_MISMATCH, string, null);
            }
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    public Object invoke(String string, String[] stringArray) throws DasPropertyException, DataFormatException, ParsedExpressionException, InvocationTargetException {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new DataFormatException("No object associated with method name" + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        DasDie.println("object name: " + string2);
        DasDie.println("method name: " + string3);
        Object object = this.application.getNameContext().get(string2);
        Method method = null;
        try {
            BeanInfo beanInfo = BeansUtil.getBeanInfo(object.getClass());
            MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
            for (int i = 0; i <= methodDescriptorArray.length; ++i) {
                if (i == methodDescriptorArray.length) {
                    throw new DasPropertyException(DasPropertyException.NOT_DEFINED, string3, string2);
                }
                if (!methodDescriptorArray[i].getName().equals(string3)) continue;
                method = methodDescriptorArray[i].getMethod();
                break;
            }
            Class<?>[] classArray = method.getParameterTypes();
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                objectArray[i] = this.application.getNameContext().parseValue(stringArray[i], classArray[i]);
            }
            return method.invoke(object, objectArray);
        }
        catch (IntrospectionException introspectionException) {
            throw new DataFormatException(introspectionException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DataFormatException(invocationTargetException.getTargetException().getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DataFormatException(illegalAccessException.getMessage());
        }
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean bl) {
        if (this.editable != bl) {
            this.editable = bl;
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof FormTab)) continue;
                ((FormTab)component).setEditingMode(bl);
            }
            if (this.windowList.size() > 0) {
                if (bl) {
                    if (this.desktop == null) {
                        this.desktop = new JDesktopPane();
                    }
                    this.add((Component)this.desktop, "Windows");
                } else {
                    this.remove(this.desktop);
                }
                for (Component component : this.windowList) {
                    ((FormWindow)component).setEditingMode(bl);
                    if (!bl) continue;
                    ((FormWindow)component).pack();
                    JInternalFrame jInternalFrame = ((FormWindow)component).getInternalFrame();
                    if (jInternalFrame.getParent() == this.desktop) continue;
                    this.desktop.add(jInternalFrame);
                }
            }
            this.revalidate();
            this.repaint();
            if (bl) {
                this.firePropertyChange("editable", Boolean.FALSE, Boolean.TRUE);
            } else {
                this.firePropertyChange("editable", Boolean.TRUE, Boolean.FALSE);
            }
        }
    }

    public FormBase getForm() {
        return this;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("das2");
        for (int i = 0; i < this.getComponentCount(); ++i) {
            FormComponent formComponent = (FormComponent)((Object)this.getComponent(i));
            element.appendChild(formComponent.getDOMElement(document));
        }
        if (!this.editable) {
            for (FormComponent formComponent : this.windowList) {
                element.appendChild(formComponent.getDOMElement(document));
            }
        }
        return element;
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.onHover) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            BasicStroke basicStroke = new BasicStroke(3.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            graphics2D.dispose();
        }
    }

    public edu.uiowa.physics.pw.das.util.DnDSupport getDnDSupport() {
        return null;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        return false;
    }

    public String getDasName() {
        return null;
    }

    public List getWindowList() {
        return Collections.unmodifiableList(this.windowList);
    }

    public void setDasName(String string) throws DasNameException {
        throw new DasNameException();
    }

    public void deregisterComponent() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof FormComponent)) continue;
            ((FormComponent)((Object)component)).deregisterComponent();
        }
        for (Component component : this.windowList) {
            ((FormWindow)component).deregisterComponent();
        }
    }

    public DasApplication getDasApplication() {
        return this.application;
    }

    public void registerComponent() throws DasException {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof FormComponent)) continue;
            ((FormComponent)((Object)component)).registerComponent();
        }
        for (Component component : this.windowList) {
            ((FormWindow)component).registerComponent();
        }
    }

    static {
        URL uRL = FormBase.class.getResource("schema/dasML.xsd");
        if (uRL != null) {
            domFactory.setAttribute("http://apache.org/xml/features/validation/schema-full-checking", Boolean.TRUE);
            domFactory.setAttribute("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", uRL.toExternalForm());
            domFactory.setValidating(true);
            domFactory.setNamespaceAware(true);
        }
        domFactory.setCoalescing(true);
        domFactory.setIgnoringElementContentWhitespace(true);
    }

    private class DnDSupport
    implements DropTargetListener {
        private final Set acceptableFlavors = new HashSet<DataFlavor>(Arrays.asList(TransferableFormComponent.TAB_FLAVOR, TransferableFormComponent.WINDOW_FLAVOR));

        private DnDSupport() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (this.canAccept(dropTargetDragEvent.getCurrentDataFlavors())) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getSourceActions());
                FormBase.this.onHover = true;
                FormBase.this.repaint();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            FormBase.this.onHover = false;
            FormBase.this.repaint();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            boolean bl = false;
            if (this.canAccept(dropTargetDropEvent.getCurrentDataFlavors())) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(TransferableFormComponent.COMPONENT_FLAVOR)) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    bl = this.acceptComponent(transferable);
                } else if (transferable.isDataFlavorSupported(TransferableFormComponent.DASML_FRAGMENT_FLAVOR)) {
                    dropTargetDropEvent.acceptDrop(1);
                    bl = this.acceptFragment(transferable);
                }
                dropTargetDropEvent.dropComplete(bl);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
            FormBase.this.onHover = false;
            FormBase.this.repaint();
        }

        private boolean acceptFragment(Transferable transferable) {
            boolean bl = false;
            try {
                String string = (String)transferable.getTransferData(TransferableFormComponent.DASML_FRAGMENT_FLAVOR);
                Document document = FormBase.parseDasML(new StringReader(string), null);
                Element element = document.getDocumentElement();
                if (element.getTagName().equals("form")) {
                    FormTab formTab = new FormTab(element, FormBase.this);
                    FormBase.this.addForm(formTab);
                    bl = true;
                    FormBase.this.revalidate();
                } else if (element.getTagName().equals("window")) {
                    FormWindow formWindow = new FormWindow(element, FormBase.this);
                    FormBase.this.addWindow(formWindow);
                    bl = true;
                    FormBase.this.revalidate();
                }
            }
            catch (ParsedExpressionException parsedExpressionException) {
                parsedExpressionException.printStackTrace();
            }
            catch (DasException dasException) {
                dasException.printStackTrace();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                DasExceptionHandler.handle(iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                DasExceptionHandler.handle(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                DasExceptionHandler.handle(sAXException);
            }
            return bl;
        }

        private boolean acceptComponent(Transferable transferable) {
            boolean bl = false;
            try {
                Component component = (Component)transferable.getTransferData(TransferableFormComponent.COMPONENT_FLAVOR);
                if (component instanceof FormTab) {
                    FormBase.this.addForm((FormTab)component);
                    bl = true;
                    FormBase.this.revalidate();
                } else if (component instanceof FormWindow) {
                    FormBase.this.addWindow((FormWindow)component);
                    bl = true;
                    FormBase.this.revalidate();
                } else {
                    System.out.println(component);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl;
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (FormBase.this.onHover) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        private boolean canAccept(DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!this.acceptableFlavors.contains(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }
    }
}

