/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.beans.BeansUtil;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.components.propertyeditor.IndexedPropertyTreeNode;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyEditor;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNodeInterface;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class PropertyTreeNode
implements PropertyTreeNodeInterface {
    protected static final Object[] NULL_ARGS = new Object[0];
    protected List children;
    protected PropertyTreeNode parent;
    protected PropertyDescriptor propertyDescriptor;
    protected DefaultTreeModel treeModel;
    protected Object value;
    protected boolean dirty;
    protected boolean childDirty;

    PropertyTreeNode(Object object) {
        this.value = object;
    }

    public void setTreeModel(DefaultTreeModel defaultTreeModel) {
        if (this.treeModel != null) {
            throw new IllegalArgumentException("Improper use, see documentation");
        }
        this.treeModel = defaultTreeModel;
    }

    PropertyTreeNode(PropertyTreeNode propertyTreeNode, PropertyDescriptor propertyDescriptor) throws InvocationTargetException {
        this.parent = propertyTreeNode;
        this.propertyDescriptor = propertyDescriptor;
        this.treeModel = propertyTreeNode.treeModel;
        if (this.treeModel == null) {
            throw new IllegalArgumentException("null treeModel in parent");
        }
        try {
            if (propertyDescriptor.getReadMethod() == null) {
                throw new RuntimeException("read method not defined for " + propertyDescriptor.getName());
            }
            this.value = propertyDescriptor.getReadMethod().invoke(propertyTreeNode.value, NULL_ARGS);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public Enumeration children() {
        this.maybeLoadChildren();
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        Class<?> clazz;
        if (this.propertyDescriptor == null) {
            return true;
        }
        if (this.propertyDescriptor.getPropertyEditorClass() != null) {
            return false;
        }
        if (this.propertyDescriptor instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)this.propertyDescriptor;
            clazz = indexedPropertyDescriptor.getIndexedPropertyType();
        } else {
            clazz = this.propertyDescriptor.getPropertyType();
        }
        return !PropertyEditor.editableTypes.contains(clazz) && BeansUtil.findEditor(clazz) == null;
    }

    public TreeNode getChildAt(int n) {
        this.maybeLoadChildren();
        return (TreeNode)this.children.get(n);
    }

    public int getChildCount() {
        this.maybeLoadChildren();
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        this.maybeLoadChildren();
        return this.children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        if (this.value == null) {
            return true;
        }
        this.maybeLoadChildren();
        return this.children.isEmpty();
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    protected void maybeLoadChildren() {
        if (this.children == null) {
            ArrayList<PropertyTreeNode> arrayList = new ArrayList<PropertyTreeNode>();
            if (this.getAllowsChildren()) {
                try {
                    int n;
                    PropertyDescriptor[] propertyDescriptorArray = BeansUtil.getPropertyDescriptors(this.value.getClass());
                    String[] stringArray = BeansUtil.getPropertyNames(propertyDescriptorArray);
                    if (stringArray == null) {
                        stringArray = new String[propertyDescriptorArray.length];
                        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                            stringArray[i] = propertyDescriptorArray[i].getName();
                        }
                    }
                    HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
                    for (n = 0; n < propertyDescriptorArray.length; ++n) {
                        hashMap.put(propertyDescriptorArray[n].getName(), propertyDescriptorArray[n]);
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)hashMap.get(stringArray[n]);
                        if (propertyDescriptor == null) {
                            throw new IllegalArgumentException("property not found: " + stringArray[n] + " of object[" + this.value + "]");
                        }
                        if (propertyDescriptor.getReadMethod() == null) continue;
                        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                            arrayList.add(new IndexedPropertyTreeNode(this, (IndexedPropertyDescriptor)propertyDescriptor));
                            continue;
                        }
                        arrayList.add(new PropertyTreeNode(this, propertyDescriptor));
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    DasExceptionHandler.handle(invocationTargetException.getCause());
                }
            }
            this.children = arrayList;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Object getDisplayValue() {
        if (this.value instanceof Displayable) {
            return this.value;
        }
        boolean bl = this.getAllowsChildren();
        if (bl) {
            String string = String.valueOf(this.value);
            return this.value;
        }
        return this.value;
    }

    public String getDisplayName() {
        if (this.propertyDescriptor == null) {
            return "root";
        }
        return this.propertyDescriptor.getName();
    }

    public void setValue(Object object) {
        if (object == this.value) {
            return;
        }
        if (object != null && object.equals(this.value)) {
            return;
        }
        this.value = object;
        this.setDirty();
    }

    protected String absPropertyName() {
        if (this.propertyDescriptor == null) {
            return "";
        }
        String string = this.parent.absPropertyName();
        return (string == "" ? "" : string + ".") + this.propertyDescriptor.getName();
    }

    protected Object[] getTreePath() {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        arrayList.add(this);
        for (TreeNode treeNode = this.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
            arrayList.add(0, treeNode);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public void flush() {
        try {
            if (this.dirty) {
                DasLogger.getLogger(DasLogger.DASML_LOG).fine("flushing property " + this.absPropertyName() + "=" + this.value);
                Method method = this.propertyDescriptor.getWriteMethod();
                method.invoke(this.parent.value, this.value);
                this.dirty = false;
            }
            if (this.childDirty) {
                for (PropertyTreeNode propertyTreeNode : this.children) {
                    propertyTreeNode.flush();
                }
                this.childDirty = false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            DasExceptionHandler.handle(invocationTargetException);
        }
    }

    private void setDirty() {
        this.dirty = true;
        if (this.parent != null) {
            this.parent.setChildDirty();
        }
    }

    public boolean isDirty() {
        return this.dirty || this.childDirty;
    }

    private void setChildDirty() {
        this.childDirty = true;
        if (this.parent != null) {
            this.parent.setChildDirty();
        }
    }

    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.getDisplayName();
            }
            case 1: {
                return this.getDisplayValue();
            }
        }
        throw new IllegalArgumentException("No such column: " + n);
    }

    public void setValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                throw new IllegalArgumentException("Cell is not editable");
            }
            case 1: {
                this.setValue(object);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such column: " + n);
            }
        }
    }

    public boolean isCellEditable(int n) {
        boolean bl = this.propertyDescriptor.getWriteMethod() != null;
        return bl && n == 1 && !this.getAllowsChildren();
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Property Name";
            }
            case 1: {
                return "Value";
            }
        }
        throw new IllegalArgumentException("No such column: " + n);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void refresh() {
        if (this.getAllowsChildren()) {
            if (this.children != null) {
                for (PropertyTreeNode propertyTreeNode : this.children) {
                    propertyTreeNode.refresh();
                }
            }
        } else {
            Object object = this.read();
            if (object != this.value && object != null && !object.equals(this.value)) {
                this.value = object;
            }
        }
    }

    protected Object read() {
        if (this.propertyDescriptor == null) {
            return this.value;
        }
        Method method = this.propertyDescriptor.getReadMethod();
        if (method == null) {
            String string = this.propertyDescriptor.getName();
            String string2 = this.value.getClass().getName() + "#" + string;
            throw new IllegalStateException("Null read method for: " + string2);
        }
        try {
            return method.invoke(this.parent.value, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessError illegalAccessError = new IllegalAccessError(illegalAccessException.getMessage());
            illegalAccessError.initCause(illegalAccessException);
            throw illegalAccessError;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }
}

