/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.beans.BeansUtil;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNodeInterface;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class PropertyEditorAdapter
implements TableCellEditor {
    private EventListenerList listenerList = new EventListenerList();
    private PropertyEditor editor;
    private EditorState state;
    private EditorState simple = new SimpleEditor();
    private EditorState custom = new CustomEditor();
    private EditorState cellEditor = new CustomTableCellEditor();

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    public void cancelCellEditing() {
        if (this.state != null) {
            this.state.cancel();
        }
        this.state = null;
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        TreeTableModel treeTableModel = (TreeTableModel)jTable.getModel();
        PropertyTreeNodeInterface propertyTreeNodeInterface = (PropertyTreeNodeInterface)treeTableModel.getNodeForRow(n);
        PropertyDescriptor propertyDescriptor = propertyTreeNodeInterface.getPropertyDescriptor();
        this.editor = PropertyEditorAdapter.getEditor(propertyDescriptor);
        if (this.editor == null) {
            this.cancelCellEditing();
        } else {
            this.editor.setValue(object);
        }
        this.state = this.editor instanceof TableCellEditor ? this.cellEditor : (this.editor.supportsCustomEditor() ? this.custom : this.simple);
        return this.state.getEditorComponent(jTable, bl, n, n2);
    }

    private static PropertyEditor getEditor(PropertyDescriptor propertyDescriptor) {
        PropertyEditor propertyEditor;
        block6: {
            if (propertyDescriptor.getPropertyEditorClass() != null) {
                try {
                    Object obj = propertyDescriptor.getPropertyEditorClass().newInstance();
                    if (obj instanceof PropertyEditor) {
                        propertyEditor = (PropertyEditor)obj;
                        break block6;
                    }
                    propertyEditor = null;
                }
                catch (InstantiationException instantiationException) {
                    propertyEditor = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    propertyEditor = null;
                }
            } else {
                propertyEditor = BeansUtil.findEditor(propertyDescriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType() : propertyDescriptor.getPropertyType());
            }
        }
        return propertyEditor;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        boolean bl = this.state.stop();
        if (bl) {
            this.fireEditingStopped();
            this.state = null;
        }
        return bl;
    }

    private void fireEditingCanceled() {
        Class<CellEditorListener> clazz = CellEditorListener.class;
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != clazz) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            cellEditorListener.editingCanceled(changeEvent);
        }
    }

    private void fireEditingStopped() {
        Class<CellEditorListener> clazz = CellEditorListener.class;
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != clazz) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            cellEditorListener.editingStopped(changeEvent);
        }
    }

    private class CustomTableCellEditor
    implements EditorState,
    CellEditorListener {
        private CustomTableCellEditor() {
        }

        public Component getEditorComponent(JTable jTable, boolean bl, int n, int n2) {
            TableCellEditor tableCellEditor = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            Component component = tableCellEditor.getTableCellEditorComponent(jTable, PropertyEditorAdapter.this.editor.getValue(), bl, n, n2);
            tableCellEditor.addCellEditorListener(this);
            return component;
        }

        public boolean stop() {
            TableCellEditor tableCellEditor = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            return tableCellEditor.stopCellEditing();
        }

        public void cancel() {
            TableCellEditor tableCellEditor = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            tableCellEditor.cancelCellEditing();
        }

        public void editingStopped(ChangeEvent changeEvent) {
            TableCellEditor tableCellEditor = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            tableCellEditor.removeCellEditorListener(this);
            PropertyEditorAdapter.this.fireEditingStopped();
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            TableCellEditor tableCellEditor = (TableCellEditor)((Object)PropertyEditorAdapter.this.editor);
            tableCellEditor.removeCellEditorListener(this);
            PropertyEditorAdapter.this.fireEditingCanceled();
        }
    }

    private class CustomEditor
    implements EditorState,
    ActionListener {
        private JButton button;

        private CustomEditor() {
        }

        public boolean stop() {
            return true;
        }

        public void cancel() {
        }

        public Component getEditorComponent(JTable jTable, boolean bl, int n, int n2) {
            this.init();
            String string = PropertyEditorAdapter.this.editor.getAsText();
            if (string == null) {
                string = String.valueOf(PropertyEditorAdapter.this.editor.getValue());
            }
            this.button.setText(string);
            return this.button;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = PropertyEditorAdapter.this.editor.getCustomEditor();
            int n = JOptionPane.showConfirmDialog(this.button, component, "", 2);
            if (n == -1 || n == 2) {
                PropertyEditorAdapter.this.cancelCellEditing();
            } else {
                PropertyEditorAdapter.this.stopCellEditing();
            }
        }

        private void init() {
            if (this.button == null) {
                this.button = new JButton();
                this.button.setBorder(null);
                this.button.addActionListener(this);
            }
        }
    }

    private class SimpleEditor
    implements EditorState,
    ActionListener {
        private JTextField textField;

        private SimpleEditor() {
        }

        public void cancel() {
        }

        public boolean stop() {
            String string = this.textField.getText();
            try {
                PropertyEditorAdapter.this.editor.setAsText(string);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public Component getEditorComponent(JTable jTable, boolean bl, int n, int n2) {
            this.initTextField();
            this.textField.setText(PropertyEditorAdapter.this.editor.getAsText());
            return this.textField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditorAdapter.this.stopCellEditing();
        }

        private void initTextField() {
            if (this.textField == null) {
                this.textField = new JTextField();
                this.textField.setBorder(null);
                this.textField.addActionListener(this);
            }
        }
    }

    private static interface EditorState {
        public void cancel();

        public boolean stop();

        public Component getEditorComponent(JTable var1, boolean var2, int var3, int var4);
    }
}

