/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.PeerPropertyTreeNode;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyCellRenderer;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyEditorAdapter;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNode;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNodeInterface;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableCellRenderer;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableModel;
import edu.uiowa.physics.pw.das.dasml.SerializeUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.system.DasLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PropertyEditor
extends JComponent {
    static final Set editableTypes;
    private JTable table;
    private JButton closeButton;
    private JDialog dialog;
    private Object bean;
    private int focusRow = 0;
    private JPopupMenu popupMenu;
    private Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);

    private PropertyEditor(PropertyTreeNodeInterface propertyTreeNodeInterface, Object object) {
        this.bean = object;
        this.setLayout(new BorderLayout());
        this.bean = object;
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(propertyTreeNodeInterface, true);
        propertyTreeNodeInterface.setTreeModel(defaultTreeModel);
        TreeTableCellRenderer treeTableCellRenderer = new TreeTableCellRenderer(defaultTreeModel);
        treeTableCellRenderer.setRootVisible(false);
        treeTableCellRenderer.setShowsRootHandles(true);
        TreeTableModel treeTableModel = new TreeTableModel(propertyTreeNodeInterface, treeTableCellRenderer);
        this.table = new JTable(treeTableModel);
        this.table.setAutoCreateColumnsFromModel(false);
        this.add((Component)new JScrollPane(this.table, 20, 30), "Center");
        this.initButtonPanel(object instanceof DasCanvas);
        this.initPopupMenu();
        PropertyCellRenderer propertyCellRenderer = new PropertyCellRenderer();
        PropertyEditorAdapter propertyEditorAdapter = new PropertyEditorAdapter();
        int n = 21;
        this.table.setRowHeight(n);
        treeTableCellRenderer.setRowHeight(n);
        treeTableCellRenderer.setCellRenderer(propertyCellRenderer);
        this.table.getColumnModel().getColumn(0).setCellRenderer(treeTableCellRenderer);
        this.table.getColumnModel().getColumn(1).setCellRenderer(propertyCellRenderer);
        this.table.getColumnModel().getColumn(0).setMaxWidth(250);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.setDefaultEditor(Object.class, propertyEditorAdapter);
        this.table.addMouseListener(new PropertyTableMouseListener());
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.addKeyListener(this.getKeyListener());
        this.addActions(this.table);
        this.table.getSelectionModel().addListSelectionListener(this.getListSelectionListener());
    }

    public PropertyEditor(Object object) {
        this(new PropertyTreeNode(object), object);
        if (object instanceof PropertyTreeNodeInterface) {
            throw new IllegalArgumentException("whoops!");
        }
    }

    public static PropertyEditor createPeersEditor(Object object, Object[] objectArray) {
        PropertyTreeNode[] propertyTreeNodeArray = new PropertyTreeNode[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            propertyTreeNodeArray[i] = new PropertyTreeNode(objectArray[i]);
        }
        PeerPropertyTreeNode peerPropertyTreeNode = new PeerPropertyTreeNode(null, new PropertyTreeNode(object), propertyTreeNodeArray);
        return new PropertyEditor(peerPropertyTreeNode, null);
    }

    private void addActions(final JTable jTable) {
        jTable.getActionMap().put("MY_EDIT", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTable.editCellAt(PropertyEditor.this.focusRow, 1);
            }
        });
        jTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0, false), "MY_EDIT");
    }

    private ListSelectionListener getListSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PropertyEditor.this.focusRow = PropertyEditor.this.table.getSelectedRow();
                PropertyEditor.this.logger.fine("focusRow=" + PropertyEditor.this.focusRow);
            }
        };
    }

    private KeyListener getKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PropertyEditor.this.logger.fine(String.valueOf(keyEvent));
                if (keyEvent.getKeyCode() == 39) {
                    TreeTableModel treeTableModel = (TreeTableModel)PropertyEditor.this.table.getModel();
                    treeTableModel.expand(PropertyEditor.this.focusRow);
                } else if (keyEvent.getKeyCode() == 37) {
                    TreeTableModel treeTableModel = (TreeTableModel)PropertyEditor.this.table.getModel();
                    treeTableModel.collapse(PropertyEditor.this.focusRow);
                }
            }
        };
    }

    private Action createSaveAction(final Object object) {
        return new AbstractAction("Save"){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.toString().matches(".*\\.das2PropertySheet");
                        }

                        public String getDescription() {
                            return "*.das2PropertySheet";
                        }
                    });
                    jFileChooser.setSelectedFile(new File("default.das2PropertySheet"));
                    int n = jFileChooser.showSaveDialog(PropertyEditor.this);
                    if (n == 0) {
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                        Element element = SerializeUtil.getDOMElement(document, object);
                        document.appendChild(element);
                        FileOutputStream fileOutputStream = new FileOutputStream(jFileChooser.getSelectedFile());
                        StringWriter stringWriter = new StringWriter();
                        OutputFormat outputFormat = new OutputFormat("xml", "UTF-8", true);
                        XMLSerializer xMLSerializer = new XMLSerializer(new OutputStreamWriter(fileOutputStream), outputFormat);
                        xMLSerializer.serialize(document);
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }

    private static Document readDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        FileInputStream fileInputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new InputStreamReader(fileInputStream));
        ErrorHandler errorHandler = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    private Action createLoadAction(final Object object) {
        return new AbstractAction("Load"){

            public void actionPerformed(ActionEvent actionEvent) {
                block6: {
                    try {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                return file.toString().matches(".*\\.das2PropertySheet");
                            }

                            public String getDescription() {
                                return "*.das2PropertySheet";
                            }
                        });
                        int n = jFileChooser.showOpenDialog(PropertyEditor.this);
                        if (n != 0) break block6;
                        try {
                            Document document = PropertyEditor.readDocument(jFileChooser.getSelectedFile());
                            Element element = document.getDocumentElement();
                            SerializeUtil.processElement(element, object);
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            throw new RuntimeException(parserConfigurationException);
                        }
                        catch (SAXException sAXException) {
                            throw new RuntimeException(sAXException);
                        }
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
        };
    }

    private Action getEditSelectedAction() {
        return new AbstractAction("Edit Selected"){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor propertyEditor;
                TreeTableModel treeTableModel = (TreeTableModel)PropertyEditor.this.table.getModel();
                PropertyTreeNodeInterface propertyTreeNodeInterface = (PropertyTreeNodeInterface)treeTableModel.getNodeForRow(PropertyEditor.this.focusRow);
                int[] nArray = PropertyEditor.this.table.getSelectedRows();
                if (nArray.length == 1) {
                    propertyEditor = new PropertyEditor(propertyTreeNodeInterface.getValue());
                } else {
                    Object[] objectArray = new Object[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        objectArray[i] = ((PropertyTreeNode)treeTableModel.getNodeForRow(nArray[i])).getValue();
                    }
                    propertyEditor = PropertyEditor.createPeersEditor(propertyTreeNodeInterface.getValue(), objectArray);
                }
                propertyEditor.showDialog(PropertyEditor.this);
            }
        };
    }

    private void initPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.getEditSelectedAction());
    }

    private void initButtonPanel(boolean bl) {
        Object object;
        JButton jButton;
        JPanel jPanel = new JPanel(new FlowLayout(2));
        if (bl) {
            jButton = new JButton(this.createSaveAction(this.bean));
            jPanel.add(jButton);
            object = new JButton(this.createLoadAction(this.bean));
            jPanel.add((Component)object);
        }
        jButton = new JButton("Apply Changes");
        this.closeButton = new JButton("Dismiss");
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jButton) {
                    PropertyEditor.this.globalApplyChanges();
                    PropertyEditor.this.refresh();
                } else if (actionEvent.getSource() == PropertyEditor.this.closeButton) {
                    PropertyEditor.this.dismissDialog();
                }
            }
        };
        jButton.addActionListener((ActionListener)object);
        this.closeButton.addActionListener((ActionListener)object);
        JButton jButton2 = new JButton("Refresh");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.refresh();
            }
        });
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(this.closeButton);
        this.add((Component)jPanel, "South");
    }

    private void refresh() {
        TreeTableModel treeTableModel = (TreeTableModel)this.table.getModel();
        PropertyTreeNodeInterface propertyTreeNodeInterface = (PropertyTreeNodeInterface)treeTableModel.getRoot();
        propertyTreeNodeInterface.refresh();
        treeTableModel.fireTableDataChanged();
    }

    private void globalApplyChanges() {
        TreeTableModel treeTableModel = (TreeTableModel)this.table.getModel();
        PropertyTreeNodeInterface propertyTreeNodeInterface = (PropertyTreeNodeInterface)treeTableModel.getRoot();
        propertyTreeNodeInterface.flush();
    }

    private void dismissDialog() {
        PropertyTreeNodeInterface propertyTreeNodeInterface = (PropertyTreeNodeInterface)((TreeTableModel)this.table.getModel()).getRoot();
        if (propertyTreeNodeInterface.isDirty()) {
            String[] stringArray = new String[]{"You have unsaved changes", "Would you like to apply them?"};
            int n = JOptionPane.showConfirmDialog(this, stringArray, "", 1, 3);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.globalApplyChanges();
            }
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void showDialog(Component component) {
        if (this.dialog == null) {
            Container container;
            Container container2 = container = component == null ? null : SwingUtilities.getAncestorOfClass(Window.class, component);
            this.dialog = container instanceof JFrame ? new JDialog((JFrame)container) : (container instanceof JDialog ? new JDialog((JDialog)container) : new JDialog());
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PropertyEditor.this.dismissDialog();
                }
            });
            this.dialog.setContentPane(this);
            this.dialog.pack();
        }
        if (component != null) {
            this.dialog.setLocationRelativeTo(component);
        }
        this.dialog.setVisible(true);
    }

    public void doLayout() {
        if (SwingUtilities.isDescendingFrom(this, this.dialog)) {
            this.closeButton.setVisible(true);
        } else {
            this.closeButton.setVisible(false);
        }
        super.doLayout();
    }

    static {
        HashSet<Class<Object>> hashSet = new HashSet<Class<Object>>();
        hashSet.add(Byte.TYPE);
        hashSet.add(Short.TYPE);
        hashSet.add(Integer.TYPE);
        hashSet.add(Long.TYPE);
        hashSet.add(Float.TYPE);
        hashSet.add(Double.TYPE);
        hashSet.add(Boolean.TYPE);
        hashSet.add(String.class);
        hashSet.add(Datum.class);
        hashSet.add(DatumRange.class);
        hashSet.add(Color.class);
        editableTypes = Collections.unmodifiableSet(hashSet);
    }

    class PropertyTableMouseListener
    extends MouseAdapter {
        PropertyTableMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = PropertyEditor.this.table.rowAtPoint(point);
            int n2 = PropertyEditor.this.table.columnAtPoint(point);
            TreeTableModel treeTableModel = (TreeTableModel)PropertyEditor.this.table.getModel();
            PropertyTreeNodeInterface propertyTreeNodeInterface = (PropertyTreeNodeInterface)treeTableModel.getNodeForRow(n);
            PropertyEditor.this.focusRow = n;
            int n3 = mouseEvent.getModifiers() & 3;
            if (mouseEvent.getButton() == 1 && n3 == 0 && !propertyTreeNodeInterface.isLeaf()) {
                treeTableModel.toggleExpanded(n);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            PropertyEditor.this.focusRow = PropertyEditor.this.table.rowAtPoint(point);
            if (mouseEvent.getButton() == 3) {
                PropertyEditor.this.popupMenu.show(PropertyEditor.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

