/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.ColorCellRenderer;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNodeInterface;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyDescriptor;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class PropertyCellRenderer
extends JLabel
implements TableCellRenderer,
TreeCellRenderer,
ListCellRenderer {
    private static DecimalFormat expFormat = new DecimalFormat("0.#######E0");
    JCheckBox booleanRenderer;
    private TableCellRenderer colorRenderer = new ColorCellRenderer();

    public PropertyCellRenderer() {
        super("Label");
        this.setFont(this.getFont().deriveFont(0));
        this.booleanRenderer = new JCheckBox();
        this.booleanRenderer.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    private boolean isWritable(JTable jTable, int n) {
        TreeTableModel treeTableModel = (TreeTableModel)jTable.getModel();
        PropertyTreeNodeInterface propertyTreeNodeInterface = (PropertyTreeNodeInterface)treeTableModel.getNodeForRow(n);
        PropertyDescriptor propertyDescriptor = propertyTreeNodeInterface.getPropertyDescriptor();
        return propertyDescriptor.getWriteMethod() != null;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component;
        boolean bl3 = jTable == null || this.isWritable(jTable, n);
        this.setEnabled(bl3);
        if (object instanceof Color) {
            component = this.colorRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        } else if (object instanceof Boolean) {
            this.booleanRenderer.setSelected((Boolean)object);
            this.booleanRenderer.setText(object.toString());
            this.booleanRenderer.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            component = this.booleanRenderer;
        } else {
            if (object instanceof Double || object instanceof Float) {
                double d = ((Number)object).doubleValue();
                double d2 = Math.abs(d);
                if (d != 0.0 && d2 < 1.0E-4 || d2 >= 10000.0) {
                    object = expFormat.format(d);
                }
            }
            if (object instanceof Displayable) {
                this.setText(((Displayable)object).getListLabel());
            } else {
                this.setText(String.valueOf(object));
            }
            this.setOpaque(true);
            if (jTable != null) {
                this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            }
            if (object instanceof Displayable) {
                Displayable displayable = (Displayable)object;
                this.setIcon(displayable.getListIcon());
                this.setDisabledIcon(displayable.getListIcon());
            } else {
                this.setIcon(null);
                this.setDisabledIcon(null);
            }
            component = this;
        }
        component.setEnabled(bl3);
        return component;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.setText(String.valueOf(object));
        this.setIcon(null);
        this.setOpaque(false);
        this.setEnabled(true);
        return this;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof Displayable) {
            Displayable displayable = (Displayable)object;
            this.setIcon(displayable.getListIcon());
            this.setText(displayable.getListLabel());
        } else {
            this.setIcon(null);
            this.setText(String.valueOf(object));
        }
        this.setOpaque(true);
        this.setBackground(bl ? Color.gray : Color.lightGray);
        return this;
    }
}

