/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNode;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class IndexedPropertyItemTreeNode
extends PropertyTreeNode {
    private IndexedPropertyDescriptor indexedPropertyDescriptor;
    private int index;

    IndexedPropertyItemTreeNode(PropertyTreeNode propertyTreeNode, IndexedPropertyDescriptor indexedPropertyDescriptor, int n) {
        super(Array.get(propertyTreeNode.value, n));
        this.setTreeModel(propertyTreeNode.treeModel);
        this.index = n;
        this.parent = propertyTreeNode;
        this.propertyDescriptor = indexedPropertyDescriptor;
        this.indexedPropertyDescriptor = indexedPropertyDescriptor;
    }

    public boolean getAllowsChildren() {
        return this.indexedPropertyDescriptor.getPropertyEditorClass() == null;
    }

    public String getDisplayName() {
        return this.propertyDescriptor.getName() + "[" + this.index + "]";
    }

    public void flush() {
        try {
            if (this.dirty) {
                Method method = this.indexedPropertyDescriptor.getIndexedWriteMethod();
                method.invoke(this.parent.parent.value, new Integer(this.index), this.value);
                this.dirty = false;
            }
            if (this.childDirty) {
                for (PropertyTreeNode propertyTreeNode : this.children) {
                    propertyTreeNode.flush();
                }
                this.childDirty = false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            DasExceptionHandler.handle(invocationTargetException);
        }
    }

    protected Object read() {
        Object[] objectArray = (Object[])this.parent.read();
        return objectArray[this.index];
    }

    public void refresh() {
        boolean bl;
        Object object = this.read();
        boolean bl2 = false;
        if (object != this.value && (bl = this.getAllowsChildren())) {
            bl2 = true;
        }
        if (object != this.value && object != null && !object.equals(this.value)) {
            this.value = object;
        }
        if (bl2) {
            this.children = null;
            this.treeModel.nodeStructureChanged(this);
        } else if (this.getAllowsChildren() && this.children != null) {
            for (PropertyTreeNode propertyTreeNode : this.children) {
                propertyTreeNode.refresh();
            }
        }
    }
}

