/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class EnumerationEditor
implements PropertyEditor,
TableCellEditor {
    private JComboBox editor;
    private Model model;
    private Object selected;
    private Class type;
    private boolean guessType;
    private PropertyChangeSupport pcSupport;
    private EventListenerList listeners = new EventListenerList();
    private Map valueMap;
    private Map nameMap;
    private Map toStringMap;
    private static final int PUBLIC_STATIC_FINAL = 25;
    private ChangeEvent evt;

    public EnumerationEditor() {
        this.guessType = true;
        this.pcSupport = new PropertyChangeSupport(this);
    }

    protected EnumerationEditor(Class clazz) {
        this.setClass(clazz);
        this.guessType = false;
    }

    private void initEditor() {
        if (this.editor == null) {
            this.model = new Model();
            this.editor = new JComboBox(this.model){

                public void setBounds(int n, int n2, int n3, int n4) {
                    Dimension dimension = this.getPreferredSize();
                    super.setBounds(n, n2, n3, dimension.height);
                }
            };
            this.editor.setRenderer(new Renderer());
        }
    }

    private void setClass(Class clazz) {
        this.type = clazz;
        Field[] fieldArray = this.type.getDeclaredFields();
        HashSet<Field> hashSet = new HashSet<Field>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (int i = 0; i < fieldArray.length; ++i) {
            int n = fieldArray[i].getModifiers();
            if ((n & 0x19) != 25) continue;
            hashSet.add(fieldArray[i]);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object object;
            try {
                Field field = (Field)iterator.next();
                object = field.getName();
                Object object2 = field.get(null);
                identityHashMap.put(object, object2);
                hashMap2.put(object2.toString(), object2);
                hashMap.put(object2, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                object = new IllegalAccessError(illegalAccessException.getMessage());
                ((Throwable)object).initCause(illegalAccessException);
                throw object;
            }
        }
        this.nameMap = identityHashMap;
        this.valueMap = hashMap;
        this.toStringMap = hashMap2;
    }

    public String getAsText() {
        return this.selected.toString();
    }

    public Object getValue() {
        return this.selected;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Object v = this.nameMap.get(string);
        if (v == null) {
            v = this.toStringMap.get(string);
        }
        if (v == null) {
            throw new IllegalArgumentException(string);
        }
        if (this.selected != v) {
            Object object = this.selected;
            this.selected = v;
            this.pcSupport.firePropertyChange("value", object, this.selected);
        }
    }

    public void setValue(Object object) {
        Class clazz = this.getTypeClass(object);
        if (this.type != clazz) {
            int n = 0;
            if (this.model != null) {
                n = this.model.getSize();
            }
            this.setClass(clazz);
            if (this.model != null) {
                this.model.fireIntervalRemoved(this.model, 0, n - 1);
                this.model.fireIntervalAdded(this.model, 0, this.model.getSize() - 1);
            }
        }
        this.selected = object;
    }

    private Class getTypeClass(Object object) {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        if (string.matches(".+?\\$\\d+")) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.initEditor();
        return this.editor;
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Object getCellEditorValue() {
        return this.selected;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.initEditor();
        this.editor.setForeground(jTable.getForeground());
        this.editor.setBackground(jTable.getBackground());
        this.setValue(object);
        return this.editor;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(CellEditorListener.class, cellEditorListener);
    }

    private void fireEditingStopped() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cellEditorListener.editingStopped(this.evt);
        }
    }

    private void fireEditingCanceled() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cellEditorListener.editingCanceled(this.evt);
        }
    }

    private class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private List list;

        private Model() {
            this.list = new ArrayList(EnumerationEditor.this.nameMap.keySet());
            Collections.sort(this.list, String.CASE_INSENSITIVE_ORDER);
        }

        public Object getSelectedItem() {
            return EnumerationEditor.this.selected;
        }

        public void setSelectedItem(Object object) {
            EnumerationEditor.this.setValue(object);
            EnumerationEditor.this.stopCellEditing();
        }

        public Object getElementAt(int n) {
            return EnumerationEditor.this.nameMap.get(this.list.get(n));
        }

        public int getSize() {
            return this.list.size();
        }

        protected void fireIntervalRemoved(Object object, int n, int n2) {
            super.fireIntervalRemoved(object, n, n2);
        }

        protected void fireIntervalAdded(Object object, int n, int n2) {
            super.fireIntervalAdded(object, n, n2);
        }

        protected void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)EnumerationEditor.this.valueMap.get(object);
            super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            if (object instanceof Enumeration) {
                this.setText(object.toString());
                this.setIcon(((Enumeration)object).getListIcon());
            }
            return this;
        }
    }
}

