/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.ColorCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ColorEditor
extends AbstractCellEditor
implements PropertyEditor,
TableCellEditor {
    private static List colors = new ArrayList();
    private JColorChooser custom;
    private PropertyEditorSupport editorSupport = new PropertyEditorSupport(this){};
    private JComboBox choice;

    public ColorEditor() {
        this.custom = new JColorChooser();
        this.choice = new JComboBox(new ColorChoiceModel()){

            public void setBounds(int n, int n2, int n3, int n4) {
                Dimension dimension = this.getPreferredSize();
                super.setBounds(n, n2, n3, dimension.height);
            }
        };
        this.choice.setRenderer(new ColorCellRenderer());
        this.choice.setBorder(null);
        this.choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && ColorEditor.this.choice.isDisplayable()) {
                    ColorEditor.this.stopCellEditing();
                }
            }
        });
        this.custom.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ColorEditor.this.setValue(propertyChangeEvent.getNewValue());
            }
        });
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getAsText() {
        return "#" + Integer.toHexString(((Color)this.editorSupport.getValue()).getRGB()).substring(2);
    }

    public Component getCustomEditor() {
        Color color = (Color)this.getValue();
        this.custom.setColor(color);
        return this.custom;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.editorSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public Object getCellEditorValue() {
        return this.editorSupport.getValue();
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.editorSupport.getValue();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.editorSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Color color = Color.decode(string);
        this.editorSupport.setValue(color);
    }

    public void setValue(Object object) {
        this.editorSupport.setValue(object);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.setValue(object);
        this.choice.setSelectedItem(object);
        this.choice.setForeground(jTable.getForeground());
        this.choice.setBackground(jTable.getBackground());
        return this.choice;
    }

    static {
        colors.add(Color.BLACK);
        colors.add(Color.WHITE);
        colors.add(Color.BLUE);
        colors.add(Color.CYAN);
        colors.add(Color.DARK_GRAY);
        colors.add(Color.GRAY);
        colors.add(Color.GREEN);
        colors.add(Color.LIGHT_GRAY);
        colors.add(Color.MAGENTA);
        colors.add(Color.ORANGE);
        colors.add(Color.PINK);
        colors.add(Color.RED);
        colors.add(Color.YELLOW);
    }

    private class ColorChoiceModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final String CUSTOM_LABEL = "custom...";

        private ColorChoiceModel() {
        }

        public Object getElementAt(int n) {
            if (n < colors.size()) {
                return colors.get(n);
            }
            if (n == colors.size()) {
                return "custom...";
            }
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }

        public Object getSelectedItem() {
            return ColorEditor.this.getValue();
        }

        public int getSize() {
            return colors.size() + 1;
        }

        public void setSelectedItem(Object object) {
            if (object instanceof Color) {
                ColorEditor.this.setValue(object);
            } else if ("custom...".equals(object)) {
                ColorEditor.this.custom;
                Color color = JColorChooser.showDialog(ColorEditor.this.choice, "Color Editor", (Color)ColorEditor.this.getValue());
                if (color != null) {
                    ColorEditor.this.setValue(color);
                }
            } else {
                throw new IllegalArgumentException(String.valueOf(object));
            }
        }
    }
}

