/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

class ColorCellRenderer
implements ListCellRenderer,
TableCellRenderer,
Icon {
    private static Map names = new HashMap();
    private JLabel label;
    private Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private Color iconColor;

    ColorCellRenderer() {
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        return this.getLabel(jTable, color, color2, object, bl, bl2);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Color color = bl ? jList.getSelectionForeground() : jList.getForeground();
        Color color2 = bl ? jList.getSelectionBackground() : jList.getBackground();
        return this.getLabel(jList, color, color2, object, bl, bl2);
    }

    public Component getLabel(JComponent jComponent, Color color, Color color2, Object object, boolean bl, boolean bl2) {
        this.initLabel();
        this.label.setForeground(color);
        this.label.setBackground(color2);
        this.label.setEnabled(jComponent.isEnabled());
        this.label.setFont(jComponent.getFont());
        this.label.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
        if (object instanceof Color) {
            String string = (String)names.get(object);
            if (string == null) {
                string = ColorCellRenderer.toString((Color)object);
            }
            this.label.setIcon(this);
            this.label.setText(string);
            this.iconColor = (Color)object;
        } else {
            this.label.setIcon(null);
            this.label.setText(String.valueOf(object));
        }
        return this.label;
    }

    private static String toString(Color color) {
        return "[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]";
    }

    private void initLabel() {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.label.setBorder(this.noFocusBorder);
        }
    }

    public int getIconHeight() {
        return 16;
    }

    public int getIconWidth() {
        return 16;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(this.iconColor);
        graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
        graphics.setColor(color);
    }

    static {
        names.put(Color.BLACK, "black");
        names.put(Color.WHITE, "white");
        names.put(Color.BLUE, "blue");
        names.put(Color.CYAN, "cyan");
        names.put(Color.DARK_GRAY, "dark gray");
        names.put(Color.GRAY, "gray");
        names.put(Color.GREEN, "green");
        names.put(Color.LIGHT_GRAY, "light gray");
        names.put(Color.MAGENTA, "magenta");
        names.put(Color.ORANGE, "orange");
        names.put(Color.PINK, "pink");
        names.put(Color.RED, "red");
        names.put(Color.YELLOW, "yellow");
    }
}

