/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class BooleanEditor
implements PropertyEditor,
TableCellEditor {
    private JCheckBox editor;
    private Model model;
    private boolean selected;
    private Class type;
    private PropertyChangeSupport pcSupport;
    private EventListenerList listeners = new EventListenerList();
    private ChangeEvent evt;

    public BooleanEditor() {
        this.pcSupport = new PropertyChangeSupport(this);
    }

    private void initEditor() {
        if (this.editor == null) {
            this.model = new Model();
            this.editor = new JCheckBox();
            this.editor.setModel(this.model);
        }
    }

    public String getAsText() {
        return String.valueOf(this.selected);
    }

    public Object getValue() {
        return this.selected ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Boolean bl;
        if ("true".equalsIgnoreCase(string)) {
            bl = Boolean.TRUE;
        } else if ("false".equalsIgnoreCase(string)) {
            bl = Boolean.FALSE;
        } else {
            throw new IllegalArgumentException(string);
        }
        this.setValue(bl);
    }

    public void setValue(Object object) {
        Boolean bl = (Boolean)object;
        if (this.selected ^ bl) {
            Boolean bl2 = this.selected ? Boolean.TRUE : Boolean.FALSE;
            this.selected = bl;
            this.pcSupport.firePropertyChange("value", bl2, bl);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.initEditor();
        return this.editor;
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Object getCellEditorValue() {
        return this.selected ? Boolean.TRUE : Boolean.FALSE;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.initEditor();
        this.editor.setForeground(jTable.getForeground());
        this.editor.setBackground(jTable.getBackground());
        this.setValue(object);
        return this.editor;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(CellEditorListener.class, cellEditorListener);
    }

    private void fireEditingStopped() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cellEditorListener.editingStopped(this.evt);
        }
    }

    private void fireEditingCanceled() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cellEditorListener.editingCanceled(this.evt);
        }
    }

    private class Model
    extends JToggleButton.ToggleButtonModel {
        private Model() {
        }

        public void setSelected(boolean bl) {
            BooleanEditor.this.setValue(bl ? Boolean.TRUE : Boolean.FALSE);
            BooleanEditor.this.fireEditingStopped();
        }

        public boolean isSelected() {
            return (Boolean)BooleanEditor.this.getValue();
        }
    }
}

