/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class TearoffTabbedPane
extends JTabbedPane {
    HashMap tabs = new HashMap();

    public TearoffTabbedPane() {
        this.addMouseListener(this.getMouseAdapter());
    }

    private MouseAdapter getMouseAdapter() {
        return new MouseAdapter(){
            int selectedTab;
            JPopupMenu tearOffMenu = new JPopupMenu();
            Component selectedComponent;
            JPopupMenu dockMenu;
            {
                this.tearOffMenu.add(new JMenuItem(new AbstractAction("tear off"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TearoffTabbedPane.this.tearOffIntoFrame(selectedTab);
                    }
                }));
                this.dockMenu = new JPopupMenu();
                this.dockMenu.add(new JMenuItem(new AbstractAction("show"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TabDesc tabDesc = null;
                        Component component = null;
                        for (Component component2 : TearoffTabbedPane.this.tabs.keySet()) {
                            TabDesc tabDesc2 = (TabDesc)TearoffTabbedPane.this.tabs.get(component2);
                            if (tabDesc2.index != selectedTab) continue;
                            tabDesc = tabDesc2;
                            component = component2;
                            break;
                        }
                        tabDesc.babysitter.setVisible(true);
                    }
                }));
                this.dockMenu.add(new JMenuItem(new AbstractAction("dock"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TabDesc tabDesc = null;
                        Component component = null;
                        for (Component component2 : TearoffTabbedPane.this.tabs.keySet()) {
                            TabDesc tabDesc2 = (TabDesc)TearoffTabbedPane.this.tabs.get(component2);
                            if (tabDesc2.index != selectedTab) continue;
                            tabDesc = tabDesc2;
                            component = component2;
                            break;
                        }
                        if (tabDesc.babysitter instanceof JFrame) {
                            ((JFrame)tabDesc.babysitter).dispose();
                        }
                        TearoffTabbedPane.this.dock(component);
                    }
                }));
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    this.selectedTab = TearoffTabbedPane.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                    this.selectedComponent = TearoffTabbedPane.this.getComponentAt(this.selectedTab);
                    if (TearoffTabbedPane.this.tabs.get(this.selectedComponent) != null) {
                        this.tearOffMenu.show(TearoffTabbedPane.this, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.dockMenu.show(TearoffTabbedPane.this, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        };
    }

    static Component getTornOffComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("<html><i>This tab is torn off.  Right-click on the tab name and select dock.</i></html>"), "North");
        return jPanel;
    }

    public void tearOff(int n, Container container) {
        Component component = this.getComponentAt(n);
        String string = super.getTitleAt(n);
        super.removeTabAt(n);
        super.insertTab("(" + string + ")", null, TearoffTabbedPane.getTornOffComponent(), null, n);
        TabDesc tabDesc = (TabDesc)this.tabs.get(component);
        tabDesc.babysitter = container;
        this.setSelectedIndex(Math.max(n - 1, 0));
    }

    public void tearOffIntoFrame(int n) {
        final Component component = this.getComponentAt(n);
        Point point = component.getLocationOnScreen();
        TabDesc tabDesc = (TabDesc)this.tabs.get(component);
        JFrame jFrame = new JFrame(tabDesc.title);
        point.translate(20, 20);
        jFrame.setLocation(point);
        jFrame.addWindowListener(new AbstractWindowListener(){

            public void windowClosing(WindowEvent windowEvent) {
                TearoffTabbedPane.this.dock(component);
            }
        });
        JTabbedPane jTabbedPane = new JTabbedPane();
        jFrame.getContentPane().add(jTabbedPane);
        this.tearOff(n, jFrame);
        jTabbedPane.add(tabDesc.title, component);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void dock(Component component) {
        TabDesc tabDesc = (TabDesc)this.tabs.get(component);
        int n = tabDesc.index;
        super.removeTabAt(n);
        super.insertTab(tabDesc.title, tabDesc.icon, component, tabDesc.tip, n);
    }

    public void addTab(String string, Icon icon, Component component) {
        super.addTab(string, icon, component);
        this.tabs.put(component, new TabDesc(string, icon, component, null, this.indexOfComponent(component)));
    }

    public void addTab(String string, Component component) {
        super.addTab(string, component);
        this.tabs.put(component, new TabDesc(string, null, component, null, this.indexOfComponent(component)));
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        this.tabs.put(component, new TabDesc(string, icon, component, string2, n));
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        super.addTab(string, icon, component, string2);
        this.tabs.put(component, new TabDesc(string, icon, component, string2, this.indexOfComponent(component)));
    }

    public void removeTabAt(int n) {
        super.removeTabAt(n);
        this.tabs.remove(this.getComponentAt(n));
    }

    private class AbstractWindowListener
    implements WindowListener {
        private AbstractWindowListener() {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }

    class TabDesc {
        Icon icon;
        String title;
        String tip;
        int index;
        Container babysitter;

        TabDesc(String string, Icon icon, Component component, String string2, int n) {
            this.title = string;
            this.icon = icon;
            this.tip = string2;
            this.index = n;
            this.babysitter = null;
        }
    }
}

