/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class DatumEditor
extends JComponent
implements PropertyEditor,
TableCellEditor {
    private JTextField editor;
    private JButton unitsButton;
    private Units units = Units.dimensionless;
    private ActionListener actionListener;
    private Datum value;
    private EventListenerList listeners;
    private ChangeEvent evt;

    public DatumEditor() {
        this.initComponents();
        this.installListeners();
        this.initToolTips();
        this.setFocusable(true);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.editor = new JTextField(8);
        this.editor.setFocusable(false);
        this.add((Component)this.editor, "Center");
        this.unitsButton = new JButton();
        this.unitsButton.setFocusable(false);
        this.add((Component)this.unitsButton, "East");
    }

    private void installListeners() {
        UniversalListener universalListener = new UniversalListener();
        this.editor.addMouseListener(universalListener);
        this.unitsButton.addMouseListener(universalListener);
        this.addKeyListener(universalListener);
        this.addFocusListener(universalListener);
    }

    private void initToolTips() {
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setColumns(int n) {
        this.editor.setColumns(n);
    }

    public void setValue(Object object) {
        if (!(object instanceof Datum)) {
            throw new IllegalArgumentException();
        }
        this.setDatum((Datum)object);
    }

    private void setDatum(Datum datum) {
        Datum datum2 = this.value;
        this.value = datum;
        Units units = datum.getUnits();
        if (datum.getUnits() instanceof TimeLocationUnits) {
            this.editor.setText(TimeDatumFormatter.DEFAULT.format(datum, units));
        } else {
            this.editor.setText(datum.getFormatter().format(datum, units));
        }
        this.setUnits(units);
        if (datum2 != this.value && datum2 != null && !datum2.equals(this.value)) {
            this.firePropertyChange("value", datum2, this.value);
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
        try {
            this.setDatum(this.units.parse(string));
        }
        catch (ParseException parseException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(parseException.getMessage());
            illegalArgumentException.initCause(parseException);
            throw illegalArgumentException;
        }
    }

    public Object getValue() {
        return this.getDatum();
    }

    public Datum getDatum() {
        try {
            String string = this.editor.getText();
            Datum datum = this.units.parse(string);
            if (!datum.equals(this.value)) {
                Datum datum2 = this.value;
                this.value = datum;
                this.firePropertyChange("value", datum2, this.value);
            }
            return this.value;
        }
        catch (ParseException parseException) {
            if (this.value != null) {
                this.setDatum(this.value);
                return this.value;
            }
            return null;
        }
    }

    public String getAsText() {
        Datum datum = this.getDatum();
        if (datum == null) {
            return null;
        }
        return this.editor.getText();
    }

    public void setUnits(Units units) {
        if (units instanceof TimeLocationUnits) {
            this.unitsButton.setVisible(false);
        } else {
            this.unitsButton.setVisible(true);
            this.unitsButton.setText(units.toString());
            this.unitsButton.setToolTipText(units.toString());
        }
        this.units = units;
    }

    public Units getUnits() {
        return this.units;
    }

    private void fireActionPerformed() {
        this.setDatum(this.getDatum());
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "DatumEditor"));
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.unitsButton.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
            return this.unitsButton.getToolTipText();
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.setValue(object);
        return this;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        if (this.listeners != null) {
            this.listeners.remove(CellEditorListener.class, cellEditorListener);
        }
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public Object getCellEditorValue() {
        return this.getDatum();
    }

    public boolean stopCellEditing() {
        if (this.getDatum() == null) {
            return false;
        }
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    private void fireEditingStopped() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cellEditorListener.editingStopped(this.evt);
        }
    }

    private void fireEditingCanceled() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cellEditorListener.editingCanceled(this.evt);
        }
    }

    private class UniversalListener
    implements MouseListener,
    KeyListener,
    FocusListener {
        private UniversalListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            DatumEditor.this.editor.getCaret().setVisible(true);
            DatumEditor.this.editor.getCaret().setSelectionVisible(true);
        }

        public void focusLost(FocusEvent focusEvent) {
            DatumEditor.this.editor.getCaret().setVisible(false);
            DatumEditor.this.editor.getCaret().setSelectionVisible(false);
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                DatumEditor.this.fireActionPerformed();
            } else {
                this.forwardKeyEvent(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.forwardKeyEvent(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.forwardKeyEvent(keyEvent);
        }

        private void forwardKeyEvent(KeyEvent keyEvent) {
            keyEvent.setSource(DatumEditor.this.editor);
            DatumEditor.this.editor.dispatchEvent(keyEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DatumEditor.this.requestFocusInWindow();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

