/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.components.DasProgressPanel;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyEditor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.CommentDataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DataPointRecorder
extends JPanel
implements DataPointSelectionListener {
    protected JTable table;
    protected JScrollPane scrollPane;
    protected List dataPoints;
    private int selectRow;
    protected Units[] unitsArray;
    protected String[] planesArray;
    protected AbstractTableModel myTableModel;
    private File saveFile;
    private boolean modified;
    private JLabel messageLabel;
    private boolean active = true;
    Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    static Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    private MyDataSetDescriptor dataSetDescriptor;
    private EventListenerList listenerList = null;
    private EventListenerList selectedListenerList = null;
    private boolean sorted = true;
    private Datum xTagWidth = null;
    private boolean snapToGrid = false;

    public void deleteRow(int n) {
        this.dataPoints.remove(n);
        this.modified = true;
        this.updateClients();
        this.updateStatus();
        this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
    }

    public DataSetDescriptor getDataSetDescriptor() {
        if (this.dataSetDescriptor == null) {
            this.dataSetDescriptor = new MyDataSetDescriptor();
        }
        return this.dataSetDescriptor;
    }

    public VectorDataSet getDataSet() {
        int n;
        if (this.dataPoints.size() == 0) {
            return null;
        }
        VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(this.unitsArray[0], this.unitsArray[1]);
        for (n = 2; n < this.planesArray.length; ++n) {
            if (this.unitsArray[n] == null) continue;
            vectorDataSetBuilder.addPlane(this.planesArray[n], this.unitsArray[n]);
        }
        for (n = 0; n < this.dataPoints.size(); ++n) {
            DataPoint dataPoint = (DataPoint)this.dataPoints.get(n);
            vectorDataSetBuilder.insertY(dataPoint.get(0), dataPoint.get(1));
            for (int i = 2; i < this.planesArray.length; ++i) {
                if (this.unitsArray[i] == null) continue;
                vectorDataSetBuilder.insertY(dataPoint.get(0), (Datum)dataPoint.getPlane(this.planesArray[i]), this.planesArray[i]);
            }
        }
        if (this.xTagWidth != null) {
            vectorDataSetBuilder.setProperty("xTagWidth", this.xTagWidth);
        }
        return vectorDataSetBuilder.toVectorDataSet();
    }

    public VectorDataSet getSelectedDataSet() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(this.unitsArray[0], this.unitsArray[1]);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            DataPoint dataPoint = (DataPoint)this.dataPoints.get(n);
            vectorDataSetBuilder.insertY(dataPoint.get(0), dataPoint.get(1));
        }
        if (this.xTagWidth != null) {
            vectorDataSetBuilder.setProperty("xTagWidth", this.xTagWidth);
        }
        return vectorDataSetBuilder.toVectorDataSet();
    }

    public void select(DatumRange datumRange, DatumRange datumRange2) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.dataPoints.size(); ++n) {
            DataPoint dataPoint = (DataPoint)this.dataPoints.get(n);
            if (!datumRange.contains(dataPoint.data[0]) || !datumRange2.contains(dataPoint.data[1])) continue;
            arrayList.add(new Integer(n));
        }
        this.table.getSelectionModel().clearSelection();
        for (n = 0; n < arrayList.size(); ++n) {
            int n2 = (Integer)arrayList.get(n);
            this.table.getSelectionModel().addSelectionInterval(n2, n2);
        }
    }

    public void saveToFile(File file) throws IOException {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("## ");
        for (n = 0; n < this.planesArray.length; ++n) {
            stringBuffer.append(this.myTableModel.getColumnName(n) + "\t");
        }
        bufferedWriter.write(stringBuffer.toString());
        bufferedWriter.newLine();
        for (n = 0; n < this.dataPoints.size(); ++n) {
            int n2;
            DataPoint dataPoint = (DataPoint)this.dataPoints.get(n);
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n2 = 0; n2 < 2; ++n2) {
                stringBuffer2.append(String.valueOf(dataPoint.get(n2)) + "\t");
            }
            for (n2 = 2; n2 < this.planesArray.length; ++n2) {
                Object object = dataPoint.getPlane(this.planesArray[n2]);
                if (this.unitsArray[n2] == null) {
                    if (object == null) {
                        object = "";
                    }
                    stringBuffer2.append("\"" + object + "\"\t");
                    continue;
                }
                stringBuffer2.append(object + "\t");
            }
            bufferedWriter.write(stringBuffer2.toString());
            bufferedWriter.newLine();
            this.prefs.put("components.DataPointRecorder.lastFileSave", file.toString());
            this.prefs.put("components.DataPointRecorder.lastFileLoad", file.toString());
        }
        bufferedWriter.close();
        this.modified = false;
        this.updateStatus();
    }

    public void loadFromFile(File file) throws IOException {
        this.active = false;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        int n = 0;
        String[] stringArray = bufferedReader.readLine();
        while (stringArray != null) {
            ++n;
            stringArray = bufferedReader.readLine();
        }
        bufferedReader.close();
        fileInputStream = new FileInputStream(file);
        bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        this.dataPoints.clear();
        stringArray = null;
        Units[] unitsArray = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        DasProgressMonitor dasProgressMonitor = n > 500 ? DasProgressPanel.createFramed("reading file") : DasProgressMonitor.NULL;
        dasProgressMonitor.setTaskSize(n);
        dasProgressMonitor.started();
        int n2 = 0;
        String string = bufferedReader.readLine();
        while (string != null) {
            Matcher matcher;
            Serializable serializable;
            String[] stringArray2;
            ++n2;
            if (dasProgressMonitor.isCancelled()) break;
            dasProgressMonitor.setTaskProgress(n2);
            if (string.startsWith("## ")) {
                string = string.substring(3);
                stringArray2 = string.split("\t");
                serializable = Pattern.compile("(.+)\\((.*)\\)");
                stringArray = new String[stringArray2.length];
                unitsArray = new Units[stringArray2.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    matcher = serializable.matcher(stringArray2[i]);
                    if (matcher.matches()) {
                        stringArray[i] = matcher.group(1);
                        unitsArray[i] = Units.getByName(matcher.group(2));
                        continue;
                    }
                    stringArray[i] = stringArray2[i];
                    unitsArray[i] = null;
                }
            } else {
                stringArray2 = string.split("\t");
                if (unitsArray == null) {
                    unitsArray = new Units[stringArray2.length];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        unitsArray[i] = stringArray2[i].charAt(0) == '\"' ? null : (TimeUtil.isValidTime(stringArray2[i]) ? Units.us2000 : DatumUtil.parseValid(stringArray2[i]).getUnits());
                    }
                    stringArray = new String[]{"X", "Y", "comment"};
                }
                try {
                    Datum datum = unitsArray[0].parse(stringArray2[0]);
                    Datum datum2 = unitsArray[1].parse(stringArray2[1]);
                    hashMap = new HashMap();
                    for (int i = 2; i < stringArray2.length; ++i) {
                        if (unitsArray[i] == null) {
                            Pattern pattern = Pattern.compile("\"(.*)\".*");
                            matcher = pattern.matcher(stringArray2[i]);
                            if (matcher.matches()) {
                                hashMap.put(stringArray[i], matcher.group(1));
                                continue;
                            }
                            throw new ParseException("parse error, expected \"\"", 0);
                        }
                        try {
                            hashMap.put(stringArray[i], unitsArray[i].parse(stringArray2[i]));
                            continue;
                        }
                        catch (ParseException parseException) {
                            throw new RuntimeException(parseException);
                        }
                    }
                    serializable = new DataPointSelectionEvent(this, datum, datum2, hashMap);
                    this.DataPointSelected((DataPointSelectionEvent)serializable);
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(parseException);
                }
            }
            string = bufferedReader.readLine();
        }
        dasProgressMonitor.finished();
        this.active = true;
        this.modified = false;
        this.updateStatus();
        this.updateClients();
        this.prefs.put("components.DataPointRecorder.lastFileLoad", file.toString());
        this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
    }

    private Action getSaveAsAction() {
        return new AbstractAction("Save As..."){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                JFileChooser jFileChooser = new JFileChooser();
                String string = DataPointRecorder.this.prefs.get("components.DataPointRecorder.lastFileSave", "");
                File file = null;
                if (string != "") {
                    file = new File(string);
                    jFileChooser.setSelectedFile(file);
                }
                if ((n = jFileChooser.showSaveDialog(DataPointRecorder.this)) == 0) {
                    try {
                        DataPointRecorder.this.saveFile = jFileChooser.getSelectedFile();
                        DataPointRecorder.this.saveToFile(DataPointRecorder.this.saveFile);
                    }
                    catch (IOException iOException) {
                        DasExceptionHandler.handle(iOException);
                    }
                }
            }
        };
    }

    private Action getSaveAction() {
        return new AbstractAction("Save"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataPointRecorder.this.saveFile == null) {
                    DataPointRecorder.this.getSaveAsAction().actionPerformed(actionEvent);
                } else {
                    try {
                        DataPointRecorder.this.saveToFile(DataPointRecorder.this.saveFile);
                    }
                    catch (IOException iOException) {
                        DasExceptionHandler.handle(iOException);
                    }
                }
            }
        };
    }

    private Action getLoadAction() {
        return new AbstractAction("Open..."){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataPointRecorder.this.checkModified(actionEvent)) {
                    int n;
                    JFileChooser jFileChooser = new JFileChooser();
                    String string = DataPointRecorder.this.prefs.get("components.DataPointRecorder.lastFileLoad", "");
                    File file = null;
                    if (string != "") {
                        file = new File(string);
                        jFileChooser.setSelectedFile(file);
                    }
                    if ((n = jFileChooser.showOpenDialog(DataPointRecorder.this)) == 0) {
                        final File file2 = jFileChooser.getSelectedFile();
                        DataPointRecorder.this.prefs.put("components.DataPointRecorder.lastFileLoad", file2.toString());
                        Runnable runnable = new Runnable(){

                            public void run() {
                                try {
                                    DataPointRecorder.this.loadFromFile(file2);
                                    DataPointRecorder.this.saveFile = file2;
                                    DataPointRecorder.this.updateStatus();
                                }
                                catch (IOException iOException) {
                                    DasExceptionHandler.handle(iOException);
                                }
                            }
                        };
                        new Thread(runnable).start();
                    }
                }
            }
        };
    }

    private boolean checkModified(ActionEvent actionEvent) {
        if (this.modified) {
            int n = JOptionPane.showConfirmDialog(this, "Current work has not been saved.\n  Save first?", "Save work first", 1);
            if (n == 0) {
                this.getSaveAction().actionPerformed(actionEvent);
            }
            return n != 2;
        }
        return true;
    }

    private Action getNewAction() {
        return new AbstractAction("New"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataPointRecorder.this.checkModified(actionEvent)) {
                    DataPointRecorder.this.dataPoints.removeAll(DataPointRecorder.this.dataPoints);
                    DataPointRecorder.this.saveFile = null;
                    DataPointRecorder.this.updateStatus();
                    DataPointRecorder.this.updateClients();
                }
            }
        };
    }

    private Action getPropertiesAction() {
        return new AbstractAction("Properties"){

            public void actionPerformed(ActionEvent actionEvent) {
                new PropertyEditor(DataPointRecorder.this).showDialog(DataPointRecorder.this);
            }
        };
    }

    private Action getUpdateAction() {
        return new AbstractAction("Update"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataPointRecorder.this.dataSetDescriptor != null) {
                    DataPointRecorder.this.dataSetDescriptor.fireUpdate();
                }
                DataPointRecorder.this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
                DataPointRecorder.this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
            }
        };
    }

    public DataPointRecorder() {
        this.dataPoints = new ArrayList();
        this.myTableModel = new MyTableModel();
        this.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.add(new JMenuItem(this.getNewAction()));
        jMenu.add(new JMenuItem(this.getLoadAction()));
        jMenu.add(new JMenuItem(this.getSaveAction()));
        jMenu.add(new JMenuItem(this.getSaveAsAction()));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.add(new JMenuItem(this.getPropertiesAction()));
        jMenuBar.add(jMenu2);
        this.add((Component)jMenuBar, "North");
        this.planesArray = new String[]{"X", "Y"};
        this.unitsArray = new Units[]{null, null};
        this.table = new JTable(this.myTableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new MyMouseAdapter(this.table));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataPointRecorder.this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(DataPointRecorder.this));
                int n = DataPointRecorder.this.table.getSelectedRow();
                if (n > -1) {
                    DataPoint dataPoint = (DataPoint)DataPointRecorder.this.dataPoints.get(n);
                    DataPointSelectionEvent dataPointSelectionEvent = new DataPointSelectionEvent(DataPointRecorder.this, dataPoint.get(0), dataPoint.get(1));
                    DataPointRecorder.this.fireDataPointSelectionListenerDataPointSelected(dataPointSelectionEvent);
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JButton jButton = new JButton(this.getUpdateAction());
        jPanel2.add(jButton);
        this.messageLabel = new JLabel("ready");
        this.messageLabel.setAlignmentX(0.0f);
        jPanel.add(this.messageLabel);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "South");
    }

    public static DataPointRecorder createFramed() {
        JFrame jFrame = new JFrame("Data Point Recorder");
        DataPointRecorder dataPointRecorder = new DataPointRecorder();
        jFrame.getContentPane().add(dataPointRecorder);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(1);
        return dataPointRecorder;
    }

    private void updateClients() {
        if (this.active) {
            this.myTableModel.fireTableDataChanged();
            if (this.selectRow != -1) {
                this.table.setRowSelectionInterval(this.selectRow, this.selectRow);
                this.table.scrollRectToVisible(this.table.getCellRect(this.selectRow, 0, true));
                this.selectRow = -1;
            }
        }
    }

    private void updateStatus() {
        String string = (this.saveFile == null ? "" : String.valueOf(this.saveFile) + " ") + (this.modified ? "(modified)" : "");
        this.messageLabel.setText(string);
    }

    private void insertInternal(DataPoint dataPoint) {
        int n;
        if (this.sorted) {
            int n2 = Collections.binarySearch(this.dataPoints, dataPoint);
            if (n2 < 0) {
                this.dataPoints.add(~n2, dataPoint);
                n = ~n2;
            } else {
                this.dataPoints.set(n2, dataPoint);
                n = n2;
            }
        } else {
            this.dataPoints.add(dataPoint);
            n = this.dataPoints.size() - 1;
        }
        this.selectRow = n;
        this.modified = true;
        this.updateStatus();
    }

    private void addDataPoint(Datum datum, Datum datum2, HashMap hashMap) {
        if (this.dataPoints.size() == 0) {
            Datum[] datumArray = new Datum[]{datum, datum2};
            this.unitsArray = new Units[2 + hashMap.size()];
            this.unitsArray[0] = datum.getUnits();
            this.unitsArray[1] = datum2.getUnits();
            this.planesArray = new String[2 + hashMap.size()];
            this.planesArray[0] = "x";
            this.planesArray[1] = "y";
            int n = 2;
            for (Object k : hashMap.keySet()) {
                this.planesArray[n] = String.valueOf(k);
                Object v = hashMap.get(k);
                this.unitsArray[n] = v instanceof String ? null : ((Datum)v).getUnits();
                ++n;
            }
            this.myTableModel.fireTableStructureChanged();
        }
        if (!datum.getUnits().isConvertableTo(this.unitsArray[0])) {
            throw new RuntimeException("inconvertable units: " + datum + " expected " + this.unitsArray[0]);
        }
        if (!datum2.getUnits().isConvertableTo(this.unitsArray[1])) {
            throw new RuntimeException("inconvertable units: " + datum2 + " expected " + this.unitsArray[1]);
        }
        this.insertInternal(new DataPoint(datum, datum2, new HashMap(hashMap)));
        if (this.active) {
            this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
        }
    }

    public void appendDataSet(VectorDataSet vectorDataSet) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (vectorDataSet.getProperty("comment") != null) {
            hashMap.put("comment", vectorDataSet.getProperty("comment"));
        }
        if (vectorDataSet.getProperty("xTagWidth") != null) {
            this.xTagWidth = (Datum)vectorDataSet.getProperty("xTagWidth");
        }
        String[] stringArray = vectorDataSet.getPlaneIds();
        for (int i = 0; i < vectorDataSet.getXLength(); ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].equals("")) continue;
                hashMap.put(stringArray[j], ((VectorDataSet)vectorDataSet.getPlanarView(stringArray[j])).getDatum(i));
            }
            this.addDataPoint(vectorDataSet.getXTagDatum(i), vectorDataSet.getDatum(i), hashMap);
        }
        this.updateClients();
    }

    public DataSetUpdateListener getAppendDataSetUpListener() {
        return new DataSetUpdateListener(){

            public void dataSetUpdated(DataSetUpdateEvent dataSetUpdateEvent) {
                VectorDataSet vectorDataSet = (VectorDataSet)dataSetUpdateEvent.getDataSet();
                if (vectorDataSet == null) {
                    throw new RuntimeException("not supported, I need the DataSet in the update event");
                }
                DataPointRecorder.this.appendDataSet((VectorDataSet)dataSetUpdateEvent.getDataSet());
            }
        };
    }

    public void DataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        Object object;
        HashMap<String, Object> hashMap;
        String string = "";
        if (dataPointSelectionEvent instanceof CommentDataPointSelectionEvent) {
            string = ((CommentDataPointSelectionEvent)dataPointSelectionEvent).getComment();
            hashMap = new HashMap();
            hashMap.put("comment", string);
        } else {
            object = dataPointSelectionEvent.getPlaneIds();
            hashMap = new HashMap<String, Object>();
            for (int i = 0; i < ((String[])object).length; ++i) {
                hashMap.put(object[i], dataPointSelectionEvent.getPlane(object[i]));
            }
        }
        object = dataPointSelectionEvent.getX();
        if (this.snapToGrid && this.xTagWidth != null && this.dataPoints.size() > 0) {
            VectorDataSet vectorDataSet = this.getDataSet();
            int n = DataSetUtil.closestColumn(vectorDataSet, dataPointSelectionEvent.getX());
            Datum datum = dataPointSelectionEvent.getX().subtract(vectorDataSet.getXTagDatum(n));
            if (Math.abs(datum.divide(this.xTagWidth).doubleValue(Units.dimensionless)) < 0.5) {
                object = vectorDataSet.getXTagDatum(n);
            }
        }
        this.addDataPoint((Datum)object, dataPointSelectionEvent.getY(), hashMap);
        this.updateClients();
    }

    public synchronized void addDataSetUpdateListener(DataSetUpdateListener dataSetUpdateListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataSetUpdateListener.class, dataSetUpdateListener);
    }

    public synchronized void removeDataSetUpdateListener(DataSetUpdateListener dataSetUpdateListener) {
        this.listenerList.remove(DataSetUpdateListener.class, dataSetUpdateListener);
    }

    private void fireDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent dataSetUpdateEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)objectArray[i + 1]).dataSetUpdated(dataSetUpdateEvent);
        }
    }

    public synchronized void addSelectedDataSetUpdateListener(DataSetUpdateListener dataSetUpdateListener) {
        if (this.selectedListenerList == null) {
            this.selectedListenerList = new EventListenerList();
        }
        this.selectedListenerList.add(DataSetUpdateListener.class, dataSetUpdateListener);
    }

    public synchronized void removeSelectedDataSetUpdateListener(DataSetUpdateListener dataSetUpdateListener) {
        this.selectedListenerList.remove(DataSetUpdateListener.class, dataSetUpdateListener);
    }

    private void fireSelectedDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent dataSetUpdateEvent) {
        if (this.selectedListenerList == null) {
            return;
        }
        Object[] objectArray = this.selectedListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)objectArray[i + 1]).dataSetUpdated(dataSetUpdateEvent);
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    public synchronized void addDataPointSelectionListener(DataPointSelectionListener dataPointSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataPointSelectionListener.class, dataPointSelectionListener);
    }

    public synchronized void removeDataPointSelectionListener(DataPointSelectionListener dataPointSelectionListener) {
        this.listenerList.remove(DataPointSelectionListener.class, dataPointSelectionListener);
    }

    private void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        logger.fine("firing data point selection event");
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)objectArray[i + 1]).DataPointSelected(dataPointSelectionEvent);
        }
    }

    public Datum getXTagWidth() {
        return this.xTagWidth;
    }

    public void setXTagWidth(Datum datum) {
        this.xTagWidth = datum;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean bl) {
        this.snapToGrid = bl;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        JPopupMenu popup;
        JMenuItem menuItem;
        final JTable parent;
        MouseAdapter mm;

        MyMouseAdapter(final JTable jTable) {
            this.parent = jTable;
            this.popup = new JPopupMenu("Options");
            this.menuItem = new JMenuItem("Delete Row(s)");
            this.menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = jTable.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        DataPointRecorder.this.deleteRow(nArray[i]);
                        int n = i + 1;
                        while (n < nArray.length) {
                            int n2 = n++;
                            nArray[n2] = nArray[n2] - 1;
                        }
                    }
                }
            });
            this.popup.add(this.menuItem);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                int n = this.parent.getSelectedRows().length;
                this.menuItem.setText("Delete " + n + " Row" + (n != 1 ? "s" : ""));
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class MyDataSetDescriptor
    extends DataSetDescriptor {
        MyDataSetDescriptor() {
            super(null);
        }

        public void fireUpdate() {
            this.fireDataSetUpdateEvent(new DataSetUpdateEvent((Object)this));
        }

        protected DataSet getDataSetImpl(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
            if (DataPointRecorder.this.dataPoints.size() == 0) {
                return null;
            }
            VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(DataPointRecorder.this.unitsArray[0], DataPointRecorder.this.unitsArray[1]);
            for (int i = 0; i < DataPointRecorder.this.dataPoints.size(); ++i) {
                DataPoint dataPoint = (DataPoint)DataPointRecorder.this.dataPoints.get(i);
                vectorDataSetBuilder.insertY(dataPoint.get(0), dataPoint.get(1));
            }
            return vectorDataSetBuilder.toVectorDataSet();
        }

        public Units getXUnits() {
            return DataPointRecorder.this.unitsArray[0];
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public int getColumnCount() {
            if (DataPointRecorder.this.unitsArray == null) {
                return 2;
            }
            return DataPointRecorder.this.planesArray.length;
        }

        public String getColumnName(int n) {
            String string = DataPointRecorder.this.planesArray[n];
            if (DataPointRecorder.this.unitsArray[n] != null) {
                string = string + "(" + DataPointRecorder.this.unitsArray[n] + ")";
            }
            return string;
        }

        public int getRowCount() {
            int n = DataPointRecorder.this.dataPoints.size();
            n = n > 0 ? n : 1;
            return DataPointRecorder.this.dataPoints.size();
        }

        public Object getValueAt(int n, int n2) {
            DataPoint dataPoint = (DataPoint)DataPointRecorder.this.dataPoints.get(n);
            if (n2 < dataPoint.data.length) {
                return dataPoint.get(n2).toString();
            }
            return dataPoint.getPlane(DataPointRecorder.this.planesArray[n2]);
        }
    }

    protected class DataPoint
    implements Comparable {
        Datum[] data;
        HashMap planes;

        public DataPoint(Datum datum, Datum datum2, HashMap hashMap) {
            this(new Datum[]{datum, datum2}, hashMap);
        }

        public DataPoint(Datum[] datumArray, HashMap hashMap) {
            this.data = datumArray;
            this.planes = hashMap;
        }

        Datum get(int n) {
            return this.data[n];
        }

        Object getPlane(String string) {
            return this.planes.get(string);
        }

        public int compareTo(Object object) {
            DataPoint dataPoint = (DataPoint)object;
            return this.data[0].lt(dataPoint.data[0]) ? -1 : (this.data[0].gt(dataPoint.data[0]) ? 1 : 0);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("" + this.data[0] + " " + this.data[1]);
            if (this.planes != null) {
                for (Object k : this.planes.keySet()) {
                    stringBuffer.append(" " + this.planes.get(k));
                }
            }
            return stringBuffer.toString();
        }
    }
}

