/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

public class DasTimeRangeSelector
extends JPanel
implements TimeRangeSelectionListener {
    private DatumRange range = null;
    JTextField idStart = null;
    JTextField idStop = null;
    JButton viewButton = null;
    JPanel startStopModePane = null;
    CardLayout cardLayout = null;
    boolean updateRangeString = false;
    private EventListenerList listenerList = null;
    protected final Action previousAction = new AbstractAction("<<"){

        public void actionPerformed(ActionEvent actionEvent) {
            DasTimeRangeSelector.this.fireTimeRangeSelectedPrevious();
        }
    };
    protected final Action nextAction = new AbstractAction(">>"){

        public void actionPerformed(ActionEvent actionEvent) {
            DasTimeRangeSelector.this.fireTimeRangeSelectedNext();
        }
    };
    protected final Action rangeAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            DasTimeRangeSelector.this.fireTimeRangeSelected();
        }
    };
    private boolean favoritesEnabled = false;
    private List favoritesList = null;
    private JPopupMenu favoritesMenu = null;
    private final int FAVORITES_LIST_SIZE = 5;
    private String favoritesGroup;
    private JButton favoritesButton;
    private JPanel timesPane;
    private JComboBox rangeComboBox;

    public DasTimeRangeSelector() {
        this.updateRangeString = Preferences.userNodeForPackage(this.getClass()).getBoolean("updateRangeString", false);
        this.buildComponents();
    }

    private Action getModeAction() {
        return new AbstractAction("mode"){

            public void actionPerformed(ActionEvent actionEvent) {
                DasTimeRangeSelector.this.updateRangeString = !DasTimeRangeSelector.this.updateRangeString;
                Preferences.userNodeForPackage(this.getClass()).putBoolean("updateRangeString", DasTimeRangeSelector.this.updateRangeString);
                DasTimeRangeSelector.this.revalidateUpdateMode();
                DasTimeRangeSelector.this.update();
            }
        };
    }

    private void revalidateUpdateMode() {
        if (this.updateRangeString) {
            this.idStart.setColumns(28);
            this.idStop.setVisible(false);
            this.viewButton.setVisible(true);
        } else {
            this.idStart.setColumns(18);
            this.idStop.setVisible(true);
        }
        this.startStopModePane.revalidate();
    }

    private void buildComponents() {
        this.setLayout(new FlowLayout());
        JButton jButton = new JButton();
        jButton.setAction(this.previousAction);
        jButton.setActionCommand("previous");
        jButton.setToolTipText("Scan back in time");
        this.add(jButton);
        this.startStopModePane = new JPanel(new FlowLayout());
        this.cardLayout = new CardLayout();
        this.timesPane = new JPanel(this.cardLayout);
        JPanel jPanel = new JPanel(new FlowLayout());
        this.idStart = new JTextField(18);
        this.idStart.setAction(this.rangeAction);
        this.idStart.setActionCommand("startTime");
        jPanel.add(this.idStart);
        this.idStop = new JTextField(18);
        this.idStop.addActionListener(this.rangeAction);
        this.idStop.setActionCommand("endTime");
        jPanel.add(this.idStop);
        this.timesPane.add((Component)jPanel, "startStop");
        this.startStopModePane.add(this.timesPane);
        this.favoritesButton = new JButton("v");
        this.favoritesButton.setToolTipText("recently entries times");
        this.favoritesButton.setPreferredSize(new Dimension(20, 20));
        this.favoritesButton.setVisible(false);
        this.startStopModePane.add(this.favoritesButton);
        this.viewButton = new JButton(this.getModeAction());
        this.viewButton.setToolTipText("input mode: start/end vs time range string");
        this.viewButton.setPreferredSize(new Dimension(20, 20));
        this.startStopModePane.add(this.viewButton);
        this.add(this.startStopModePane);
        jButton = new JButton();
        jButton.setAction(this.nextAction);
        jButton.setActionCommand("next");
        jButton.setToolTipText("Scan forward in time");
        this.add(jButton);
        this.revalidateUpdateMode();
    }

    public DasTimeRangeSelector(Datum datum, Datum datum2) {
        this(new DatumRange(datum, datum2));
    }

    public DasTimeRangeSelector(DatumRange datumRange) {
        this();
        this.range = datumRange;
        this.update();
    }

    private void parseRange() {
        boolean bl = this.updateRangeString;
        if (this.idStop.getText().equals("")) {
            try {
                DatumRange datumRange;
                String string = this.idStart.getText();
                if (string.equals("")) {
                    string = (String)this.rangeComboBox.getEditor().getItem();
                }
                this.range = datumRange = DatumRangeUtil.parseTimeRange(string);
                this.updateRangeString = true;
            }
            catch (ParseException parseException) {
                DasExceptionHandler.handle(parseException);
            }
        } else {
            this.updateRangeString = false;
            try {
                Datum datum = TimeUtil.create(this.idStart.getText());
                Datum datum2 = TimeUtil.create(this.idStop.getText());
                this.range = new DatumRange(datum, datum2);
            }
            catch (ParseException parseException) {
                DasExceptionHandler.handle(parseException);
            }
        }
        if (this.updateRangeString != bl) {
            Preferences.userNodeForPackage(this.getClass()).putBoolean("updateRangeString", this.updateRangeString);
        }
    }

    private void refreshFavorites() {
        this.favoritesMenu.removeAll();
        for (final String string : this.favoritesList) {
            AbstractAction abstractAction = new AbstractAction(string){

                public void actionPerformed(ActionEvent actionEvent) {
                    DasTimeRangeSelector.this.setRange(DatumRangeUtil.parseTimeRangeValid(string));
                    DasTimeRangeSelector.this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, DasTimeRangeSelector.this.range));
                }
            };
            this.favoritesMenu.add(abstractAction);
        }
    }

    private void buildFavorites() {
        String string = Preferences.userNodeForPackage(this.getClass()).get("timeRangeSelector.favorites." + this.favoritesGroup, "");
        String[] stringArray = string.split("\\|\\|");
        this.favoritesList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            if ("".equals(stringArray[i])) continue;
            this.favoritesList.add(stringArray[i]);
        }
        this.favoritesMenu = new JPopupMenu();
        this.refreshFavorites();
        this.favoritesButton.add(this.favoritesMenu);
        this.favoritesButton.addActionListener(this.getFavoritesListener());
    }

    private ActionListener getFavoritesListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DasTimeRangeSelector.this.favoritesMenu.show(DasTimeRangeSelector.this, DasTimeRangeSelector.this.favoritesButton.getX(), DasTimeRangeSelector.this.favoritesButton.getY());
            }
        };
    }

    public void enableFavorites(String string) {
        if (string == null) {
            string = "default";
        }
        this.favoritesGroup = string;
        this.favoritesEnabled = true;
        this.favoritesButton.setVisible(true);
        this.buildFavorites();
    }

    public Datum getStartTime() {
        this.parseRange();
        return this.range.min();
    }

    public Datum getEndTime() {
        this.parseRange();
        return this.range.max();
    }

    public DatumRange getRange() {
        return this.range;
    }

    public void setRange(DatumRange datumRange) {
        this.range = datumRange;
        this.update();
    }

    private void update() {
        if (this.range != null) {
            if (this.updateRangeString) {
                String string = DatumRangeUtil.formatTimeRange(this.range);
                this.idStart.setText(string);
                this.idStop.setText("");
            } else {
                this.idStart.setText(this.range.min().toString());
                this.idStop.setText(this.range.max().toString());
            }
        }
    }

    public void setStartTime(Datum datum) {
        if (this.range == null) {
            return;
        }
        Datum datum2 = this.range.max();
        if (datum2.le(datum)) {
            datum2 = datum.add(1.0, Units.seconds);
        }
        this.range = new DatumRange(datum, datum2);
        this.update();
    }

    public void setEndTime(Datum datum) {
        if (this.range == null) {
            return;
        }
        Datum datum2 = this.range.min();
        if (datum2.ge(datum)) {
            datum2 = datum.subtract(1.0, Units.seconds);
        }
        this.range = new DatumRange(datum2, datum);
        this.update();
    }

    public boolean isWithin(Datum datum, Datum datum2) {
        Datum datum3 = this.getStartTime();
        Datum datum4 = this.getEndTime();
        return datum.compareTo(datum3) <= 0 && datum4.compareTo(datum2) <= 0;
    }

    public void timeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        DatumRange datumRange = timeRangeSelectionEvent.getRange();
        if (!datumRange.equals(this.range)) {
            this.setRange(timeRangeSelectionEvent.getRange());
            this.fireTimeRangeSelected(timeRangeSelectionEvent);
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(TimeRangeSelectionListener.class, timeRangeSelectionListener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        this.listenerList.remove(TimeRangeSelectionListener.class, timeRangeSelectionListener);
    }

    protected void fireTimeRangeSelectedPrevious() {
        this.range = this.range.previous();
        this.update();
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelectedNext() {
        this.range = this.range.next();
        this.update();
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelected() {
        this.parseRange();
        this.update();
        if (this.favoritesEnabled) {
            String string = this.range.toString();
            if (this.favoritesList.contains(string)) {
                this.favoritesList.remove(string);
            }
            this.favoritesList.add(0, string);
            for (int i = 5; i < this.favoritesList.size(); ++i) {
                this.favoritesList.remove(i);
            }
            this.refreshFavorites();
            this.saveFavorites();
        }
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TimeRangeSelectionListener.class) continue;
            String string = "fire event: " + this.getClass().getName() + "-->" + objectArray[i + 1].getClass().getName() + " " + timeRangeSelectionEvent;
            DasApplication.getDefaultApplication().getLogger(DasApplication.GUI_LOG).fine(string);
            ((TimeRangeSelectionListener)objectArray[i + 1]).timeRangeSelected(timeRangeSelectionEvent);
            ((TimeRangeSelectionListener)objectArray[i + 1]).timeRangeSelected(timeRangeSelectionEvent);
        }
    }

    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    private void saveFavorites() {
        if (this.favoritesList.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer((String)this.favoritesList.get(0));
        for (int i = 1; i < this.favoritesList.size(); ++i) {
            stringBuffer.append("||" + this.favoritesList.get(i));
        }
        Preferences.userNodeForPackage(this.getClass()).put("timeRangeSelector." + this.favoritesGroup, stringBuffer.toString());
    }
}

