/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DasProgressPanel
implements DasProgressMonitor {
    private long taskStartedTime;
    private long currentTaskPosition;
    private long maximumTaskPosition;
    private DecimalFormat transferRateFormat;
    private String transferRateString;
    private JLabel taskLabel;
    private boolean labelDirty = false;
    private JLabel progressMessageLabel;
    private String progressMessageString;
    private boolean progressMessageDirty = false;
    private JLabel kbLabel;
    private JProgressBar progressBar;
    private JFrame jframe;
    private boolean isCancelled = false;
    private JButton cancelButton;
    private int cancelCheckFailures = 0;
    private boolean cancelChecked = false;
    private String label;
    private static final int hideInitiallyMilliSeconds = 300;
    private static final int refreshPeriodMilliSeconds = 500;
    private boolean running = false;
    private boolean finished = false;
    private long lastRefreshTime;
    private ArrayList refreshTimeQueue;
    private Thread updateThread;
    private Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    private boolean showProgressRate;
    private JPanel thePanel;
    private boolean componentsInitialized = false;
    private DasCanvasComponent parentComponent;
    private static int createComponentCount = 0;
    static final boolean useDetails = false;
    Exception source;
    Exception consumer;

    public DasProgressPanel(String string) {
        this.label = string;
        this.transferRateFormat = new DecimalFormat();
        this.transferRateFormat.setMaximumFractionDigits(2);
        this.maximumTaskPosition = -1L;
        this.lastRefreshTime = Integer.MIN_VALUE;
        this.showProgressRate = true;
        this.isCancelled = false;
        this.running = false;
    }

    private void details() {
        System.err.println("Source: ");
        this.source.printStackTrace();
        System.err.println("Consumer: ");
        this.consumer.printStackTrace();
        if (this.finished) {
            String string = "finished";
        } else if (this.running) {
            String string = "running";
        } else if (this.isCancelled) {
            String string = "cancelled";
        }
        System.err.println("State: ");
        System.err.println("  running: " + this.running);
        System.err.println("  cancelled: " + this.isCancelled);
        System.err.println("  finished: " + this.finished);
    }

    public Component getComponent() {
        if (!this.componentsInitialized) {
            this.initComponents();
        }
        return this.thePanel;
    }

    public static DasProgressPanel createComponentPanel(DasCanvasComponent dasCanvasComponent, String string) {
        DasProgressPanel dasProgressPanel = new DasProgressPanel(string);
        dasProgressPanel.parentComponent = dasCanvasComponent;
        return dasProgressPanel;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public static DasProgressPanel createFramed(String string) {
        DasProgressPanel dasProgressPanel = new DasProgressPanel(string);
        dasProgressPanel.jframe = new JFrame("Das Progress Monitor");
        dasProgressPanel.initComponents();
        dasProgressPanel.jframe.getContentPane().add(dasProgressPanel.thePanel);
        dasProgressPanel.jframe.pack();
        dasProgressPanel.jframe.setVisible(true);
        dasProgressPanel.jframe.setDefaultCloseOperation(2);
        return dasProgressPanel;
    }

    public void setLabel(String string) {
        this.label = string;
        this.labelDirty = true;
        if (this.thePanel != null) {
            this.thePanel.repaint();
        }
    }

    public String getLabel() {
        return this.label;
    }

    private void initComponents() {
        ++createComponentCount;
        this.taskLabel = new JLabel();
        this.taskLabel.setOpaque(false);
        this.taskLabel.setFont(new Font("Dialog", 1, 18));
        this.taskLabel.setHorizontalAlignment(0);
        this.taskLabel.setText(this.label);
        this.taskLabel.setAlignmentX(0.5f);
        this.progressMessageLabel = new JLabel(){

            public void paint(Graphics graphics) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(graphics);
            }
        };
        this.progressMessageLabel.setOpaque(false);
        this.progressMessageLabel.setFont(new Font("Dialog", 1, 8));
        this.progressMessageLabel.setHorizontalAlignment(0);
        this.progressMessageLabel.setText(" ");
        this.progressMessageLabel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar();
        this.progressBar.setOpaque(false);
        this.progressBar.setMaximumSize(this.progressBar.getPreferredSize());
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        this.progressBar.setAlignmentX(0.5f);
        this.kbLabel = new JLabel();
        this.kbLabel.setOpaque(false);
        this.kbLabel.setHorizontalAlignment(0);
        this.kbLabel.setText("0 kb");
        this.kbLabel.setAlignmentX(0.5f);
        this.kbLabel.setMaximumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setMinimumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setPreferredSize(this.progressBar.getPreferredSize());
        this.kbLabel.setAlignmentX(0.5f);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.taskLabel);
        jPanel.add(this.progressMessageLabel);
        jPanel.add(this.progressBar);
        jPanel.add(this.kbLabel);
        LineBorder lineBorder = new LineBorder(Color.BLACK, 2);
        EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
        CompoundBorder compoundBorder = new CompoundBorder(lineBorder, emptyBorder);
        this.cancelButton = new JButton("cancel");
        this.cancelButton.setEnabled(false);
        this.cancelButton.setOpaque(false);
        this.cancelButton.setBorder(compoundBorder);
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DasProgressPanel.this.cancel();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.setOpaque(false);
        jPanel2.add(this.cancelButton);
        this.thePanel = new MyPanel();
        this.thePanel.setOpaque(false);
        this.thePanel.setLayout(new BorderLayout());
        this.thePanel.add((Component)jPanel, "Center");
        this.thePanel.add((Component)jPanel2, "South");
        if (this.parentComponent != null) {
            this.thePanel.setSize(this.thePanel.getPreferredSize());
            int n = this.parentComponent.getColumn().getDMiddle();
            int n2 = this.parentComponent.getRow().getDMiddle();
            this.thePanel.setLocation(n - this.thePanel.getWidth() / 2, n2 - this.thePanel.getHeight() / 2);
            ((Container)this.parentComponent.getCanvas().getGlassPane()).add(this.thePanel);
            this.thePanel.setVisible(false);
        }
        this.componentsInitialized = true;
    }

    public synchronized void finished() {
        this.running = false;
        this.finished = true;
        if (this.jframe == null) {
            this.setVisible(false);
        } else {
            this.jframe.dispose();
        }
    }

    public void setTaskProgress(long l) throws IllegalStateException {
        this.logger.finest("progressPosition=" + l);
        if (this.isCancelled) {
            this.logger.fine("setTaskProgress called when isCancelled true. consider checking isCancelled before calling setTaskProgress.");
            throw new IllegalStateException("Operation cancelled: developers: consider checking isCancelled before calling setTaskProgress.");
        }
        if (!this.running) {
            throw new IllegalStateException("setTaskProgress called before started");
        }
        if (l != 0L && l < this.currentTaskPosition) {
            this.logger.finest("progress position goes backwards");
        }
        if (!this.cancelChecked) {
            ++this.cancelCheckFailures;
        }
        this.cancelChecked = false;
        if (this.maximumTaskPosition == 0L) {
            throw new IllegalArgumentException("when taskSize is 0, setTaskProgress must not be called.");
        }
        this.currentTaskPosition = l;
        long l2 = System.currentTimeMillis() - this.taskStartedTime;
        if (l2 > 300L && !this.isVisible()) {
            this.setVisible(true);
        }
    }

    private void startUpdateThread() {
        Runnable runnable = new Runnable(){

            public void run() {
                while (!DasProgressPanel.this.finished) {
                    DasProgressPanel.this.updateUIComponents();
                    DasProgressPanel.this.thePanel.repaint();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.updateThread = new Thread(runnable, "progressMonitorUpdateThread");
        this.updateThread.start();
    }

    private void updateUIComponents() {
        boolean bl;
        long l = System.currentTimeMillis() - this.taskStartedTime;
        long l2 = this.currentTaskPosition;
        if (this.maximumTaskPosition == -1L) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
        }
        if (this.maximumTaskPosition > 0L) {
            this.progressBar.setValue((int)(l2 * 100L / this.maximumTaskPosition));
        } else {
            this.progressBar.setValue((int)l2 % 100);
        }
        String string = this.maximumTaskPosition > 0L ? "" + l2 + "/" + this.maximumTaskPosition + "" : "" + l2 + "";
        if (this.progressMessageDirty) {
            if (this.progressMessageString.length() > 33) {
                int n = this.progressMessageString.length();
                this.progressMessageString = this.progressMessageString.substring(0, 10) + "..." + this.progressMessageString.substring(n - 22, n);
            }
            this.progressMessageLabel.setText(this.progressMessageString);
            this.progressMessageDirty = false;
        }
        if (this.labelDirty) {
            this.taskLabel.setText(this.label);
            this.labelDirty = false;
        }
        if (this.showProgressRate && l > 1000L && this.transferRateString != null) {
            double d = (double)this.currentTaskPosition * 1000.0 / (double)l;
            this.kbLabel.setText(string + " " + this.transferRateString);
        } else {
            this.kbLabel.setText(string);
        }
        boolean bl2 = bl = this.cancelCheckFailures < 2;
        if (bl != this.cancelButton.isEnabled()) {
            this.cancelButton.setEnabled(bl);
        }
    }

    public void setAdditionalInfo(String string) {
        this.transferRateString = string;
    }

    public long getTaskProgress() {
        return this.currentTaskPosition;
    }

    public long getTaskSize() {
        return this.maximumTaskPosition;
    }

    public void setTaskSize(long l) {
        if (l < -1L) {
            throw new IllegalArgumentException("taskSize must be positive, -1, or 0, not " + l);
        }
        if (this.componentsInitialized) {
            this.progressBar.setIndeterminate(false);
        }
        this.maximumTaskPosition = l;
    }

    public synchronized void setVisible(boolean bl) {
        if (!this.componentsInitialized && !bl) {
            return;
        }
        if (!this.componentsInitialized && !this.finished) {
            this.initComponents();
        }
        this.thePanel.setVisible(bl);
        if (bl) {
            this.startUpdateThread();
        }
    }

    public boolean isVisible() {
        return !this.componentsInitialized || this.thePanel.isVisible();
    }

    public void started() {
        this.taskStartedTime = System.currentTimeMillis();
        this.running = true;
        this.setVisible(false);
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DasProgressPanel.this.running) {
                    DasProgressPanel.this.logger.fine("hide time=" + (System.currentTimeMillis() - DasProgressPanel.this.taskStartedTime));
                    DasProgressPanel.this.setVisible(true);
                }
            }
        }, "progressPanelUpdateThread").start();
        if (this.isCancelled) {
            return;
        }
        if (this.maximumTaskPosition > 0L) {
            this.setTaskProgress(0L);
        }
    }

    public void cancel() {
        this.isCancelled = true;
        this.finished();
    }

    public boolean isCancelled() {
        this.cancelCheckFailures = 0;
        this.cancelChecked = true;
        return this.isCancelled;
    }

    public Exception getSource() {
        return this.source;
    }

    public Exception getConsumer() {
        return this.consumer;
    }

    public void setShowProgressRate(boolean bl) {
        this.showProgressRate = bl;
    }

    public String toString() {
        if (this.isCancelled) {
            return "cancelled";
        }
        if (this.finished) {
            return "finished";
        }
        if (this.running) {
            return "" + this.currentTaskPosition + " of " + this.maximumTaskPosition;
        }
        return "waiting for start";
    }

    public void setProgressMessage(String string) {
        this.progressMessageString = string;
        this.progressMessageDirty = true;
    }

    class MyPanel
    extends JPanel {
        MyPanel() {
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            graphics2D.setColor(new Color(-587202561, true));
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle == null) {
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            super.paintComponent(graphics);
        }
    }
}

