/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasPNGEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.EventListenerList;

public class BatchMaster {
    List taskList;
    int itask;
    DasCanvas canvas;
    TaskOutputDescriptor tod;
    boolean exit = true;
    public static Timer timer = new Timer();
    private EventListenerList listenerList = null;

    public TaskOutputDescriptor createPngsTaskOutputDescriptor(final String string) {
        return new TaskOutputDescriptor(){

            private String insertRange(String string4, DatumRange datumRange) {
                String string2 = datumRange.toString().replaceAll(":", "-").replaceAll(" ", "_");
                String string3 = string4.replaceAll("BEGIN", datumRange.min().toString().replaceAll(":", "-")).replaceAll("END", datumRange.max().toString().replaceAll(":", "-")).replaceAll("RANGE", string2);
                return string3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completeTask(DatumRange datumRange) {
                Image image = BatchMaster.this.canvas.getImage(BatchMaster.this.canvas.getWidth(), BatchMaster.this.canvas.getHeight());
                String string2 = this.insertRange(string, datumRange);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string2);
                    try {
                        DasPNGEncoder dasPNGEncoder = new DasPNGEncoder();
                        dasPNGEncoder.addText("Creation Time", new Date().toString());
                        dasPNGEncoder.write((BufferedImage)image, fileOutputStream);
                    }
                    finally {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (IOException iOException) {
                    DasExceptionHandler.handle(iOException);
                }
            }
        };
    }

    private void readStartEndSpecFile(File file) throws ParseException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!(string = string.trim()).equals("") && !string.startsWith("#")) {
                DatumRange datumRange = DatumRangeUtil.parseTimeRange(string);
                Datum datum = datumRange.min();
                Datum datum2 = datumRange.max();
                this.addTask(datum, datum2);
            }
            string = bufferedReader.readLine();
        }
    }

    public static BatchMaster createPngs(DasCanvas dasCanvas, File file, String string) throws ParseException, IOException {
        ArrayList arrayList = new ArrayList();
        BatchMaster batchMaster = new BatchMaster(dasCanvas);
        batchMaster.setTaskOutputDescriptor(batchMaster.createPngsTaskOutputDescriptor(string));
        batchMaster.readStartEndSpecFile(file);
        return batchMaster;
    }

    public BatchMaster(DasCanvas dasCanvas) {
        this.canvas = dasCanvas;
        this.taskList = new ArrayList();
        this.itask = 0;
    }

    public void start() {
        this.submitNextTask();
    }

    void addTask(Datum datum, Datum datum2) {
        this.taskList.add(new DataRangeSelectionEvent(this, datum, datum2));
    }

    void addTask(DatumRange datumRange) {
        this.taskList.add(new DataRangeSelectionEvent(this, datumRange.min(), datumRange.max()));
    }

    void setTaskOutputDescriptor(TaskOutputDescriptor taskOutputDescriptor) {
        this.tod = taskOutputDescriptor;
    }

    void setExitAfterCompletion(boolean bl) {
        this.exit = bl;
    }

    void submitNextTask() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (BatchMaster.this.itask >= BatchMaster.this.taskList.size()) {
                    if (BatchMaster.this.exit) {
                        System.exit(0);
                    }
                } else {
                    DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG).info("itask=" + BatchMaster.this.taskList.get(BatchMaster.this.itask));
                    DataRangeSelectionEvent dataRangeSelectionEvent = (DataRangeSelectionEvent)BatchMaster.this.taskList.get(BatchMaster.this.itask++);
                    BatchMaster.this.fireDataRangeSelectionListenerDataRangeSelected(dataRangeSelectionEvent);
                    try {
                        BatchMaster.this.canvas.waitUntilIdle();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    BatchMaster.this.tod.completeTask(dataRangeSelectionEvent.getDatumRange());
                    BatchMaster.this.submitNextTask();
                }
            }
        });
        thread.start();
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataRangeSelectionListener.class, dataRangeSelectionListener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        this.listenerList.remove(DataRangeSelectionListener.class, dataRangeSelectionListener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)objectArray[i + 1]).DataRangeSelected(dataRangeSelectionEvent);
        }
    }

    public static interface TaskOutputDescriptor {
        public void completeTask(DatumRange var1);
    }

    public static class Timer {
        long t0 = System.currentTimeMillis();
        DecimalFormat df = new DecimalFormat("00000.000");

        public void reportTime(String string) {
            Thread thread = Thread.currentThread();
            long l = System.currentTimeMillis() - this.t0;
            System.out.println(this.df.format((double)l / 1000.0) + " " + string + "(" + thread + ")");
        }
    }
}

