/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.CancelledOperationException;
import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.DataSetStreamHandler;
import edu.uiowa.physics.pw.das.client.StandardDataStreamSource;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.DasProgressMonitorInputStream;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class StreamDataSetDescriptor
extends DataSetDescriptor {
    protected StandardDataStreamSource standardDataStreamSource;
    private boolean serverSideReduction = true;
    private PacketDescriptor defaultPacketDescriptor;
    private static final byte[] HEADER = new byte[]{100, 97, 115, 50, 127, 127};

    public Units getXUnits() {
        return this.defaultPacketDescriptor.getXDescriptor().getUnits();
    }

    protected StreamDataSetDescriptor(Map map) {
        this.setProperties(map);
    }

    protected StreamDataSetDescriptor(Map map, boolean bl) {
        this.setProperties(map, bl);
    }

    public StreamDataSetDescriptor(StreamDescriptor streamDescriptor, StandardDataStreamSource standardDataStreamSource) {
        this(streamDescriptor.getProperties(), "true".equals(streamDescriptor.getProperty("legacy")));
        this.standardDataStreamSource = standardDataStreamSource;
    }

    public void setStandardDataStreamSource(StandardDataStreamSource standardDataStreamSource) {
        this.standardDataStreamSource = standardDataStreamSource;
    }

    public StandardDataStreamSource getStandardDataStreamSource() {
        return this.standardDataStreamSource;
    }

    protected void setProperties(Map map, boolean bl) {
        super.setProperties(map);
        if (map.containsKey("form") && map.get("form").equals("x_multi_y") && map.containsKey("items")) {
            this.setDefaultCaching(false);
        }
        if (bl) {
            this.defaultPacketDescriptor = PacketDescriptor.createLegacyPacketDescriptor(map);
        }
    }

    protected void setProperties(Map map) {
        this.setProperties(map, false);
    }

    protected float[] readFloats(InputStream inputStream) throws DasException {
        byte[] byArray = this.readBytes(inputStream);
        float[] fArray = new float[byArray.length / 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.get(fArray);
        return fArray;
    }

    protected double[] readDoubles(InputStream inputStream) throws DasException {
        byte[] byArray = this.readBytes(inputStream);
        double[] dArray = new double[byArray.length / 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = floatBuffer.get();
        }
        return dArray;
    }

    private ByteBuffer getByteBuffer(InputStream inputStream) throws DasException {
        byte[] byArray = this.readBytes(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return byteBuffer;
    }

    protected byte[] readBytes(InputStream inputStream) throws DasException {
        int n;
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        byte[] byArray = new byte[4096];
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        long l = System.currentTimeMillis();
        try {
            n2 = inputStream.read(byArray, n5, 4096 - n5);
            while (n2 != -1) {
                n = n3;
                n4 = n5 += n2;
                if (n5 == 4096) {
                    linkedList.addLast(byArray);
                    byArray = new byte[4096];
                    n5 = 0;
                }
                n3 += n2;
                n2 = inputStream.read(byArray, n5, 4096 - n5);
            }
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException);
        }
        if (n4 >= 0 && n4 < 4096) {
            linkedList.addLast(byArray);
        }
        if (linkedList.size() == 0) {
            throw new DasIOException("Error reading data: no data available");
        }
        n = (linkedList.size() - 1) * 4096 + n4;
        byArray = new byte[n];
        Iterator iterator = linkedList.iterator();
        for (int i = 0; i < linkedList.size() - 1; ++i) {
            System.arraycopy(linkedList.get(i), 0, byArray, i * 4096, 4096);
        }
        System.arraycopy(linkedList.get(linkedList.size() - 1), 0, byArray, (linkedList.size() - 1) * 4096, n4);
        return byArray;
    }

    public String toString() {
        return "dsd " + this.getDataSetID();
    }

    protected DataSet getDataSetImpl(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
        InputStream inputStream;
        if (datum3 != null && !datum3.isFinite()) {
            throw new IllegalArgumentException("resolution is not finite");
        }
        if (this.serverSideReduction) {
            DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).info("getting stream from standard data stream source");
            inputStream = this.standardDataStreamSource.getReducedInputStream(this, datum, datum2, datum3);
        } else {
            inputStream = this.standardDataStreamSource.getInputStream(this, datum, datum2);
        }
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).info("reading stream");
        DataSet dataSet = this.getDataSetFromStream(inputStream, datum, datum2, dasProgressMonitor);
        return dataSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataSet getDataSetFromStream(InputStream inputStream, Datum datum, Datum datum2, DasProgressMonitor dasProgressMonitor) throws DasException {
        if (dasProgressMonitor == null) {
            dasProgressMonitor = DasProgressMonitor.NULL;
        }
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 4096);
        try {
            byte[] byArray = new byte[4];
            int n = pushbackInputStream.read(byArray);
            DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finer("read first four bytes bytesRead=" + n);
            if (n != 4) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).info("no data returned from server");
                throw new DasIOException("No data returned from server");
            }
            if (new String(byArray).equals("[00]")) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finer("got stream header [00]");
                pushbackInputStream.unread(byArray);
                if (dasProgressMonitor.isCancelled()) {
                    pushbackInputStream.close();
                    throw new InterruptedIOException("Operation cancelled");
                }
                final DasProgressMonitorInputStream dasProgressMonitorInputStream = new DasProgressMonitorInputStream(pushbackInputStream, dasProgressMonitor);
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finer("creating Channel");
                ReadableByteChannel readableByteChannel = Channels.newChannel(dasProgressMonitorInputStream);
                DataSetStreamHandler dataSetStreamHandler = new DataSetStreamHandler(this.properties, dasProgressMonitor){

                    public void streamDescriptor(StreamDescriptor streamDescriptor) throws StreamException {
                        super.streamDescriptor(streamDescriptor);
                        if (this.taskSize != -1) {
                            dasProgressMonitorInputStream.setEnableProgressPosition(false);
                        }
                    }
                };
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finer("using StreamTool to read the stream");
                StreamTool.readStream(readableByteChannel, dataSetStreamHandler);
                DataSet dataSet = dataSetStreamHandler.getDataSet();
                return dataSet;
            }
            pushbackInputStream.unread(byArray);
            if (dasProgressMonitor.isCancelled()) {
                pushbackInputStream.close();
                throw new InterruptedIOException("Operation cancelled");
            }
            dasProgressMonitor.started();
            DasProgressMonitorInputStream dasProgressMonitorInputStream = new DasProgressMonitorInputStream(pushbackInputStream, dasProgressMonitor);
            if (this.getProperty("form").equals("x_tagged_y_scan")) {
                DataSet dataSet = this.getLegacyTableDataSet(dasProgressMonitorInputStream, datum);
                return dataSet;
            }
            if (this.getProperty("form").equals("x_multi_y")) {
                DataSet dataSet = this.getLegacyVectorDataSet(dasProgressMonitorInputStream, datum);
                return dataSet;
            }
            throw new IllegalStateException("Unrecognized data set type: " + this.getProperty("form"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException);
        }
        catch (StreamException streamException) {
            if (!(streamException.getCause() instanceof InterruptedIOException)) throw streamException;
            CancelledOperationException cancelledOperationException = new CancelledOperationException();
            cancelledOperationException.initCause(streamException);
            throw cancelledOperationException;
        }
        finally {
            try {
                pushbackInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String getPacketID(byte[] byArray) throws DasException {
        if (byArray[0] == 91 && byArray[3] == 93 || byArray[0] == 58 && byArray[3] == 58) {
            return new String(new char[]{(char)byArray[1], (char)byArray[2]});
        }
        throw new DasException("Invalid stream, expecting 4 byte header, encountered '" + new String(byArray) + "'");
    }

    private DataSet getLegacyVectorDataSet(InputStream inputStream, Datum datum) throws DasException {
        try {
            Object object;
            String[] stringArray;
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 50);
            PacketDescriptor packetDescriptor = this.getPacketDescriptor(pushbackInputStream);
            VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(datum.getUnits(), Units.dimensionless);
            for (Object e : packetDescriptor.getYDescriptors()) {
                if (e instanceof StreamMultiYDescriptor) {
                    stringArray = (String[])e;
                    String string = stringArray.getName();
                    if (string != null && !string.equals("")) {
                        vectorDataSetBuilder.addPlane(string, stringArray.getUnits());
                        continue;
                    }
                    if (!"".equals(string)) continue;
                    vectorDataSetBuilder.setYUnits(stringArray.getUnits());
                    continue;
                }
                throw new DasIOException("Invalid Stream Header: Non-Y-descriptor encountered");
            }
            StreamMultiYDescriptor[] streamMultiYDescriptorArray = packetDescriptor.getYDescriptors().toArray(new StreamMultiYDescriptor[0]);
            int n = streamMultiYDescriptorArray.length - 1;
            stringArray = new String[n];
            int n2 = packetDescriptor.getXDescriptor().getSizeBytes() + streamMultiYDescriptorArray[0].getSizeBytes();
            for (int i = 0; i < n; ++i) {
                stringArray[i] = streamMultiYDescriptorArray[i + 1].getName();
                n2 += streamMultiYDescriptorArray[i + 1].getSizeBytes();
            }
            ByteBuffer byteBuffer = this.getByteBuffer(pushbackInputStream);
            double d = datum.doubleValue(datum.getUnits());
            Units units = datum.getUnits().getOffsetUnits();
            UnitsConverter unitsConverter = packetDescriptor.getXDescriptor().getUnits().getConverter(units);
            while (byteBuffer.remaining() > n2) {
                object = packetDescriptor.getXDescriptor().read(byteBuffer);
                double d2 = d + ((DatumVector)object).doubleValue(0, units);
                object = streamMultiYDescriptorArray[0].read(byteBuffer);
                double d3 = ((DatumVector)object).doubleValue(0, streamMultiYDescriptorArray[0].getUnits());
                vectorDataSetBuilder.insertY(d2, d3);
                for (int i = 0; i < n; ++i) {
                    object = streamMultiYDescriptorArray[i + 1].read(byteBuffer);
                    d3 = ((DatumVector)object).doubleValue(0, streamMultiYDescriptorArray[i + 1].getUnits());
                    vectorDataSetBuilder.insertY(d2, d3, streamMultiYDescriptorArray[i + 1].getName());
                }
            }
            if (this.properties.containsKey("x_sample_width")) {
                this.properties.put("xTagWidth", Datum.create((Double)this.properties.get("x_sample_width"), Units.seconds));
            }
            vectorDataSetBuilder.addProperties(this.properties);
            object = vectorDataSetBuilder.toVectorDataSet();
            return object;
        }
        catch (DasException dasException) {
            dasException.printStackTrace();
            throw dasException;
        }
    }

    private DataSet getLegacyTableDataSet(InputStream inputStream, Datum datum) throws DasException {
        Object object;
        String[] stringArray;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 50);
        PacketDescriptor packetDescriptor = this.getPacketDescriptor(pushbackInputStream);
        TableDataSetBuilder tableDataSetBuilder = new TableDataSetBuilder(datum.getUnits(), Units.dimensionless, Units.dimensionless);
        Units units = Units.dimensionless;
        Units units2 = Units.dimensionless;
        for (Object e : packetDescriptor.getYDescriptors()) {
            if (e instanceof StreamYScanDescriptor) {
                stringArray = (String[])e;
                String string = stringArray.getName();
                if (string == null || string.equals("")) continue;
                tableDataSetBuilder.addPlane(string, stringArray.getZUnits());
                continue;
            }
            throw new DasIOException("Invalid Stream Header: Non-yScan descriptor encountered");
        }
        StreamYScanDescriptor[] streamYScanDescriptorArray = packetDescriptor.getYDescriptors().toArray(new StreamYScanDescriptor[0]);
        int n = streamYScanDescriptorArray.length;
        stringArray = new String[n];
        int n2 = packetDescriptor.getXDescriptor().getSizeBytes();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = streamYScanDescriptorArray[i].getName();
            n2 += streamYScanDescriptorArray[i].getSizeBytes();
        }
        ByteBuffer byteBuffer = this.getByteBuffer(pushbackInputStream);
        double d = datum.doubleValue(datum.getUnits());
        Units units3 = datum.getUnits().getOffsetUnits();
        UnitsConverter unitsConverter = packetDescriptor.getXDescriptor().getUnits().getConverter(units3);
        double[] dArray = streamYScanDescriptorArray[0].getYTags();
        DatumVector datumVector = DatumVector.newDatumVector(dArray, units);
        while (byteBuffer.remaining() > n2) {
            object = packetDescriptor.getXDescriptor().read(byteBuffer);
            Datum datum2 = datum.add(((DatumVector)object).get(0));
            DatumVector[] datumVectorArray = new DatumVector[n];
            for (int i = 0; i < n; ++i) {
                datumVectorArray[i] = streamYScanDescriptorArray[i].read(byteBuffer);
            }
            tableDataSetBuilder.insertYScan(datum2, datumVector, datumVectorArray, stringArray);
        }
        if (this.properties.containsKey("x_sample_width")) {
            this.properties.put("xTagWidth", Datum.create((Double)this.properties.get("x_sample_width"), Units.seconds));
        }
        tableDataSetBuilder.addProperties(this.properties);
        object = tableDataSetBuilder.toTableDataSet();
        return object;
    }

    private PacketDescriptor getPacketDescriptor(PushbackInputStream pushbackInputStream) throws DasIOException {
        try {
            byte[] byArray = new byte[HEADER.length];
            int n = 0;
            int n2 = 0;
            do {
                if ((n = pushbackInputStream.read(byArray, n2, HEADER.length - n2)) == -1) continue;
                n2 += n;
            } while (n2 < HEADER.length && n != -1);
            if (Arrays.equals(byArray, HEADER)) {
                byte[] byArray2 = StreamTool.advanceTo(pushbackInputStream, "\u007f\u007f".getBytes());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(byteArrayInputStream);
                Element element = document.getDocumentElement();
                PacketDescriptor packetDescriptor = new PacketDescriptor(element);
                return packetDescriptor;
            }
            pushbackInputStream.unread(byArray, 0, n2);
            return this.defaultPacketDescriptor;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException.getMessage());
        }
        catch (StreamTool.DelimeterNotFoundException delimeterNotFoundException) {
            DasIOException dasIOException = new DasIOException(delimeterNotFoundException.getMessage());
            dasIOException.initCause(dasIOException);
            throw dasIOException;
        }
        catch (SAXException sAXException) {
            DasIOException dasIOException = new DasIOException(sAXException.getMessage());
            dasIOException.initCause(sAXException);
            throw dasIOException;
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException);
        }
    }

    public boolean isRestrictedAccess() {
        boolean bl = this.getProperty("groupAccess") != null ? !"".equals(this.getProperty("groupAccess")) : false;
        return bl;
    }

    public void setServerSideReduction(boolean bl) {
        this.serverSideReduction = bl;
    }

    public boolean isServerSideReduction() {
        return this.serverSideReduction;
    }

    public PacketDescriptor getDefaultPacketDescriptor() {
        return this.defaultPacketDescriptor;
    }
}

