/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.system.DasLogger;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamMeter {
    long totalBytesRead = 0L;
    long millisElapsed = 0L;
    double speedLimit = 0.0;
    long meterCount;
    long startTime = -1L;

    public InputStream meterInputStream(InputStream inputStream) {
        ++this.meterCount;
        if (this.meterCount == 1L) {
            this.startTime = System.currentTimeMillis();
            this.totalBytesRead = 0L;
            this.millisElapsed = 0L;
        }
        return new MeteredInputStream(inputStream, this);
    }

    private void governSpeed(MeteredInputStream meteredInputStream) {
        if (this.speedLimit > 0.0 && this.calcTransmitSpeed() > this.speedLimit) {
            long l = (long)((double)this.totalBytesRead / (this.speedLimit / 1000.0));
            long l2 = Math.min(1000L, l - this.calcMillisElapsed());
            DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG).fine("limiting speed by waiting " + l2 + " ms");
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void addBytes(long l, MeteredInputStream meteredInputStream) {
        this.totalBytesRead += l;
    }

    private void closing(MeteredInputStream meteredInputStream) {
        --this.meterCount;
        if (this.meterCount == 0L) {
            this.millisElapsed += System.currentTimeMillis() - this.startTime;
            this.startTime = -1L;
        }
    }

    private void exception(MeteredInputStream meteredInputStream) {
        --this.meterCount;
        if (this.meterCount == 0L) {
            this.millisElapsed += System.currentTimeMillis() - this.startTime;
            this.startTime = -1L;
        }
    }

    private long calcMillisElapsed() {
        long l = this.millisElapsed;
        if (this.startTime != -1L) {
            l += System.currentTimeMillis() - this.startTime;
        }
        return l;
    }

    private double calcTransmitSpeed() {
        long l = this.calcMillisElapsed();
        if (l == 0L) {
            return Units.bytesPerSecond.getFillDouble();
        }
        return 1000L * this.totalBytesRead / l;
    }

    public Datum getTransmitSpeed() {
        return Units.bytesPerSecond.createDatum(this.calcTransmitSpeed(), 10.0);
    }

    public long getBytesTransmitted() {
        return this.totalBytesRead;
    }

    public Datum getSpeedLimit() {
        return Units.bytesPerSecond.createDatum(this.speedLimit);
    }

    public void setSpeedLimit(Datum datum) {
        this.speedLimit = datum.doubleValue(Units.bytesPerSecond);
    }

    private class MeteredInputStream
    extends InputStream {
        InputStream in;
        InputStreamMeter meter;

        private MeteredInputStream(InputStream inputStream, InputStreamMeter inputStreamMeter2) {
            this.meter = inputStreamMeter2;
            this.in = inputStream;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                int n3 = this.in.read(byArray, n, n2);
                this.meter.addBytes(n3, this);
                this.meter.governSpeed(this);
                return n3;
            }
            catch (IOException iOException) {
                this.meter.exception(this);
                throw iOException;
            }
        }

        public int read() throws IOException {
            try {
                int n = this.in.read();
                this.meter.addBytes(1L, this);
                this.meter.governSpeed(this);
                return n;
            }
            catch (IOException iOException) {
                this.meter.exception(this);
                throw iOException;
            }
        }

        public void close() throws IOException {
            this.meter.closing(this);
            this.in.close();
        }
    }
}

