/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamComment;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamHandler;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class DataSetStreamHandler
implements StreamHandler {
    StreamHandlerDelegate delegate;
    StreamDescriptor sd;
    Map extraProperties;
    DasProgressMonitor monitor;
    int totalPacketCount = -1;
    int taskSize = -1;
    int packetCount = 0;

    public DataSetStreamHandler(Map map, DasProgressMonitor dasProgressMonitor) {
        this.extraProperties = new HashMap(map);
        this.monitor = dasProgressMonitor == null ? DasProgressMonitor.NULL : dasProgressMonitor;
    }

    public void streamDescriptor(StreamDescriptor streamDescriptor) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got stream descriptor");
        this.sd = streamDescriptor;
        Object object = streamDescriptor.getProperty("taskSize");
        if (object != null) {
            this.taskSize = (Integer)object;
            this.monitor.setTaskSize(this.taskSize);
        } else {
            object = streamDescriptor.getProperty("packetCount");
            if (object != null) {
                this.totalPacketCount = (Integer)object;
                this.monitor.setTaskSize(this.totalPacketCount);
            }
        }
        object = streamDescriptor.getProperty("pid");
        if (object != null) {
            DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).fine("stream pid=" + object);
        }
    }

    public void packetDescriptor(PacketDescriptor packetDescriptor) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got packet descriptor");
        if (this.delegate == null) {
            SkeletonDescriptor skeletonDescriptor = packetDescriptor.getYDescriptor(0);
            if (skeletonDescriptor instanceof StreamMultiYDescriptor) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).fine("using VectorDS delegate");
                this.delegate = new VectorDataSetStreamHandler(packetDescriptor);
            } else if (skeletonDescriptor instanceof StreamYScanDescriptor) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).fine("using TableDS delegate");
                this.delegate = new TableDataSetStreamHandler(packetDescriptor);
            }
        } else {
            this.delegate.packetDescriptor(packetDescriptor);
        }
    }

    public void packet(PacketDescriptor packetDescriptor, Datum datum, DatumVector[] datumVectorArray) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got packet");
        this.ensureNotNullDelegate();
        this.delegate.packet(packetDescriptor, datum, datumVectorArray);
        ++this.packetCount;
        if (this.totalPacketCount != -1) {
            this.monitor.setTaskProgress(this.packetCount);
        }
    }

    public void streamClosed(StreamDescriptor streamDescriptor) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got streamClosed");
        if (this.delegate != null) {
            this.delegate.streamClosed(streamDescriptor);
        }
    }

    public void streamException(StreamException streamException) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got stream exception");
    }

    public void streamComment(StreamComment streamComment) throws StreamException {
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).finest("got stream comment: " + streamComment);
        if (streamComment.getType().equals(streamComment.TYPE_TASK_PROGRESS) && this.taskSize != -1) {
            if (!this.monitor.isCancelled()) {
                this.monitor.setTaskProgress(Long.parseLong(streamComment.getValue()));
            }
        } else if (streamComment.getType().matches(streamComment.TYPE_LOG)) {
            String string = streamComment.getType().substring(4);
            Level level = Level.parse(string.toUpperCase());
            DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).log(level, streamComment.getValue());
            this.monitor.setProgressMessage(streamComment.getValue());
        }
    }

    public DataSet getDataSet() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getDataSet();
    }

    private void ensureNotNullDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Null delegate");
        }
    }

    private static double getXWithBase(Datum datum, Datum datum2) {
        if (datum == null) {
            return datum2.doubleValue(datum2.getUnits());
        }
        return datum.doubleValue(datum.getUnits()) + datum2.doubleValue(datum.getUnits().getOffsetUnits());
    }

    private class TableDataSetStreamHandler
    implements StreamHandlerDelegate {
        private TableDataSetBuilder builder;

        private TableDataSetStreamHandler(PacketDescriptor packetDescriptor) throws StreamException {
            StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)packetDescriptor.getYDescriptor(0);
            Datum datum = packetDescriptor.getXDescriptor().getBase();
            Units units = datum != null ? datum.getUnits() : packetDescriptor.getXDescriptor().getUnits();
            Units units2 = streamYScanDescriptor.getYUnits();
            Units units3 = streamYScanDescriptor.getZUnits();
            this.builder = new TableDataSetBuilder(units, units2, units3);
            this.packetDescriptor(packetDescriptor);
        }

        public void packet(PacketDescriptor packetDescriptor, Datum datum, DatumVector[] datumVectorArray) throws StreamException {
            StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)packetDescriptor.getYDescriptor(0);
            Datum datum2 = packetDescriptor.getXDescriptor().getBase();
            Datum datum3 = datum2 == null ? datum : datum2.add(datum);
            DatumVector datumVector = DatumVector.newDatumVector(streamYScanDescriptor.getYTags(), streamYScanDescriptor.getYUnits());
            String[] stringArray = new String[packetDescriptor.getYCount()];
            for (int i = 0; i < packetDescriptor.getYCount(); ++i) {
                stringArray[i] = ((StreamYScanDescriptor)packetDescriptor.getYDescriptor(i)).getName();
            }
            this.builder.insertYScan(datum3, datumVector, datumVectorArray, stringArray);
        }

        public void packetDescriptor(PacketDescriptor packetDescriptor) throws StreamException {
            StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)packetDescriptor.getYDescriptor(0);
            for (int i = 1; i < packetDescriptor.getYCount(); ++i) {
                streamYScanDescriptor = (StreamYScanDescriptor)packetDescriptor.getYDescriptor(i);
                this.builder.addPlane(streamYScanDescriptor.getName(), streamYScanDescriptor.getZUnits());
            }
            Map map = packetDescriptor.getProperties();
            for (String string : map.keySet()) {
                this.builder.setProperty(string, map.get(string));
            }
        }

        public void streamClosed(StreamDescriptor streamDescriptor) throws StreamException {
        }

        public void streamDescriptor(StreamDescriptor streamDescriptor) throws StreamException {
        }

        public void streamException(StreamException streamException) throws StreamException {
        }

        public void streamComment(StreamComment streamComment) throws StreamException {
        }

        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            return this.builder.toTableDataSet();
        }
    }

    private class VectorDataSetStreamHandler
    implements StreamHandlerDelegate {
        private VectorDataSetBuilder builder;
        private double[] doubles = new double[1];

        private VectorDataSetStreamHandler(PacketDescriptor packetDescriptor) throws StreamException {
            StreamMultiYDescriptor streamMultiYDescriptor = (StreamMultiYDescriptor)packetDescriptor.getYDescriptor(0);
            Datum datum = packetDescriptor.getXDescriptor().getBase();
            Units units = datum == null ? packetDescriptor.getXDescriptor().getUnits() : datum.getUnits();
            Units units2 = streamMultiYDescriptor.getUnits();
            this.builder = new VectorDataSetBuilder(units, units2);
            this.packetDescriptor(packetDescriptor);
        }

        public void packet(PacketDescriptor packetDescriptor, Datum datum, DatumVector[] datumVectorArray) throws StreamException {
            Datum datum2 = packetDescriptor.getXDescriptor().getBase();
            double d = DataSetStreamHandler.getXWithBase(datum2, datum);
            for (int i = 0; i < packetDescriptor.getYCount(); ++i) {
                if (packetDescriptor.getYDescriptor(i) instanceof StreamMultiYDescriptor) {
                    StreamMultiYDescriptor streamMultiYDescriptor = (StreamMultiYDescriptor)packetDescriptor.getYDescriptor(i);
                    double d2 = datumVectorArray[i].doubleValue(0, streamMultiYDescriptor.getUnits());
                    if (i != 0) {
                        this.builder.insertY(d, d2, streamMultiYDescriptor.getName());
                        continue;
                    }
                    this.builder.insertY(d, d2);
                    continue;
                }
                throw new StreamException("Mixed data sets are not currently supported");
            }
        }

        public void packetDescriptor(PacketDescriptor packetDescriptor) throws StreamException {
            DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).fine("got packet descriptor: " + packetDescriptor);
            for (int i = 1; i < packetDescriptor.getYCount(); ++i) {
                StreamMultiYDescriptor streamMultiYDescriptor = (StreamMultiYDescriptor)packetDescriptor.getYDescriptor(i);
                this.builder.addPlane(streamMultiYDescriptor.getName(), streamMultiYDescriptor.getUnits());
            }
        }

        public void streamClosed(StreamDescriptor streamDescriptor) throws StreamException {
        }

        public void streamDescriptor(StreamDescriptor streamDescriptor) throws StreamException {
        }

        public void streamException(StreamException streamException) throws StreamException {
        }

        public void streamComment(StreamComment streamComment) throws StreamException {
        }

        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            return this.builder.toVectorDataSet();
        }
    }

    private static interface StreamHandlerDelegate
    extends StreamHandler {
        public DataSet getDataSet();
    }
}

