/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.Authenticator;
import edu.uiowa.physics.pw.das.client.DasServerException;
import edu.uiowa.physics.pw.das.client.DasServerNotFoundException;
import edu.uiowa.physics.pw.das.client.DataSetDescriptorNotAvailableException;
import edu.uiowa.physics.pw.das.client.Key;
import edu.uiowa.physics.pw.das.client.StandardDataStreamSource;
import edu.uiowa.physics.pw.das.client.WebStandardDataStreamSource;
import edu.uiowa.physics.pw.das.stream.DasStreamFormatException;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.Crypt;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.URLBuddy;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasServer {
    private String host;
    private String path;
    private int port;
    private HashMap keys;
    private Key key;
    private static Logger logger = DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG);
    private static HashMap instanceHashMap = new HashMap();
    public static DasServer plasmaWaveGroup;
    public static DasServer sarahandjeremy;

    private DasServer(String string, String string2) {
        String[] stringArray = string.split(":");
        if (stringArray.length > 1) {
            this.port = Integer.parseInt(stringArray[1]);
            string = stringArray[0];
        } else {
            this.port = -1;
        }
        this.host = string;
        this.path = string2;
        this.keys = new HashMap();
    }

    public String getURL() {
        if (this.port == -1) {
            return "http://" + this.host + this.path;
        }
        return "http://" + this.host + ":" + this.port + this.path;
    }

    public static DasServer create(URL uRL) {
        String string;
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        if (n != -1) {
            string2 = string2 + ":" + n;
        }
        if (instanceHashMap.containsKey(string = "http://" + string2 + uRL.getPath())) {
            logger.info("Using existing DasServer for " + uRL);
            return (DasServer)instanceHashMap.get(string);
        }
        String string3 = uRL.getPath();
        logger.info("Creating DasServer for " + uRL);
        DasServer dasServer = new DasServer(string2, string3);
        instanceHashMap.put(string, dasServer);
        return dasServer;
    }

    public String getName() {
        String string = "server=id";
        try {
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string);
            logger.info("connecting to " + uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            String string2 = uRLConnection.getContentType();
            InputStream inputStream = uRLConnection.getInputStream();
            String string3 = new String(this.read(inputStream));
            logger.info("response=" + string3);
            return string3;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public ImageIcon getLogo() {
        String string = "server=logo";
        try {
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string);
            logger.info("connecting to " + uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            String string2 = uRLConnection.getContentType();
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = this.read(inputStream);
            logger.info("response=" + byArray.length + " bytes");
            return new ImageIcon(byArray);
        }
        catch (IOException iOException) {
            return new ImageIcon();
        }
    }

    public TreeModel getDataSetList() throws DasException {
        String string = "server=list";
        try {
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string);
            logger.info("connecting to " + uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            String string2 = uRLConnection.getContentType();
            InputStream inputStream = uRLConnection.getInputStream();
            TreeModel treeModel = this.createModel(inputStream);
            logger.info("response->" + treeModel);
            return treeModel;
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
    }

    private TreeModel createModel(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.getURL(), true);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode, true);
        String string = bufferedReader.readLine();
        while (string != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            block1: while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
                    String string3 = defaultMutableTreeNode2.getChildAt(i).toString();
                    if (!string3.equals(string2)) continue;
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                    continue block1;
                }
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string2, stringTokenizer.hasMoreElements() ? true : string.endsWith("/"));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
            }
            string = bufferedReader.readLine();
        }
        return defaultTreeModel;
    }

    public StandardDataStreamSource getStandardDataStreamSource(URL uRL) {
        return new WebStandardDataStreamSource(this, uRL);
    }

    public StreamDescriptor getStreamDescriptor(URL uRL) throws DasException {
        try {
            String string = uRL.getQuery().split("&")[0];
            URL uRL2 = new URL("http", this.host, this.port, this.path + "?server=dsdf&dataset=" + string);
            logger.info("connecting to " + uRL2);
            URLConnection uRLConnection = uRL2.openConnection();
            uRLConnection.connect();
            String string2 = uRLConnection.getContentType();
            String[] stringArray = string2.split(";");
            string2 = stringArray[0];
            if (string2.equalsIgnoreCase("text/plain")) {
                PushbackReader pushbackReader = new PushbackReader(new InputStreamReader(uRLConnection.getInputStream()), 4);
                char[] cArray = new char[4];
                pushbackReader.read(cArray);
                if (new String(cArray).equals("[00]")) {
                    logger.info("response is a das2Stream");
                    pushbackReader.skip(6L);
                    Document document = StreamDescriptor.parseHeader(pushbackReader);
                    Element element = document.getDocumentElement();
                    if (element.getTagName().equals("stream")) {
                        return new StreamDescriptor(element);
                    }
                    if (element.getTagName().equals("exception")) {
                        logger.info("response is an exception");
                        String string3 = element.getAttribute("type");
                        StreamException streamException = new StreamException("stream exception: " + string3);
                        DasException dasException = new DasException("stream exception: " + string3);
                        dasException.initCause(streamException);
                        throw dasException;
                    }
                    if (element.getTagName().equals("")) {
                        throw new DasStreamFormatException();
                    }
                    throw new DasStreamFormatException();
                }
                logger.info("response is a legacy descriptor");
                pushbackReader.unread(cArray);
                BufferedReader bufferedReader = new BufferedReader(pushbackReader);
                StreamDescriptor streamDescriptor = StreamDescriptor.createLegacyDescriptor(bufferedReader);
                return streamDescriptor;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                stringBuffer.append(string4).append('\n');
                string4 = bufferedReader.readLine();
            }
            throw new IOException(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new DataSetDescriptorNotAvailableException("malformed URL");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DasServerNotFoundException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.toString());
        }
    }

    public Key authenticate(String string, String string2) {
        try {
            Key key = null;
            String string3 = "server=authenticator";
            string3 = string3 + "&user=" + URLBuddy.encodeUTF8(string);
            string3 = string3 + "&passwd=" + URLBuddy.encodeUTF8(string2);
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string3);
            logger.info("connecting to " + uRL);
            InputStream inputStream = uRL.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            String string4 = this.readServerResponse(bufferedInputStream);
            String string5 = "error";
            String string6 = "key";
            if (string4.substring(0, string6.length() + 2).equals("<" + string6 + ">")) {
                int n = string4.indexOf("</" + string6 + ">");
                String string7 = string4.substring(string6.length() + 2, n);
                key = new Key(string7);
            } else {
                key = null;
            }
            return key;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List groups(Key key) {
        try {
            String string = "server=groups";
            string = string + "&key=" + URLBuddy.encodeUTF8(key.toString());
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string);
            logger.info("connecting to " + uRL);
            InputStream inputStream = uRL.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            String string2 = this.readServerResponse(bufferedInputStream);
            String[] stringArray = string2.split(",");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if ("".equals(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void changePassword(String string, String string2, String string3) throws DasServerException {
        try {
            String string4 = "server=changePassword";
            string4 = string4 + "&user=" + URLBuddy.encodeUTF8(string);
            String string5 = Crypt.crypt(string2);
            string4 = string4 + "&passwd=" + URLBuddy.encodeUTF8(string5);
            String string6 = Crypt.crypt(string3);
            string4 = string4 + "&newPasswd=" + URLBuddy.encodeUTF8(string6);
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string4);
            logger.info("connecting to " + uRL);
            InputStream inputStream = uRL.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            String string7 = this.readServerResponse(bufferedInputStream);
            String string8 = "error";
            String string9 = "key";
            if (string7.substring(0, string8.length() + 2).equals("<" + string8 + ">")) {
                int n = string7.indexOf("</" + string8 + ">");
                String string10 = string7.substring(string8.length() + 2, n);
                if (string10.equals("<badAuthentication/>")) {
                    throw new DasServerException("Bad User/Pass");
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (IOException iOException) {
            throw new DasServerException("Failed Connection");
        }
    }

    public String readServerResponse(BufferedInputStream bufferedInputStream) {
        String string;
        bufferedInputStream.mark(Integer.MAX_VALUE);
        byte[] byArray = new byte[4096];
        int n = -1;
        int n2 = 0;
        try {
            int n3 = bufferedInputStream.read(byArray, n2, 4096 - n2);
            String string2 = "das2Response";
            if (n3 < string2.length() + 2) {
                n2 += n3;
                n3 = bufferedInputStream.read(byArray, n2, 4096 - n2);
            }
            if (new String(byArray, 0, 14, "UTF-8").equals("<" + string2 + ">")) {
                while (new String(byArray, 0, n2, "UTF-8").indexOf("</" + string2 + ">") == -1 && n2 < 4096) {
                    n3 = bufferedInputStream.read(byArray, n2 += n3, 4096 - n2);
                }
                int n4 = new String(byArray, 0, n2, "UTF-8").indexOf("</" + string2 + ">");
                string = new String(byArray, 14, n4 - 14);
                DasDie.println("das2Response=" + string);
                bufferedInputStream.reset();
                bufferedInputStream.skip(string.length() + 2 * string2.length() + 5);
            } else {
                bufferedInputStream.reset();
                string = "";
            }
        }
        catch (IOException iOException) {
            string = "";
        }
        logger.info("response=" + string);
        return string;
    }

    private byte[] read(InputStream inputStream) throws IOException {
        int n;
        int n2;
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n3 = 0;
        int n4 = 0;
        InputStream inputStream2 = inputStream;
        long l = System.currentTimeMillis();
        byte[] byArray = new byte[4096];
        int n5 = -1;
        int n6 = 0;
        n3 = inputStream2.read(byArray, n6, 4096 - n6);
        while (n3 != -1) {
            n2 = n4;
            n5 = n6 += n3;
            if (n6 == 4096) {
                linkedList.addLast(byArray);
                byArray = new byte[4096];
                n6 = 0;
            }
            n4 += n3;
            n3 = inputStream2.read(byArray, n6, 4096 - n6);
        }
        if (n5 < 4096) {
            linkedList.addLast(byArray);
        }
        if (linkedList.size() == 0) {
            return new byte[0];
        }
        n2 = (linkedList.size() - 1) * 4096 + n5;
        byArray = new byte[n2];
        Iterator iterator = linkedList.iterator();
        for (n = 0; n < linkedList.size() - 1; ++n) {
            System.arraycopy(iterator.next(), 0, byArray, n * 4096, 4096);
        }
        System.arraycopy(iterator.next(), 0, byArray, n * 4096, n5);
        return byArray;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public URL getURL(String string) throws MalformedURLException {
        return new URL("http", this.host, this.port, this.path + "?" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key getKey(String string) {
        DasServer dasServer = this;
        synchronized (dasServer) {
            Authenticator authenticator;
            Key key;
            if (this.keys.get(string) == null && (key = (authenticator = new Authenticator(this, string)).authenticate()) != null) {
                this.keys.put(string, key);
            }
        }
        return (Key)this.keys.get(string);
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public String toString() {
        return this.getURL();
    }

    static {
        try {
            plasmaWaveGroup = DasServer.create(new URL("http://www-pw.physics.uiowa.edu/das/das2Server"));
            sarahandjeremy = DasServer.create(new URL("http://www.sarahandjeremy.net/das/dasServer.cgi"));
        }
        catch (MalformedURLException malformedURLException) {
            DasExceptionHandler.handle(malformedURLException);
        }
    }
}

