/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AccessLevelBeanInfo
extends SimpleBeanInfo {
    private Property[] properties;
    private Class beanClass;
    private static AccessLevel accessLevel;
    private static Object lockObject;

    public static AccessLevel getAccessLevel() {
        return accessLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAccessLevel(AccessLevel accessLevel) {
        Object object = lockObject;
        synchronized (object) {
            AccessLevelBeanInfo.accessLevel = accessLevel;
        }
    }

    public static Object getLock() {
        return lockObject;
    }

    protected AccessLevelBeanInfo(Property[] propertyArray, Class clazz) {
        this.properties = propertyArray;
        this.beanClass = clazz;
    }

    public PropertyDescriptor[] getPropertyDescriptors(PersistenceLevel persistenceLevel) {
        Object object = lockObject;
        synchronized (object) {
            try {
                ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
                boolean bl = false;
                for (int i = 0; i < this.properties.length; ++i) {
                    if (persistenceLevel.compareTo(this.properties[i].getPersistenceLevel()) > 0) continue;
                    arrayList.add(this.properties[i].getPropertyDescriptor(this.beanClass));
                }
                BeanInfo[] beanInfoArray = this.getAdditionalBeanInfo();
                if (beanInfoArray != null) {
                    for (int i = 0; i < beanInfoArray.length; ++i) {
                        arrayList.addAll(Arrays.asList(beanInfoArray[i].getPropertyDescriptors()));
                    }
                }
                return arrayList.toArray(new PropertyDescriptor[arrayList.size()]);
            }
            catch (IntrospectionException introspectionException) {
                throw new IllegalStateException(introspectionException.getMessage());
            }
        }
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        Object object = lockObject;
        synchronized (object) {
            try {
                int n = 0;
                for (int i = 0; i < this.properties.length; ++i) {
                    if (accessLevel.compareTo(this.properties[i].getLevel()) > 0) continue;
                    ++n;
                }
                PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[n];
                int n2 = 0;
                for (int i = 0; i < this.properties.length; ++i) {
                    if (accessLevel.compareTo(this.properties[i].getLevel()) > 0) continue;
                    propertyDescriptorArray[n2] = this.properties[i].getPropertyDescriptor(this.beanClass);
                    ++n2;
                }
                return propertyDescriptorArray;
            }
            catch (IntrospectionException introspectionException) {
                throw new IllegalStateException(introspectionException.getMessage());
            }
        }
    }

    public Property getProperty(PropertyDescriptor propertyDescriptor) {
        String string = propertyDescriptor.getName();
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.properties[i].name != string) continue;
            return this.properties[i];
        }
        BeanInfo[] beanInfoArray = this.getAdditionalBeanInfo();
        if (beanInfoArray != null && beanInfoArray.length > 0) {
            for (int i = 0; i < beanInfoArray.length; ++i) {
                Property property;
                BeanInfo beanInfo = beanInfoArray[i];
                if (!(beanInfo instanceof AccessLevelBeanInfo) || (property = ((AccessLevelBeanInfo)beanInfo).getProperty(propertyDescriptor)) == null) continue;
                return property;
            }
        }
        return null;
    }

    public BeanDescriptor getBeanDescriptor() {
        return new BeanDescriptor(this.beanClass);
    }

    static {
        lockObject = new Object();
        String string = System.getProperty("edu.uiowa.physics.das.beans.AccessLevelBeanInfo.AccessLevel");
        accessLevel = string == null ? AccessLevel.ALL : (string.equals("ALL") ? AccessLevel.ALL : (string.equals("DASML") ? AccessLevel.DASML : (string.equals("END_USER") ? AccessLevel.END_USER : AccessLevel.ALL)));
    }

    protected static class Property {
        private final String name;
        private final AccessLevel level;
        private final PersistenceLevel persistenceLevel;
        private final String getter;
        private final String setter;
        private final String igetter;
        private final String isetter;
        private final Class editor;
        private final boolean indexed;

        public Property(String string, AccessLevel accessLevel, PersistenceLevel persistenceLevel, String string2, String string3, Class clazz) {
            this.name = string;
            this.level = accessLevel;
            this.persistenceLevel = persistenceLevel;
            this.getter = string2;
            this.setter = string3;
            this.igetter = null;
            this.isetter = null;
            this.editor = clazz;
            this.indexed = false;
        }

        public Property(String string, AccessLevel accessLevel, String string2, String string3, Class clazz) {
            this(string, accessLevel, PersistenceLevel.TRANSIENT, string2, string3, clazz);
        }

        public Property(String string, AccessLevel accessLevel, PersistenceLevel persistenceLevel, String string2, String string3, String string4, String string5, Class clazz) {
            this.name = string;
            this.level = accessLevel;
            this.persistenceLevel = persistenceLevel;
            this.getter = string2;
            this.setter = string3;
            this.igetter = string4;
            this.isetter = string5;
            this.editor = clazz;
            this.indexed = true;
        }

        public Property(String string, AccessLevel accessLevel, String string2, String string3, String string4, String string5, Class clazz) {
            this(string, accessLevel, PersistenceLevel.TRANSIENT, string2, string3, string4, string5, clazz);
        }

        public AccessLevel getLevel() {
            return this.level;
        }

        public PropertyDescriptor getPropertyDescriptor(Class clazz) throws IntrospectionException {
            PropertyDescriptor propertyDescriptor = this.indexed ? new IndexedPropertyDescriptor(this.name, clazz, this.getter, this.setter, this.igetter, this.isetter) : new PropertyDescriptor(this.name, clazz, this.getter, this.setter);
            if (this.editor != null) {
                propertyDescriptor.setPropertyEditorClass(this.editor);
            }
            return propertyDescriptor;
        }

        public PersistenceLevel getPersistenceLevel() {
            return this.persistenceLevel;
        }
    }

    public static class PersistenceLevel
    implements Comparable {
        public static final PersistenceLevel NONE = new PersistenceLevel("NONE", 0);
        public static final PersistenceLevel TRANSIENT = new PersistenceLevel("TRANSIENT", 1000);
        public static final PersistenceLevel PERSISTENT = new PersistenceLevel("PERSISTENT", 2000);
        private String str;
        private int order;

        private PersistenceLevel(String string, int n) {
            this.str = string;
            this.order = n;
        }

        public int compareTo(Object object) {
            return this.order - ((PersistenceLevel)object).order;
        }

        public String toString() {
            return this.str;
        }
    }

    public static class AccessLevel
    implements Comparable {
        public static final AccessLevel ALL = new AccessLevel("ALL", 0);
        public static final AccessLevel DASML = new AccessLevel("DASML", 1000);
        public static final AccessLevel END_USER = new AccessLevel("END_USER", 0x7FFF0000);
        private String str;
        private int order;

        private AccessLevel(String string, int n) {
            this.str = string;
            this.order = n;
        }

        public int compareTo(Object object) {
            return this.order - ((AccessLevel)object).order;
        }

        public String toString() {
            return this.str;
        }
    }
}

