/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das;

import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.util.Crypt;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class DasProperties
extends Properties {
    private RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private boolean antiAlias;
    private boolean visualCues;
    private Logger logger;
    private static ArrayList propertyOrder;
    private static Editor editor;
    private static JFrame jframe;
    private static final DasProperties instance;

    private DasProperties() {
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.setDefaults();
        propertyOrder = new ArrayList();
        this.readPersistentProperties();
        this.logger = Logger.getLogger("das2");
        this.setPropertyOrder();
    }

    private void setPropertyOrder() {
        propertyOrder.add(0, "username");
        propertyOrder.add(1, "password");
        propertyOrder.add(2, "debugLevel");
        propertyOrder.add(3, "antiAlias");
        propertyOrder.add(4, "visualCues");
        for (String string : this.keySet()) {
            if (propertyOrder.contains(string)) continue;
            propertyOrder.add(string);
        }
    }

    private void setDefaults() {
        this.setProperty("username", "");
        this.setProperty("password", "");
        this.setProperty("debugLevel", "endUser");
        this.setProperty("antiAlias", "off");
        this.setProperty("visualCues", "off");
        this.setProperty("defaultServer", "http://www-pw.physics.uiowa.edu/das/dasServer");
    }

    public static RenderingHints getRenderingHints() {
        return DasProperties.instance.hints;
    }

    public static Logger getLogger() {
        return DasProperties.instance.logger;
    }

    public static DasProperties getInstance() {
        return instance;
    }

    private static TableModel getTableModel() {
        return new DasPropertiesTableModel();
    }

    private static JTable getJTable() {
        return new JTable(DasProperties.getTableModel()){
            {
                this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        String string = (String)propertyOrder.get(n);
                        if (string.equals("password") && n2 == 1) {
                            return super.getTableCellRendererComponent(jTable, "* * * *", bl, bl2, n, n2);
                        }
                        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    }
                });
            }

            public TableCellEditor getCellEditor(int n, int n2) {
                String string = (String)propertyOrder.get(n);
                if (string.equals("password")) {
                    return new DefaultCellEditor(new JPasswordField());
                }
                if (string.equals("debugLevel")) {
                    String[] stringArray = new String[]{"endUser", "dasDeveloper"};
                    return new DefaultCellEditor(new JComboBox<String>(stringArray));
                }
                if (string.equals("antiAlias")) {
                    String[] stringArray = new String[]{"on", "off"};
                    return new DefaultCellEditor(new JComboBox<String>(stringArray));
                }
                if (string.equals("visualCues")) {
                    String[] stringArray = new String[]{"on", "off"};
                    return new DefaultCellEditor(new JComboBox<String>(stringArray));
                }
                return super.getCellEditor(n, n2);
            }
        };
    }

    private static TableCellEditor getTableCellEditor() {
        return new DefaultCellEditor(new JTextField()){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                String string = (String)propertyOrder.get(n);
                if (string.equals("password")) {
                    return new JPasswordField();
                }
                if (string.equals("debugLevel")) {
                    String[] stringArray = new String[]{"endUser", "dasDeveloper"};
                    return new JList<String>(stringArray);
                }
                return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            }
        };
    }

    public static void showEditor() {
        jframe = new JFrame("Das Properities");
        editor = new Editor();
        jframe.setSize(400, 300);
        jframe.setContentPane(editor);
        jframe.setVisible(true);
    }

    public void readPersistentProperties() {
        try {
            String string = System.getProperty("user.home") + System.getProperty("file.separator") + ".das2rc";
            File file = new File(string);
            if (file.canRead()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    DasExceptionHandler.handle(iOException);
                }
            } else {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    this.store(fileOutputStream, "");
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    DasExceptionHandler.handle(iOException);
                }
            }
        }
        catch (SecurityException securityException) {
            DasDie.println(DasDie.INFORM, "Unable to read persistent properties");
        }
    }

    public void writePersistentProperties() {
        String string = System.getProperty("user.home") + System.getProperty("file.separator") + ".das2rc";
        File file = new File(string);
        if (file.canWrite()) {
            DasDie.println("Attempt to write .das2rc...");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.store(fileOutputStream, "");
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                DasExceptionHandler.handle(iOException);
            }
        } else {
            DasIOException dasIOException = new DasIOException("Can't write to file " + file);
            DasExceptionHandler.handle(dasIOException);
        }
    }

    static {
        instance = new DasProperties();
    }

    public static class Editor
    extends JPanel
    implements ActionListener {
        JButton saveButton;

        Editor() {
            this.setLayout(new BoxLayout(this, 1));
            JTable jTable = DasProperties.getJTable();
            this.add(jTable);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            this.saveButton = new JButton("Save");
            this.saveButton.setActionCommand("Save");
            this.saveButton.addActionListener(this);
            this.saveButton.setToolTipText("save to $HOME/.das2rc");
            jPanel.add(this.saveButton);
            JButton jButton = new JButton("Dismiss");
            jButton.addActionListener(this);
            jPanel.add(jButton);
            this.add(Box.createVerticalGlue());
            this.add(jPanel);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Save")) {
                instance.writePersistentProperties();
                this.setDirty(false);
            } else if (string.equals("Dismiss")) {
                jframe.dispose();
            }
        }

        public void setDirty(boolean bl) {
            if (bl) {
                this.saveButton.setText("Save*");
            } else {
                this.saveButton.setText("Save");
            }
        }
    }

    private static class DasPropertiesTableModel
    extends AbstractTableModel {
        private DasPropertiesTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return instance.size();
        }

        public Object getValueAt(int n, int n2) {
            String string;
            String string2 = (String)propertyOrder.get(n);
            if (n2 == 0) {
                string = string2;
            } else {
                string = instance.getProperty(string2);
                if (string2.equals("password")) {
                    string = "";
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)propertyOrder.get(n);
            if (string.equals("password")) {
                if (!object.toString().equals("")) {
                    object = Crypt.crypt(object.toString());
                }
            } else if (string.equals("debugLevel")) {
                String string2 = object.toString();
                if (string2.equals("endUser")) {
                    Logger.getLogger("").setLevel(Level.WARNING);
                    Logger.getLogger("das2").setLevel(Level.WARNING);
                } else if (string2.equals("dasDeveloper")) {
                    Logger.getLogger("").setLevel(Level.FINE);
                    Logger.getLogger("das2").setLevel(Level.FINE);
                } else {
                    instance.logger.setLevel(Level.parse(string2));
                }
                DasDie.setDebugVerbosityLevel(object.toString());
            }
            instance.setProperty(string, object.toString());
            editor.setDirty(true);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }
    }
}

