/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das;

import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.client.InputStreamMeter;
import edu.uiowa.physics.pw.das.dataset.DataSetCache;
import edu.uiowa.physics.pw.das.dataset.LimitSizeBytesDataSetCache;
import edu.uiowa.physics.pw.das.graph.DasAnnotation;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.system.LoggerId;
import edu.uiowa.physics.pw.das.system.MonitorFactory;
import edu.uiowa.physics.pw.das.util.ClassMap;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.Splash;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public class DasApplication {
    private static final DasApplication DEFAULT = new DasApplication();
    private JFrame mainFrame;
    private Boolean applet = null;
    private Boolean headless;
    private NameContext nameContext;
    private DataSetCache dataSetCache;
    public static final LoggerId APPLICATION_LOG = new LoggerId("");
    public static final LoggerId SYSTEM_LOG = new LoggerId("das2.system");
    public static final LoggerId GUI_LOG = new LoggerId("das2.gui");
    public static final LoggerId GRAPHICS_LOG = new LoggerId("das2.graphics");
    public static final LoggerId DATA_OPERATIONS_LOG = new LoggerId("das2.dataOperations");
    public static final LoggerId DATA_TRANSFER_LOG = new LoggerId("das2.dataTransfer");
    static ClassMap classNameMap = new ClassMap();
    Map hitsMap = new HashMap();
    InputStreamMeter meter;
    private boolean interactive = true;
    private MonitorFactory monitorFactory;

    public Logger getLogger() {
        return DasLogger.getLogger();
    }

    public Logger getLogger(LoggerId loggerId) {
        return DasLogger.getLogger(loggerId);
    }

    private DasApplication() {
        this.nameContext = new NameContext();
    }

    public NameContext getNameContext() {
        return this.nameContext;
    }

    public String suggestNameFor(Object object) {
        String string = (String)classNameMap.get(object.getClass());
        Integer n = (Integer)this.hitsMap.get(string);
        int n2 = n == null ? 0 : n + 1;
        this.hitsMap.put(string, new Integer(n2));
        return string + "_" + n2;
    }

    public static DasApplication getDefaultApplication() {
        return DEFAULT;
    }

    public final boolean isApplet() {
        if (this.applet == null) {
            return Thread.currentThread().getContextClassLoader().getClass().getName().indexOf("plugin") > -1;
        }
        return this.applet;
    }

    public void setApplet(boolean bl) {
        this.applet = bl;
    }

    public void setReloadLoggingProperties(boolean bl) {
        if (bl) {
            try {
                DasLogger.reload();
                DasLogger.printStatus();
            }
            catch (IOException iOException) {
                DasExceptionHandler.handle(iOException);
            }
        }
    }

    public boolean isReloadLoggingProperties() {
        return false;
    }

    private static boolean isX11() {
        String string = System.getProperty("os.name");
        return "SunOS".equals(string) || "Linux".equals(string);
    }

    public static File getDas2UserDirectory() {
        File file = System.getProperty("user.name").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
        file = new File(file, ".das2");
        return file;
    }

    public static boolean isHeadAvailable() {
        return true;
    }

    public boolean isHeadless() {
        if (this.headless != null) {
            return this.headless;
        }
        return "true".equals(System.getProperty("java.awt.headless"));
    }

    public void setHeadless(boolean bl) {
        this.headless = bl;
        if (bl) {
            System.setProperty("java.awt.headless", "true");
        } else {
            if (!DasApplication.isHeadAvailable()) {
                throw new IllegalArgumentException("attempt to unset headless when environment is headless.");
            }
            System.setProperty("java.awt.headless", "false");
        }
    }

    public DataSetCache getDataSetCache() {
        if (this.dataSetCache == null) {
            this.dataSetCache = new LimitSizeBytesDataSetCache(30000000L);
        }
        return this.dataSetCache;
    }

    public InputStreamMeter getInputStreamMeter() {
        if (this.meter == null) {
            this.meter = new InputStreamMeter();
        }
        return this.meter;
    }

    public JFrame createMainFrame(Container container) {
        return this.createMainFrame("Das2", container);
    }

    public JFrame createMainFrame(String string, Container container) {
        JFrame jFrame = this.createMainFrame(string);
        jFrame.getContentPane().add(container);
        jFrame.pack();
        jFrame.setVisible(true);
        return jFrame;
    }

    public JFrame createMainFrame() {
        return this.createMainFrame("Das2");
    }

    public JFrame createMainFrame(String string) {
        this.mainFrame = new JFrame(string);
        Preferences preferences = Preferences.userNodeForPackage(DasApplication.class);
        int n = preferences.getInt("xlocation", 20);
        int n2 = preferences.getInt("ylocation", 20);
        this.mainFrame.setLocation(n, n2);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DasApplication.this.quit();
            }
        });
        this.mainFrame.setDefaultCloseOperation(0);
        System.setProperty("sun.awt.exception.handler", DasExceptionHandler.class.getName());
        return this.mainFrame;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public void quit() {
        Preferences preferences = Preferences.userNodeForPackage(DasApplication.class);
        preferences.putInt("xlocation", this.mainFrame.getLocation().x);
        preferences.putInt("ylocation", this.mainFrame.getLocation().y);
        System.out.println("bye!" + this.mainFrame.getLocation());
        System.exit(0);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    public String getDas2Version() {
        return Splash.getVersion();
    }

    public MonitorFactory getMonitorFactory() {
        if (this.monitorFactory == null) {
            this.monitorFactory = new MonitorFactory();
        }
        return this.monitorFactory;
    }

    static {
        classNameMap.put(DasPlot.class, "plot");
        classNameMap.put(DasAxis.class, "axis");
        classNameMap.put(DasColorBar.class, "colorbar");
        classNameMap.put(DasRow.class, "row");
        classNameMap.put(DasColumn.class, "column");
        classNameMap.put(DasAnnotation.class, "annotation");
        classNameMap.put(Object.class, "object");
        classNameMap.put(DasCanvasComponent.class, "canvasComponent");
        classNameMap.put(DasCanvas.class, "canvas");
    }
}

