/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws.hr;

import edu.uiowa.physics.pw.apps.vgpws.Spacecraft;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.components.DasProgressPanel;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.GraphUtil;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.TimeParser;
import edu.uiowa.physics.pw.das.util.fileSystem.FileStorageModelNew;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;

public class MagDataSetDescriptor
extends DataSetDescriptor {
    FileStorageModelNew fsm;
    boolean fce;
    boolean availability;

    MagDataSetDescriptor(Spacecraft spacecraft, boolean bl) throws FileSystem.FileSystemOfflineException {
        this(spacecraft, bl, false);
    }

    MagDataSetDescriptor(Spacecraft spacecraft, boolean bl, boolean bl2) throws FileSystem.FileSystemOfflineException {
        this.fce = bl;
        this.availability = bl2;
        this.setSpacecraft(spacecraft);
    }

    private FileStorageModelNew getFileStorageModel(String string) throws FileSystem.FileSystemOfflineException {
        FileSystem fileSystem;
        try {
            fileSystem = FileSystem.create(new URL("http://www-pw.physics.uiowa.edu/~jbf/voyager/mag/vg" + string + "/"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        FileStorageModelNew fileStorageModelNew = FileStorageModelNew.create(fileSystem, "%Y-%m-%d.bmag");
        return fileStorageModelNew;
    }

    public void setSpacecraft(Spacecraft spacecraft) {
        block4: {
            try {
                if (spacecraft == Spacecraft.voyager1) {
                    this.fsm = this.getFileStorageModel("1");
                    break block4;
                }
                if (spacecraft == Spacecraft.voyager2) {
                    this.fsm = this.getFileStorageModel("2");
                    break block4;
                }
                throw new IllegalArgumentException("not supported spacecraft:" + spacecraft);
            }
            catch (FileSystem.FileSystemOfflineException fileSystemOfflineException) {
                DasExceptionHandler.handle(fileSystemOfflineException);
            }
        }
    }

    protected DataSet getDataSetImpl(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
        DatumRange datumRange = new DatumRange(datum, datum2);
        Object var7_6 = null;
        if (this.availability) {
            String[] stringArray = this.fsm.getNamesFor(datumRange);
            VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(Units.us2000, Units.seconds);
            for (int i = 0; i < stringArray.length; ++i) {
                DatumRange datumRange2 = this.fsm.getRangeFor(stringArray[i]);
                vectorDataSetBuilder.insertY(datumRange2.min(), datumRange2.width());
            }
            vectorDataSetBuilder.setProperty("cacheTag", FileStorageModelNew.getCacheTagFor(this.fsm, datumRange, stringArray));
            return vectorDataSetBuilder.toVectorDataSet();
        }
        File[] fileArray = this.fsm.getFilesFor(datumRange, dasProgressMonitor);
        TimeParser timeParser = TimeParser.create("%Y-%m-%dT%H:%M:%S.%{milli}Z");
        try {
            TimeLocationUnits timeLocationUnits = Units.us2000;
            Units units = this.fce ? Units.hertz : Units.dimensionless;
            VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(timeLocationUnits, units);
            for (int i = 0; i < fileArray.length; ++i) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i]));
                String string = bufferedReader.readLine();
                while (string != null) {
                    double d = Double.parseDouble(string.substring(25));
                    if (d > 9999.0) {
                        d = units.getFillDouble();
                    } else if (this.fce) {
                        d *= 28.0;
                    }
                    vectorDataSetBuilder.insertY(timeParser.parse(string.substring(0, 25)).getTime(timeLocationUnits), d);
                    string = bufferedReader.readLine();
                }
            }
            vectorDataSetBuilder.setProperty("cacheTag", FileStorageModelNew.getCacheTagFor(this.fsm, datumRange, fileArray));
            return vectorDataSetBuilder.toVectorDataSet();
        }
        catch (ParseException parseException) {
            throw new DasException(parseException.getMessage());
        }
        catch (IOException iOException) {
            throw new DasException(iOException.getMessage());
        }
    }

    public Units getXUnits() {
        return Units.us2000;
    }

    public static DataSetDescriptor newDataSetDescriptor(Map map) {
        Spacecraft spacecraft = Spacecraft.getByInt(Integer.parseInt((String)map.get("voyager")));
        boolean bl = Boolean.parseBoolean((String)map.get("fce"));
        boolean bl2 = map.get("availability") == null ? false : Boolean.parseBoolean((String)map.get("availability"));
        try {
            return new MagDataSetDescriptor(spacecraft, bl, bl2);
        }
        catch (FileSystem.FileSystemOfflineException fileSystemOfflineException) {
            throw new RuntimeException(fileSystemOfflineException);
        }
    }

    public static void main(String[] stringArray) throws DasException, FileSystem.FileSystemOfflineException {
        MagDataSetDescriptor magDataSetDescriptor = new MagDataSetDescriptor(Spacecraft.voyager2, true);
        DatumRange datumRange = DatumRangeUtil.parseTimeRangeValid("1979-07-28 through 1979-07-29");
        DataSet dataSet = magDataSetDescriptor.getDataSet(datumRange.min(), datumRange.max(), null, DasProgressPanel.createFramed("help!!!"));
        GraphUtil.visualize(dataSet);
    }
}

