/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws;

import edu.uiowa.physics.pw.apps.vgpws.Spacecraft;
import edu.uiowa.physics.pw.apps.vgpws.TCAComboBoxModel;
import edu.uiowa.physics.pw.apps.vgpws.Vg1pws;
import edu.uiowa.physics.pw.apps.vgpws.Vg1pwsDataSetDescriptor;
import edu.uiowa.physics.pw.apps.vgpws.Vg1pwsEventsDataSetDescriptor;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;

public class VgpwsOptionsPanel
extends JPanel {
    Vg1pws vg1pws;
    TCAComboBoxModel tcaModel;
    File root;
    URL SERVER_EVENTS_URL;
    static Preferences prefs;
    static String CURRENT_DIRECTORY_KEY;
    static String CURRENT_SPACECRAFT_KEY;
    static String CURRENT_DATASOURCE_KEY;
    static String CURRENT_OPTIONS_KEY;
    static String CURRENT_TCA_KEY;
    static String LOCAL_EVENTS_KEY;
    private JButton chooseLocalFSButton;
    private JRadioButton das2ServerSourceRB;
    private JCheckBox enableNetworkOptionsCB;
    private JCheckBox fceCheckBox;
    private JButton jButton1;
    private JLabel jLabel1;
    private JCheckBox localEventsCB;
    private JLabel localRootLabel;
    private JRadioButton localSourceRB;
    private JLabel networkOptionsLabel;
    private JCheckBox noiseFilterCB;
    private JCheckBox removeBackgroundCB;
    private JCheckBox removePlsCB;
    private JCheckBox removeSCEventsCB;
    private ButtonGroup sourceButtonGroup;
    private JComboBox tcaComboBox;
    private JLabel tcaLabel;
    private JComboBox voyagerSelector;

    public VgpwsOptionsPanel(Vg1pws vg1pws) {
        try {
            this.SERVER_EVENTS_URL = new URL("http://www-pw.physics.uiowa.edu/voyager/local1/");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        this.vg1pws = vg1pws;
        this.tcaModel = new TCAComboBoxModel(vg1pws, Spacecraft.voyager1);
        this.initComponents();
        prefs = Vg1pws.prefs;
        if (!vg1pws.localOnly) {
            this.readPrefs();
        }
        if (vg1pws.localOnly) {
            this.setNetworkOptionsEnabled(false);
        } else {
            this.networkOptionsLabel.setVisible(false);
            this.enableNetworkOptionsCB.setVisible(false);
        }
        this.removeBackgroundCB.setVisible(false);
    }

    protected void setRemovePLSInterference(boolean bl) {
        this.removePlsCB.setSelected(bl);
    }

    protected void setRemoveSCEvents(boolean bl) {
        this.removeSCEventsCB.setSelected(bl);
    }

    private void setNetworkOptionsEnabled(boolean bl) {
        if (!bl) {
            this.tcaModel.setSelectedItem("No Trajectory Parameters");
            this.das2ServerSourceRB.setEnabled(false);
            this.localSourceRB.setSelected(true);
            this.das2ServerSourceRB.setToolTipText("Network required for this option");
            this.tcaComboBox.setEnabled(false);
            this.tcaComboBox.setToolTipText("Network required for this option");
            this.tcaLabel.setEnabled(false);
            this.tcaLabel.setToolTipText("Network required for this option");
            this.fceCheckBox.setVisible(false);
            this.localEventsCB.setSelected(true);
            this.localEventsCB.setEnabled(false);
            this.localEventsCB.setToolTipText("Network required for this option");
        } else {
            this.das2ServerSourceRB.setEnabled(true);
            this.das2ServerSourceRB.setToolTipText(null);
            this.tcaComboBox.setEnabled(true);
            this.tcaComboBox.setToolTipText(null);
            this.tcaLabel.setEnabled(true);
            this.tcaLabel.setToolTipText(null);
            this.localEventsCB.setEnabled(true);
            this.localEventsCB.setToolTipText(null);
        }
    }

    private static String toURLArgsString(Map map) {
        try {
            StringBuffer stringBuffer = null;
            for (Object k : map.keySet()) {
                Object v = map.get(k);
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer("" + k + "=" + URLEncoder.encode((String)v, "US-ASCII"));
                    continue;
                }
                stringBuffer.append("&" + k + "=" + URLEncoder.encode((String)v, "US-ASCII"));
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    protected void setSpacecraft(Spacecraft spacecraft) {
        this.tcaModel.setSpacecraft(spacecraft);
        this.voyagerSelector.setSelectedIndex(spacecraft.toInt() - 1);
        this.tcaComboBox.setSelectedIndex(0);
    }

    protected void setOverlayFce(boolean bl) {
        this.fceCheckBox.setSelected(bl);
    }

    protected void setUseLocalFileSystem() {
        this.localSourceRB.setSelected(true);
    }

    private static Map toMap(String string) {
        try {
            String[] stringArray = string.split("&");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                String string2 = stringArray2[0];
                String string3 = URLDecoder.decode(stringArray2[1], "US_ASCII");
                hashMap.put(string2, string3);
            }
            return hashMap;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private Map getOptionsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("filterPLS", this.removePlsCB.isSelected() ? "true" : "false");
        hashMap.put("filterSpacecraftEvents", this.removeSCEventsCB.isSelected() ? "true" : "false");
        hashMap.put("noiseFilter", this.noiseFilterCB.isSelected() ? "true" : "false");
        hashMap.put("removeBackground", this.removeBackgroundCB.isSelected() ? "true" : "false");
        return hashMap;
    }

    private void setOptionsMap(Map map) {
        this.removePlsCB.setSelected("true".equals(map.get("filterPLS")));
        this.removeSCEventsCB.setSelected("true".equals(map.get("filterSpacecraftEvents")));
        this.noiseFilterCB.setSelected("true".equals(map.get("noiseFilter")));
        this.removeBackgroundCB.setSelected(false);
    }

    private DataSetDescriptor getDataSetDescriptor(Spacecraft spacecraft, Map map) throws UnsupportedEncodingException, DasException {
        String string;
        if (this.localSourceRB.isSelected()) {
            string = "class:edu.uiowa.physics.pw.apps.vgpws.Vg1pwsDataSetDescriptor?spacecraft=" + spacecraft.toInt() + "&root=" + URLEncoder.encode(this.root.toString(), "US-ASCII") + "&" + VgpwsOptionsPanel.toURLArgsString(map);
        } else if (this.das2ServerSourceRB.isSelected()) {
            string = "http://www-pw.physics.uiowa.edu/das/das2Server?das2_1/voyager" + spacecraft.toInt() + "/pws/sa-4s-pf.new";
        } else {
            throw new RuntimeException("source not selected");
        }
        DataSetDescriptor dataSetDescriptor = DataSetDescriptor.create(string);
        return dataSetDescriptor;
    }

    protected Spacecraft getSpacecraft() {
        Spacecraft spacecraft = Spacecraft.getByInt(this.voyagerSelector.getSelectedIndex() + 1);
        return spacecraft;
    }

    private URL getEventsURL() throws MalformedURLException {
        if (this.localSourceRB.isSelected()) {
            if (this.localEventsCB.isSelected()) {
                return this.root.toURL();
            }
            return this.SERVER_EVENTS_URL;
        }
        if (this.das2ServerSourceRB.isSelected()) {
            return this.SERVER_EVENTS_URL;
        }
        throw new RuntimeException("not selected");
    }

    protected void setLocalFileSystemRoot(File file) {
        this.root = file;
        this.localRootLabel.setText(file.toString());
    }

    protected void update() {
        try {
            Spacecraft spacecraft = this.getSpacecraft();
            Map map = this.getOptionsMap();
            Vg1pwsEventsDataSetDescriptor vg1pwsEventsDataSetDescriptor = new Vg1pwsEventsDataSetDescriptor(this.getEventsURL(), spacecraft);
            DataSetDescriptor dataSetDescriptor = this.getDataSetDescriptor(spacecraft, map);
            if (dataSetDescriptor instanceof Vg1pwsDataSetDescriptor) {
                ((Vg1pwsDataSetDescriptor)dataSetDescriptor).setEventsDataSetDescriptor(vg1pwsEventsDataSetDescriptor);
            }
            this.vg1pws.setDataSetDescriptor(dataSetDescriptor);
            this.vg1pws.setEventsDataSetDescriptor(vg1pwsEventsDataSetDescriptor);
            this.vg1pws.setFceRendererActive(this.fceCheckBox.isSelected());
            this.setTCA();
            if (!this.vg1pws.localOnly) {
                this.writePrefs();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void setTCA() {
        String string = this.tcaModel.getTCADataSetId();
        if (this.vg1pws.isUpdating()) {
            if (string.equals("")) {
                this.vg1pws.getTimeAxis().setDrawTca(false);
            } else {
                this.vg1pws.getTimeAxis().setDataPath(string);
                this.vg1pws.getTimeAxis().setDrawTca(true);
            }
        }
    }

    private void pickRoot() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.root);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.root = jFileChooser.getSelectedFile();
            String string = this.root == null ? "<html><i>directory not correctly specified</i></html>" : this.root.toString();
            this.localRootLabel.setText(string);
        }
    }

    private void writePrefs() throws BackingStoreException {
        prefs.put(LOCAL_EVENTS_KEY, this.localEventsCB.isSelected() ? "true" : "false");
        prefs.put(CURRENT_DIRECTORY_KEY, this.root.toString());
        prefs.put(CURRENT_OPTIONS_KEY, VgpwsOptionsPanel.toURLArgsString(this.getOptionsMap()));
        prefs.put(CURRENT_SPACECRAFT_KEY, this.getSpacecraft().toString());
        prefs.put(CURRENT_TCA_KEY, (String)this.tcaModel.getSelectedItem());
        prefs.flush();
    }

    private void readPrefs() {
        String string = prefs.get(CURRENT_DATASOURCE_KEY, "Das2Server");
        if (string.equals("Das2Server")) {
            this.das2ServerSourceRB.setSelected(true);
        } else {
            this.localSourceRB.setSelected(true);
        }
        this.root = new File(prefs.get(CURRENT_DIRECTORY_KEY, ""));
        this.setSpacecraft(Spacecraft.getByName(prefs.get(CURRENT_SPACECRAFT_KEY, Spacecraft.voyager1.toString())));
        this.localEventsCB.setSelected(prefs.get(LOCAL_EVENTS_KEY, "false").equals("true"));
        String string2 = prefs.get(CURRENT_OPTIONS_KEY, "filterPLS=true&filterSpacecraftEvents=true&noiseFilter=false&removeBackground=false");
        this.setOptionsMap(VgpwsOptionsPanel.toMap(string2));
        this.tcaModel.setSelectedItem(prefs.get(CURRENT_TCA_KEY, ""));
    }

    private void initComponents() {
        this.sourceButtonGroup = new ButtonGroup();
        this.voyagerSelector = new JComboBox();
        this.localSourceRB = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.chooseLocalFSButton = new JButton();
        this.das2ServerSourceRB = new JRadioButton();
        this.localEventsCB = new JCheckBox();
        this.removePlsCB = new JCheckBox();
        this.removeSCEventsCB = new JCheckBox();
        this.noiseFilterCB = new JCheckBox();
        this.removeBackgroundCB = new JCheckBox();
        this.localRootLabel = new JLabel();
        this.tcaComboBox = new JComboBox();
        this.tcaLabel = new JLabel();
        this.jButton1 = new JButton();
        this.fceCheckBox = new JCheckBox();
        this.networkOptionsLabel = new JLabel();
        this.enableNetworkOptionsCB = new JCheckBox();
        this.sourceButtonGroup.add(this.das2ServerSourceRB);
        this.sourceButtonGroup.add(this.localSourceRB);
        this.voyagerSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Voyager 1", "Voyager 2"}));
        this.voyagerSelector.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Spacecraft spacecraft = Spacecraft.getByInt(VgpwsOptionsPanel.this.voyagerSelector.getSelectedIndex() + 1);
                VgpwsOptionsPanel.this.setSpacecraft(spacecraft);
            }
        });
        this.localSourceRB.setText("Local");
        this.localSourceRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.localSourceRB.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel1.setText("Data Source Selector:");
        this.chooseLocalFSButton.setAction(new AbstractAction("Choose Root..."){

            public void actionPerformed(ActionEvent actionEvent) {
                VgpwsOptionsPanel.this.pickRoot();
            }
        });
        this.chooseLocalFSButton.setText("Choose Root...");
        this.das2ServerSourceRB.setSelected(true);
        this.das2ServerSourceRB.setText("Das2 Server");
        this.das2ServerSourceRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.das2ServerSourceRB.setMargin(new Insets(0, 0, 0, 0));
        this.localEventsCB.setText("use local events file");
        this.localEventsCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.localEventsCB.setMargin(new Insets(0, 0, 0, 0));
        this.removePlsCB.setSelected(true);
        this.removePlsCB.setText("remove PLS interference");
        this.removePlsCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.removePlsCB.setMargin(new Insets(0, 0, 0, 0));
        this.removeSCEventsCB.setSelected(true);
        this.removeSCEventsCB.setText("remove S/C events interference");
        this.removeSCEventsCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.removeSCEventsCB.setMargin(new Insets(0, 0, 0, 0));
        this.noiseFilterCB.setText("include noise filter");
        this.noiseFilterCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noiseFilterCB.setMargin(new Insets(0, 0, 0, 0));
        this.removeBackgroundCB.setText("remove background");
        this.removeBackgroundCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.removeBackgroundCB.setMargin(new Insets(0, 0, 0, 0));
        this.localRootLabel.setText("[moment...]");
        this.tcaComboBox.setModel(this.tcaModel);
        this.tcaComboBox.setSelectedIndex(0);
        this.tcaLabel.setText("Time Axis Annotations:");
        this.jButton1.setText("Update");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VgpwsOptionsPanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.fceCheckBox.setText("Overlay fce");
        this.fceCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fceCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.fceCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VgpwsOptionsPanel.this.fceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.networkOptionsLabel.setText("<html>Network options are initially disabled in this application.  If you have network access, and would like to have time axis annotations, enabling network options will allow for this. </html>");
        this.networkOptionsLabel.setVerticalAlignment(3);
        this.enableNetworkOptionsCB.setText("Enable Network options");
        this.enableNetworkOptionsCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableNetworkOptionsCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableNetworkOptionsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VgpwsOptionsPanel.this.enableNetworkOptionsCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(1).add(2, groupLayout.createSequentialGroup().addContainerGap().add(groupLayout.createParallelGroup(2).add(1, groupLayout.createSequentialGroup().add(groupLayout.createParallelGroup(1).add(groupLayout.createParallelGroup(1).add(2, this.tcaComboBox, 0, 134, Short.MAX_VALUE).add(this.voyagerSelector, -2, 90, -2).add(2, this.tcaLabel, -1, 134, Short.MAX_VALUE)).add(groupLayout.createSequentialGroup().add(this.fceCheckBox).addPreferredGap(0))).add(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().add(27, 27, 27).add(groupLayout.createParallelGroup(1).add(this.das2ServerSourceRB).add(this.jLabel1))).add(2, groupLayout.createSequentialGroup().add(27, 27, 27).add(groupLayout.createParallelGroup(2).add(1, groupLayout.createSequentialGroup().add(this.localSourceRB).addPreferredGap(0).add(this.chooseLocalFSButton)).add(1, groupLayout.createSequentialGroup().add(17, 17, 17).add(groupLayout.createParallelGroup(1).add(this.removePlsCB).add(this.localEventsCB).add(this.removeSCEventsCB, -1, 199, Short.MAX_VALUE).add(this.noiseFilterCB).add(this.removeBackgroundCB).add(this.localRootLabel, -2, 175, -2))))))).add(1, groupLayout.createSequentialGroup().add(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().add(10, 10, 10).add(this.enableNetworkOptionsCB)).add(this.networkOptionsLabel, 0, 0, Short.MAX_VALUE)).add(17, 17, 17).add(this.jButton1).addPreferredGap(0))).add(22, 22, 22)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().add(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().addContainerGap().add(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.das2ServerSourceRB).addPreferredGap(0).add(groupLayout.createParallelGroup(3).add(this.localSourceRB).add(this.chooseLocalFSButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(this.localRootLabel).add(13, 13, 13).add(groupLayout.createParallelGroup(3).add(this.localEventsCB).add(this.fceCheckBox))).add(groupLayout.createSequentialGroup().add(this.voyagerSelector, -2, -1, -2).add(27, 27, 27).add(this.tcaComboBox, -2, -1, -2)))).add(groupLayout.createSequentialGroup().add(40, 40, 40).add(this.tcaLabel))).addPreferredGap(0).add(this.removePlsCB).addPreferredGap(0).add(this.removeSCEventsCB).addPreferredGap(0).add(this.noiseFilterCB).addPreferredGap(0).add(this.removeBackgroundCB).addPreferredGap(0).add(this.networkOptionsLabel, -1, 53, Short.MAX_VALUE).addPreferredGap(0).add(groupLayout.createParallelGroup(3).add(this.enableNetworkOptionsCB).add(this.jButton1, -2, 24, -2)).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    private void enableNetworkOptionsCBActionPerformed(ActionEvent actionEvent) {
        this.setNetworkOptionsEnabled(this.enableNetworkOptionsCB.isSelected());
        if (!this.enableNetworkOptionsCB.isSelected()) {
            this.update();
        }
    }

    private void fceCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.vg1pws.setFceRendererActive(this.fceCheckBox.isSelected());
    }

    static {
        CURRENT_DIRECTORY_KEY = "currentDirectory";
        CURRENT_SPACECRAFT_KEY = "spacecraft";
        CURRENT_DATASOURCE_KEY = "dataSource";
        CURRENT_OPTIONS_KEY = "options";
        CURRENT_TCA_KEY = "tca";
        LOCAL_EVENTS_KEY = "localEvents";
    }
}

