/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Vg1pwsReader {
    private boolean filterPLS;
    DasProgressMonitor progressIndicator = null;
    static final int PWSA_RECSIZE = 48;
    static final byte CR2 = 1;
    static final byte CR3 = 2;
    static final byte CR4 = 3;
    static final byte CR5 = 4;
    static final byte CR6 = 5;
    static final byte CR1 = 7;
    static final byte GS10A = 8;
    static final byte GS3 = 10;
    static final byte GS7 = 12;
    static final byte GS6 = 14;
    static final byte OC2 = 22;
    static final byte OC1 = 23;
    static final byte CR5A = 24;
    static final byte GS10 = 25;
    static final byte GS8 = 26;
    static final byte UV5A = 29;
    static final double[] PWSA_freq = new double[]{10.0, 17.8, 31.1, 56.2, 100.0, 178.0, 311.0, 562.0, 1000.0, 1780.0, 3110.0, 5620.0, 10000.0, 17800.0, 31100.0, 56200.0};
    static final float[][] PWSA_bw = new float[][]{{2.99f, 3.77f, 7.5f, 10.06f, 13.3f, 29.8f, 59.5f, 106.0f, 133.0f, 211.0f, 298.0f, 421.0f, 943.0f, 2110.0f, 4210.0f, 5950.0f}, {2.16f, 3.58f, 4.5f, 10.7f, 13.8f, 28.8f, 39.8f, 75.9f, 75.9f, 151.0f, 324.0f, 513.0f, 832.0f, 1260.0f, 2400.0f, 3800.0f}};
    static final float PWS_elength = 7.07f;
    static final float zFill = Units.dimensionless.getFillFloat();
    float[][] cal = null;
    int spacecraft0 = -999;
    static float[] ton1 = new float[]{999.0f, 999.0f, 999.0f, 999.0f, 999.0f, 999.0f, 999.0f, 999.0f, 2.0f, 1.0f, -1.0f, -2.0f, -3.0f, 1.0f, 2.0f, 1.0f};
    static float[] ff = new float[]{-999.0f, 0.0f, -4.0f, 10.0f, -68.0f};
    static int PLShits;

    public Vg1pwsReader(Map hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.filterPLS = hashMap.containsKey("filterPLS") && hashMap.get("filterPLS").equals("true");
    }

    private void loadCalTable(String string, dataUnit dataUnit2) throws IOException {
        int n;
        InputStream inputStream;
        Object object;
        this.cal = new float[257][16];
        try {
            object = new URL(string);
            ((URL)object).openConnection();
            inputStream = ((URL)object).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            inputStream = new FileInputStream(string);
        }
        object = new BufferedReader(new InputStreamReader(inputStream));
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).info("Reading cal file " + string);
        for (n = 0; n < 256; ++n) {
            float f;
            int n2;
            String string2 = ((BufferedReader)object).readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string3);
            if (n3 != n) {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).severe("Error loading " + string);
                System.exit(-1);
            }
            if (dataUnit2 == dataUnit.SpectralDensity) {
                for (n2 = 0; n2 < 16; ++n2) {
                    string3 = stringTokenizer.nextToken();
                    f = Float.parseFloat(string3);
                    this.cal[n][n2] = f * f / 49.9849f / PWSA_bw[0][n2];
                }
                continue;
            }
            if (dataUnit2 == dataUnit.ElectricField) {
                for (n2 = 0; n2 < 16; ++n2) {
                    string3 = stringTokenizer.nextToken();
                    f = Float.parseFloat(string3);
                    this.cal[n][n2] = f / 7.07f;
                }
                continue;
            }
            if (dataUnit2 != dataUnit.PowerFlux) continue;
            for (n2 = 0; n2 < 16; ++n2) {
                string3 = stringTokenizer.nextToken();
                f = Float.parseFloat(string3);
                this.cal[n][n2] = f * f / 49.9849f / PWSA_bw[0][n2] / 376.73f;
            }
        }
        for (n = 0; n < 16; ++n) {
            this.cal[256][n] = this.cal[255][n];
        }
    }

    private static final int xINT1(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    private static final int xINT2(byte[] byArray, int n, int n2) {
        return (byArray[n] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    private static final int PWSA_y1900(byte[] byArray) {
        return Vg1pwsReader.xINT2(byArray, 1, 0);
    }

    private static final int PWSA_hoy(byte[] byArray) {
        return Vg1pwsReader.xINT2(byArray, 3, 2);
    }

    private static final int PWSA_soh(byte[] byArray) {
        return Vg1pwsReader.xINT2(byArray, 5, 4);
    }

    private static final int PWSA_msec(byte[] byArray) {
        return Vg1pwsReader.xINT2(byArray, 7, 6);
    }

    private static final int PWSA_mod16(byte[] byArray) {
        return Vg1pwsReader.xINT2(byArray, 9, 8);
    }

    private static final int PWSA_mod60(byte[] byArray) {
        return Vg1pwsReader.xINT2(byArray, 11, 10);
    }

    private static final int PWSA_line(byte[] byArray) {
        return Vg1pwsReader.xINT2(byArray, 13, 12);
    }

    private static final int PWSA_mode(byte[] byArray) {
        return Vg1pwsReader.xINT1(byArray, 14);
    }

    private static final int PWSA_sc(byte[] byArray) {
        return Vg1pwsReader.xINT1(byArray, 15);
    }

    private static final int PWSA_dn(byte[] byArray, int n) {
        return Vg1pwsReader.xINT2(byArray, (n << 1) + 17, (n << 1) + 16);
    }

    private static final int PWSA_year(byte[] byArray) {
        return Vg1pwsReader.PWSA_y1900(byArray) + 1900;
    }

    private static final int PWSA_day(byte[] byArray) {
        return Vg1pwsReader.PWSA_hoy(byArray) / 24;
    }

    private static final int PWSA_hour(byte[] byArray) {
        return Vg1pwsReader.PWSA_hoy(byArray) % 24;
    }

    private static final int PWSA_minute(byte[] byArray) {
        return Vg1pwsReader.PWSA_soh(byArray) / 60;
    }

    private static final int PWSA_sec(byte[] byArray) {
        return Vg1pwsReader.PWSA_soh(byArray) % 60;
    }

    private static final int PWSA_msod(byte[] byArray) {
        return Vg1pwsReader.PWSA_msec(byArray) + Vg1pwsReader.PWSA_soh(byArray) * 1000 + Vg1pwsReader.PWSA_hour(byArray) * 3600000;
    }

    int datcorLookupJJ(byte[] byArray) {
        int n = Vg1pwsReader.PWSA_year(byArray);
        float f = ((float)Vg1pwsReader.PWSA_soh(byArray) + (float)Vg1pwsReader.PWSA_hoy(byArray) * 3600.0f) / 86400.0f;
        int n2 = n > 1977 ? (n >= 1979 ? 2 : ((double)f > 10.835995 ? 2 : 3)) : ((double)f <= 267.032638889 ? 1 : ((double)f <= 283.666666667 ? 2 : ((double)f <= 312.841666667 ? 3 : ((double)f <= 335.912222222 ? 4 : 3))));
        return n2;
    }

    private static void PLSInterferenceCorrection(byte[] byArray, int[] nArray) {
        boolean bl;
        double d = TimeUtil.convert(1960, 0, 1, 0, 0, 0.0, Units.us2000);
        double d2 = TimeUtil.convert(2000, 0, 193, 7, 0, 0.0, Units.us2000);
        double d3 = TimeUtil.convert(2003, 0, 157, 7, 0, 0.0, Units.us2000);
        double d4 = TimeUtil.convert(2100, 0, 1, 0, 0, 0.0, Units.us2000);
        double d5 = TimeUtil.convert(Vg1pwsReader.PWSA_year(byArray), 0, Vg1pwsReader.PWSA_day(byArray), Vg1pwsReader.PWSA_hour(byArray), Vg1pwsReader.PWSA_minute(byArray), (double)Vg1pwsReader.PWSA_sec(byArray) + (double)Vg1pwsReader.PWSA_msec(byArray) / 1000.0, Units.us2000);
        boolean bl2 = bl = Vg1pwsReader.PWSA_sc(byArray) == 1 && (d < d5 && d5 < d2 || d3 < d5 && d5 < d4) || Vg1pwsReader.PWSA_sc(byArray) == 2;
        if (bl) {
            ++PLShits;
            int n = Vg1pwsReader.PWSA_line(byArray);
            int n2 = Vg1pwsReader.PWSA_mod60(byArray);
            if (n == 1 && n2 % 4 == 3) {
                nArray[7] = 0;
                nArray[6] = 0;
            }
            if (n == 267 && n2 % 4 == 3) {
                nArray[7] = 0;
                nArray[6] = 0;
            }
        }
    }

    private XTaggedYScan vg1pwssd(byte[] byArray, TimeLocationUnits timeLocationUnits) {
        int n;
        int[] nArray = new int[16];
        float[] fArray = new float[16];
        for (n = 0; n < 16; ++n) {
            nArray[n] = Vg1pwsReader.PWSA_dn(byArray, n);
            if ((nArray[n] & 0x8000) != 32768) continue;
            nArray[n] = 0;
        }
        if (this.filterPLS) {
            Vg1pwsReader.PLSInterferenceCorrection(byArray, nArray);
        }
        switch (Vg1pwsReader.PWSA_mode(byArray)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                int n2;
                for (n = 0; n < 16; ++n) {
                    if (nArray[n] > 0) {
                        if (Vg1pwsReader.PWSA_sc(byArray) == 2 && n > 7) {
                            int n3;
                            double d = nArray[n];
                            n2 = this.datcorLookupJJ(byArray);
                            if (d <= 65.0) {
                                d = 64.0;
                            }
                            if ((n3 = (int)(d = d < (double)(76.0f + ff[n2]) ? (double)ton1[n] + 255.0 - (235.0 + (double)8.6f * (68.0 + (double)ff[n2]) - 8.6 * d) : (double)ton1[n] + 255.0 - (95.0 + 0.99 * (145.3 + (double)ff[n2]) - (double)0.99f * d))) < 1) {
                                n3 = 1;
                            }
                            if (n3 > 255) {
                                n3 = 255;
                            }
                            fArray[n] = this.cal[n3][n];
                            continue;
                        }
                        fArray[n] = this.cal[nArray[n]][n];
                        continue;
                    }
                    fArray[n] = 0.0f;
                }
                break;
            }
            case 24: 
            case 29: {
                int n2;
                n = Vg1pwsReader.PWSA_sc(byArray);
                for (int i = 0; i < 16; ++i) {
                    if (nArray[i] > 0) {
                        float f = (float)nArray[i] / 4.0f;
                        if (n == 2 && i > 7) {
                            if (f <= 65.0f) {
                                f = 64.0f;
                            }
                            f = f <= 72.0f ? ton1[i] - 530.4f + 8.6f * f : ton1[i] + 20.113f + 0.99f * f;
                        }
                        if ((n2 = (int)f) < 1) {
                            n2 = 1;
                        }
                        if (n2 > 255) {
                            n2 = 255;
                        }
                        float f2 = this.cal[n2][i];
                        float f3 = this.cal[n2 + 1][i];
                        fArray[i] = f2 + (f3 - f2) * (f - (float)n2);
                        continue;
                    }
                    fArray[i] = 0.0f;
                }
                break;
            }
            default: {
                DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).severe("ERROR unexpected telemetry mode " + Vg1pwsReader.PWSA_mode(byArray));
                System.exit(-1);
            }
        }
        for (n = 0; n < 16; ++n) {
            if (!((double)fArray[n] <= 0.0)) continue;
            fArray[n] = zFill;
        }
        XTaggedYScan xTaggedYScan = new XTaggedYScan();
        xTaggedYScan.z = fArray;
        xTaggedYScan.x = TimeUtil.convert(Vg1pwsReader.PWSA_year(byArray), 0, Vg1pwsReader.PWSA_day(byArray), Vg1pwsReader.PWSA_hour(byArray), Vg1pwsReader.PWSA_minute(byArray), (double)Vg1pwsReader.PWSA_sec(byArray) + (double)Vg1pwsReader.PWSA_msec(byArray) / 1000.0, timeLocationUnits);
        return xTaggedYScan;
    }

    public TableDataSet readFile(String string, dataUnit dataUnit2) throws IOException {
        Object object;
        PLShits = 0;
        TableDataSetBuilder tableDataSetBuilder = null;
        TimeLocationUnits timeLocationUnits = Units.us2000;
        long l = 0L;
        if (this.progressIndicator != null) {
            l = this.progressIndicator.getTaskProgress();
        }
        FileInputStream fileInputStream = null;
        MappedByteBuffer mappedByteBuffer = null;
        File file = new File(string);
        fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        if (fileChannel.size() == 0L) {
            throw new IOException("zero-length file: " + string);
        }
        DasApplication.getDefaultApplication().getLogger().info("Reading url " + string);
        byte[] byArray = new byte[48];
        boolean bl = false;
        int n = 0;
        double d = Double.MAX_VALUE;
        Vector<XTaggedYScan> vector = new Vector<XTaggedYScan>();
        mappedByteBuffer.get(byArray);
        n += 48;
        int n2 = Vg1pwsReader.PWSA_sc(byArray);
        if (this.spacecraft0 != n2) {
            String string2 = "";
            if (n2 == 1) {
                string2 = file.getParent() + File.separator + "VG1PWSCL.TAB";
            } else if (n2 == 2) {
                string2 = file.getParent() + File.separator + "VG2PWSCL.TAB";
            } else {
                DasDie.println("Invalid spacecraft (PWSA_sc()), aborting");
                System.exit(-2);
            }
            DasLogger.getLogger().info("Reading calibration from " + string2);
            this.loadCalTable(string2, dataUnit2);
            this.spacecraft0 = n2;
        }
        ((ByteBuffer)mappedByteBuffer).rewind();
        boolean bl2 = true;
        while (mappedByteBuffer.remaining() >= 48) {
            double d2;
            mappedByteBuffer.get(byArray);
            n += 48;
            object = this.vg1pwssd(byArray, timeLocationUnits);
            vector.add((XTaggedYScan)object);
            switch (Vg1pwsReader.PWSA_mode(byArray)) {
                case 24: 
                case 29: {
                    d2 = 16.0;
                    break;
                }
                default: {
                    d2 = 4.0;
                }
            }
            double d3 = d = d2 < d ? d2 : d;
            if (this.progressIndicator == null) continue;
            this.progressIndicator.setTaskProgress(l + (long)n);
        }
        tableDataSetBuilder = new TableDataSetBuilder(timeLocationUnits, Units.dimensionless, Units.dimensionless);
        tableDataSetBuilder.setProperty("xTagWidth", Datum.create(d, Units.seconds));
        tableDataSetBuilder.setProperty("yTagWidth", Datum.create(80, Units.percentIncrease));
        object = new double[PWSA_freq.length];
        for (int i = 0; i < PWSA_freq.length; ++i) {
            object[i] = PWSA_freq[i];
        }
        double[] dArray = new double[((Object)object).length];
        for (int i = 0; i < vector.size(); ++i) {
            XTaggedYScan xTaggedYScan = (XTaggedYScan)vector.get(i);
            Vg1pwsReader.copyFloatToDouble(xTaggedYScan.z, dArray);
            tableDataSetBuilder.insertYScan(Datum.create(xTaggedYScan.x, (Units)timeLocationUnits), DatumVector.newDatumVector((double[])object, Units.dimensionless), DatumVector.newDatumVector(dArray, Units.dimensionless));
        }
        DasApplication.getDefaultApplication().getLogger().fine("PLS hits=" + PLShits);
        if (this.progressIndicator != null) {
            this.progressIndicator.finished();
        }
        return tableDataSetBuilder.toTableDataSet();
    }

    private static void copyFloatToDouble(float[] fArray, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = fArray[i];
        }
    }

    void setDasProgressMonitor(DasProgressMonitor dasProgressMonitor) {
        this.progressIndicator = dasProgressMonitor;
    }

    public static class dataUnit {
        public static final dataUnit ElectricField = new dataUnit("V/m");
        public static final dataUnit SpectralDensity = new dataUnit("V!u2!n/m!u2!n/Hz");
        public static final dataUnit PowerFlux = new dataUnit("W/m!u2!n/Hz");
        private String unitsString;

        dataUnit(String string) {
            this.unitsString = string;
        }

        public String toString() {
            return this.unitsString;
        }
    }

    private class XTaggedYScan
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = -5171867293621291751L;
        public double x;
        public float[] z;

        public XTaggedYScan() {
        }

        public XTaggedYScan(double d, float[] fArray) {
            this.x = d;
            this.z = (float[])fArray.clone();
        }

        public Object clone() {
            XTaggedYScan xTaggedYScan = null;
            try {
                xTaggedYScan = (XTaggedYScan)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
            xTaggedYScan.z = new float[this.z.length];
            System.arraycopy(this.z, 0, xTaggedYScan.z, 0, this.z.length);
            xTaggedYScan.x = this.x;
            return xTaggedYScan;
        }

        public String toString() {
            int n;
            String string = "[";
            for (n = 0; n < this.z.length - 1; ++n) {
                string = string + this.z[n] + ",";
            }
            string = string + this.z[n] + "]";
            return "x tag: " + this.x + "\n z values: " + string + "\n";
        }
    }
}

