/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws;

import edu.uiowa.physics.pw.apps.vgpws.Spacecraft;
import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.EnumerationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;

public class Vg1pwsEventsDataSetDescriptor
extends DataSetDescriptor {
    FileSystem rootWfs = null;
    Spacecraft sc;
    EnumerationUnits eventUnit;

    public Vg1pwsEventsDataSetDescriptor(URL uRL, Spacecraft spacecraft) throws FileSystem.FileSystemOfflineException {
        this.rootWfs = FileSystem.create(uRL);
        this.sc = spacecraft;
        this.eventUnit = new EnumerationUnits("voyager" + spacecraft.toInt() + "Events");
    }

    public DataSet getDataSetImpl(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) {
        if (this.rootWfs == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        int n = TimeUtil.toTimeStruct((Datum)datum).year;
        int n2 = TimeUtil.toTimeStruct((Datum)datum2).year;
        try {
            VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(Units.us2000, this.eventUnit);
            vectorDataSetBuilder.addPlane("xTagWidth", Units.seconds);
            for (int i = n; i <= n2; ++i) {
                FileObject fileObject = this.rootWfs.getFileObject("DATA/ANCILLARY/EVENTS" + this.sc.toInt() + "/VG" + this.sc.toInt() + "_EVENTS_" + i + ".TAB");
                if (fileObject.exists()) {
                    DasApplication.getDefaultApplication().getLogger().info("reading file " + fileObject);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        Datum datum4;
                        Datum datum5;
                        String[] stringArray = string.split(" ");
                        try {
                            datum5 = TimeUtil.create(stringArray[0]);
                        }
                        catch (ParseException parseException) {
                            datum5 = null;
                        }
                        try {
                            datum4 = TimeUtil.create(stringArray[1]);
                        }
                        catch (ParseException parseException) {
                            datum4 = null;
                        }
                        if (datum5 != null && datum4 != null) {
                            vectorDataSetBuilder.insertY(datum5.doubleValue(Units.us2000), datum4.subtract(datum5).doubleValue(Units.seconds), "xTagWidth");
                            vectorDataSetBuilder.insertY(datum5.doubleValue(Units.us2000), this.eventUnit.createDatum(stringArray[2]).doubleValue(this.eventUnit));
                        } else {
                            DasExceptionHandler.handle(new DasException("could not parse line \"" + string + "\" in file " + fileObject));
                        }
                        string = bufferedReader.readLine();
                    }
                    bufferedReader.close();
                    continue;
                }
                DasApplication.getDefaultApplication().getLogger().info("couldn't find file " + fileObject);
            }
            vectorDataSetBuilder.setProperty("cacheTag", new CacheTag(TimeUtil.createTimeDatum(n, 1, 1, 0, 0, 0, 0), TimeUtil.createTimeDatum(n2 + 1, 1, 1, 0, 0, 0, 0), null));
            return vectorDataSetBuilder.toVectorDataSet();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Units getXUnits() {
        return Units.us2000;
    }

    public void setRoot(URL uRL) {
        Object object;
        try {
            object = FileSystem.create(uRL);
        }
        catch (IOException iOException) {
            DasExceptionHandler.handle(iOException);
            return;
        }
        object = this.rootWfs.getFileObject("DATA/EVENTS" + this.sc.toInt() + "/VG" + this.sc.toInt() + "_EVENTS_2003.TAB");
        if (!((FileObject)object).exists()) {
            DasExceptionHandler.handle(new DasException("should have found " + object + ", no events will be indicated"));
        } else {
            this.rootWfs = this.rootWfs;
        }
    }

    public String toString() {
        return "Vg1pwsEventsDSD " + this.sc;
    }
}

